/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.Version;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonMetadata;
import org.ow2.jonas.addon.deploy.api.deployable.ISortableDeployable;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonDeployer;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonDeployerLog;
import org.ow2.jonas.addon.deploy.api.deployer.IConfDeployer;
import org.ow2.jonas.addon.deploy.api.util.IAddonLogEntry;
import org.ow2.jonas.addon.deploy.impl.deployable.AddonDeployableImpl;
import org.ow2.jonas.addon.deploy.impl.deployable.AddonProvidesRequirements;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;
import org.ow2.jonas.lib.work.LogEntryImpl;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.multitenant.MultitenantService;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.properties.ServiceProperties;
import org.ow2.jonas.workcleaner.DeployerLogException;
import org.ow2.jonas.workcleaner.IDeployerLog;
import org.ow2.jonas.workcleaner.LogEntry;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployable.UnknownDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.ee.deploy.api.report.IDeploymentReport;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.ee.deploy.impl.report.DeploymentReport;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.exceptions.InvalidRepositoryException;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.plan.repository.api.IRepositoryManager;
import org.ow2.util.plan.repository.api.RepositoryIdCollisionException;
import org.ow2.util.url.URLUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AddonDeployerImpl
extends AbsDeployer<IAddonDeployable>
implements IAddonDeployer {
    public final String SERVICE_REGISTRATION_SERVICE_PROPERTY = "service";
    public static final String XSD_RESOURCE = "/META-INF/jonas-addon-1.0.xsd";
    public static final String JONAS_CLEAN_CACHE_PROPERTY = "jonas.cache.clean";
    public static final long MAX_WAITING_TIME = 1000L;
    public static final long SLEEPING_TIME = 50L;
    private static Log logger = LogFactory.getLog(AddonDeployerImpl.class);
    private ServerProperties serverProperties;
    private IDeployableHelper deployableHelper;
    private Map<URL, IAddonDeployable> addons = null;
    private IAddonDeployerLog<IAddonLogEntry> deployerLog;
    private IDeployerLog workCleanerLog;
    private IDeployerManager deployerManager;
    private BundleContext bundleContext;
    private IConfDeployer confDeployer;
    private ServiceManager serviceManager;
    private boolean isInitialized;
    private List<ServiceRegistration> serviceRegistrations;
    private MultitenantService multitenantService;
    private IRepositoryManager repositoryManager;
    private Map<IAddonDeployable, Repository> repositories;
    private long addonId = 0L;

    public AddonDeployerImpl(ServerProperties serverProperties, IDeployableHelper deployableHelper, IAddonDeployerLog<IAddonLogEntry> deployerLog, IDeployerManager deployerManager, BundleContext bundleContext, ServiceManager serviceManager, IDeployerLog<LogEntry> workCleanerLog, IRepositoryManager repositoryManager, IConfDeployer confDeployer) {
        this.serverProperties = serverProperties;
        this.deployableHelper = deployableHelper;
        this.deployerLog = deployerLog;
        this.workCleanerLog = workCleanerLog;
        this.deployerManager = deployerManager;
        this.addons = new LinkedHashMap<URL, IAddonDeployable>();
        this.bundleContext = bundleContext;
        this.serviceManager = serviceManager;
        this.confDeployer = confDeployer;
        this.confDeployer.setAddonDeployer((IAddonDeployer)this);
        this.repositoryManager = repositoryManager;
        this.repositories = new HashMap<IAddonDeployable, Repository>();
        this.isInitialized = false;
        this.serviceRegistrations = new ArrayList<ServiceRegistration>();
        this.deployerManager.register((IDeployer)this);
        this.checkLogs();
    }

    private void checkLogs() {
        HashMap<String, String> addonsToUndeploy = new HashMap<String, String>();
        HashMap<File, Integer> addonsToInstall = new HashMap<File, Integer>();
        Vector logEntries = this.deployerLog.getEntries();
        Vector<IAddonLogEntry> logEntriesToRemove = new Vector<IAddonLogEntry>();
        for (IAddonLogEntry logEntry : logEntries) {
            File orginalFile = logEntry.getOriginal();
            File unpackedFile = logEntry.getCopy();
            int state = logEntry.getState();
            boolean isInstalledFromACommand = logEntry.isInstalledFromACommand();
            if (orginalFile == null || !orginalFile.exists()) {
                addonsToUndeploy.put(logEntry.getName(), unpackedFile.getAbsolutePath());
                logEntriesToRemove.add(logEntry);
                continue;
            }
            if (!isInstalledFromACommand) continue;
            addonsToInstall.put(orginalFile, state);
        }
        this.retrieveJOnASConfiguration(addonsToUndeploy);
        for (IAddonLogEntry logEntry : logEntriesToRemove) {
            try {
                this.deployerLog.removeEntry((LogEntry)logEntry);
                logger.info((Object)"''{0}'' Addon Deployable is now undeployed", new Object[]{logEntry.getOriginal().getAbsolutePath()});
            }
            catch (DeployerLogException e) {
                logger.error((Object)("Cannot remove log entry " + logEntry.getName() + "."), new Object[]{e});
            }
        }
        ArrayList<IDeployable<IAddonDeployable>> addonsToStart = new ArrayList<IDeployable<IAddonDeployable>>();
        for (Map.Entry entry : addonsToInstall.entrySet()) {
            File file = (File)entry.getKey();
            Integer state = (Integer)entry.getValue();
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
            IAddonDeployable deployable = null;
            try {
                deployable = (IAddonDeployable)IAddonDeployable.class.cast(this.deployableHelper.getDeployable(archive));
            }
            catch (DeployableHelperException e) {
                logger.error((Object)("Could get the deployable instance of the archive " + file.getAbsolutePath()), new Object[]{e});
            }
            if (deployable == null) continue;
            IDeployable<IAddonDeployable> installed = null;
            try {
                installed = this.install((IDeployable<IAddonDeployable>)deployable, true);
            }
            catch (DeployerException e) {
                logger.error((Object)("Could not install addon deployable " + deployable.getShortName()), new Object[]{e});
            }
            if (installed == null || 32 != state) continue;
            addonsToStart.add(installed);
        }
        if (!addonsToStart.isEmpty()) {
            List<AddonProvidesRequirements> addonProvidesRequirementsList = this.getAddonProvidesRequirementsList(addonsToStart);
            AddonUtil.sort(addonProvidesRequirementsList);
            for (AddonProvidesRequirements addonProvidesRequirements : addonProvidesRequirementsList) {
                IAddonDeployable addon = (IAddonDeployable)IAddonDeployable.class.cast(addonProvidesRequirements.getDeployable());
                try {
                    this.start(addon.getMetadata().getName());
                }
                catch (DeployerException e) {
                    logger.error((Object)("Could not start addon " + addon.getMetadata().getName()), new Object[]{e});
                }
            }
        }
    }

    private void retrieveJOnASConfiguration(String addonName, String unpackedFile) {
        if (addonName != null && unpackedFile != null) {
            HashMap<String, String> addonsToUndeploy = new HashMap<String, String>();
            addonsToUndeploy.put(addonName, unpackedFile);
            this.retrieveJOnASConfiguration(addonsToUndeploy);
        }
    }

    private void retrieveJOnASConfiguration(Map<String, String> addonsToUndeploy) {
        for (String string : addonsToUndeploy.keySet()) {
            try {
                this.confDeployer.uninstall(string);
            }
            catch (DeployerException e) {
                logger.error((Object)("Could not uninstall the configuration of the addon " + string), new Object[]{e});
            }
        }
        if (!Boolean.getBoolean(JONAS_CLEAN_CACHE_PROPERTY)) {
            for (Map.Entry entry : addonsToUndeploy.entrySet()) {
                String unpackedDeployablePath = (String)entry.getValue();
                IAddonDeployable unpackedDeployable = (IAddonDeployable)AddonUtil.getDeployable(this.deployableHelper, new File(unpackedDeployablePath));
                this.updateDeployables(unpackedDeployablePath, unpackedDeployable, false);
                List sortableDeployables = unpackedDeployable.getKnownDeployables();
                if (sortableDeployables == null) continue;
                ArrayList<ISortableDeployable> persistentSortableDeployable = new ArrayList<ISortableDeployable>();
                for (ISortableDeployable sortableDeployable : sortableDeployables) {
                    IDeployable deployable = sortableDeployable.getDeployable();
                    if (!(deployable instanceof OSGiDeployable)) continue;
                    persistentSortableDeployable.add(sortableDeployable);
                }
                List<IDeploymentReport> deploymentReports = this.undeploySortableDeployables(persistentSortableDeployable);
                int count = 0;
                for (IDeploymentReport deploymentReport : deploymentReports) {
                    if (deploymentReport.isDeploymentOk()) continue;
                    logger.error((Object)("The deployable " + deploymentReport.getDeployable().getShortName() + " could not be undeployed."), new Object[]{deploymentReport.getException()});
                    ++count;
                }
                if (count <= 0) continue;
                logger.error((Object)("The addon " + (String)entry.getKey() + " cannot be undeployed"), new Object[0]);
            }
        }
    }

    private IAddonDeployable getParent(URL originalURL) {
        IAddonDeployable parent = null;
        String name = new File(originalURL.getFile()).getName();
        ArrayList<IAddonDeployable> addons = new ArrayList<IAddonDeployable>(this.getAddons());
        Collections.reverse(addons);
        for (IAddonDeployable addon : addons) {
            File file;
            URL url = null;
            try {
                url = ((IAddonDeployable)addon.getOriginalDeployable()).getArchive().getURL();
            }
            catch (ArchiveException e) {
                logger.error((Object)("Could not get the url of the deployable " + addon), new Object[]{e});
            }
            if (url == null || !(file = new File(new File(url.getFile(), "deploy"), name)).exists()) continue;
            return addon;
        }
        return parent;
    }

    public IDeployable<IAddonDeployable> install(IDeployable<IAddonDeployable> deployable, boolean installFromACommand) throws DeployerException {
        IAddonDeployable parent;
        URL originalURL;
        File unpackedFile;
        IAddonMetadata addonMetadata;
        String unpackedFileName;
        File originalFile = null;
        try {
            originalFile = URLUtils.urlToFile((URL)deployable.getArchive().getURL());
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the deployable " + deployable.getShortName(), (Throwable)e);
        }
        IAddonLogEntry logEntry = (IAddonLogEntry)this.deployerLog.getEntry(originalFile);
        boolean isAlreadyInstalled = originalFile.exists() && logEntry != null;
        IAddonDeployable unpackedDeployable = null;
        String lastModifiedOriginalFileName = null;
        try {
            lastModifiedOriginalFileName = FileUtils.lastModifiedFileName((File)originalFile);
        }
        catch (FileUtilsException e) {
            throw new DeployerException("Cannot get the last modified file name of " + originalFile.getAbsolutePath(), (Throwable)e);
        }
        if (logEntry != null && !lastModifiedOriginalFileName.equals(unpackedFileName = logEntry.getCopy().getName())) {
            logger.info((Object)"Deployable ''{0}'' has been updated.", new Object[]{deployable});
            IAddonLogEntry addonLogEntry = (IAddonLogEntry)this.deployerLog.getEntry(originalFile);
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)addonLogEntry.getCopy());
            try {
                unpackedDeployable = (IAddonDeployable)IAddonDeployable.class.cast(this.deployableHelper.getDeployable(archive));
                unpackedDeployable.setOriginalDeployable((IDeployable)IAddonDeployable.class.cast(deployable));
            }
            catch (DeployableHelperException e) {
                throw new DeployerException("Cannot get the deployable " + originalFile, (Throwable)e);
            }
            addonMetadata = null;
            try {
                addonMetadata = AddonUtil.getAddonMetadata(AddonUtil.getAddonMetadataFile(unpackedDeployable.getArchive()), logEntry.getCopy().getAbsolutePath());
                unpackedDeployable.setMetadata(addonMetadata);
            }
            catch (Exception e) {
                logger.warn((Object)"Addon metadata are incorrect", new Object[]{e});
            }
            String name = addonLogEntry.getName();
            this.retrieveJOnASConfiguration(name, addonLogEntry.getCopy().getAbsolutePath());
            try {
                this.deployerLog.removeEntry((LogEntry)addonLogEntry);
            }
            catch (DeployerLogException e) {
                logger.error((Object)("Cannot remove log entry of the file " + originalFile.getAbsolutePath()), new Object[]{e});
            }
            isAlreadyInstalled = false;
        }
        if (isAlreadyInstalled) {
            File unpackedFile2 = logEntry.getCopy();
            if (unpackedFile2 == null || !unpackedFile2.exists()) {
                File folder = new File(AddonUtil.getAddonsWorkDirectory(this.serverProperties));
                try {
                    unpackedDeployable = (IAddonDeployable)UnpackDeployableHelper.unpack((IDeployable)((IDeployable)IAddonDeployable.class.cast(deployable)), (File)folder, (String)lastModifiedOriginalFileName, (boolean)false, (IDeployableHelper)this.deployableHelper);
                }
                catch (Exception e) {
                    throw new DeployerException("Cannot unpacked archive for '" + deployable.getArchive() + "'", (Throwable)e);
                }
            } else {
                IArchive archive = ArchiveManager.getInstance().getArchive((Object)((IAddonLogEntry)this.deployerLog.getEntry(originalFile)).getCopy());
                try {
                    unpackedDeployable = (IAddonDeployable)IAddonDeployable.class.cast(this.deployableHelper.getDeployable(archive));
                    unpackedDeployable.setOriginalDeployable((IDeployable)IAddonDeployable.class.cast(deployable));
                }
                catch (DeployableHelperException e) {
                    throw new DeployerException("Cannot get the deployable " + originalFile, (Throwable)e);
                }
            }
        } else {
            logger.info((Object)"Installing ''{0}''", new Object[]{deployable.getShortName()});
            unpackedDeployable = null;
            File folder = new File(AddonUtil.getAddonsWorkDirectory(this.serverProperties));
            try {
                originalFile = URLUtils.urlToFile((URL)deployable.getArchive().getURL());
                unpackedDeployable = (IAddonDeployable)UnpackDeployableHelper.unpack((IDeployable)((IDeployable)IAddonDeployable.class.cast(deployable)), (File)folder, (String)lastModifiedOriginalFileName, (boolean)false, (IDeployableHelper)this.deployableHelper);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot install archive for '" + deployable.getArchive() + "'", (Throwable)e);
            }
        }
        IArchive addonArchive = unpackedDeployable.getArchive();
        try {
            unpackedFile = URLUtils.urlToFile((URL)addonArchive.getURL());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get URL from archive '" + addonArchive + "'", (Throwable)e);
        }
        File addonMetadataFile = isAlreadyInstalled ? new File(AddonUtil.getAddonDirectoryPath(logEntry.getName()), "jonas-addon.xml") : AddonUtil.getAddonMetadataFile(addonArchive);
        this.validate(addonMetadataFile);
        try {
            addonMetadata = AddonUtil.getAddonMetadata(addonMetadataFile, unpackedFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Addon metadata are incorrect", (Throwable)e);
        }
        unpackedDeployable.setMetadata(addonMetadata);
        this.checkAddonMetadata(unpackedDeployable);
        this.updateDeployables(unpackedFile.getAbsolutePath(), unpackedDeployable, false);
        if (!isAlreadyInstalled) {
            try {
                this.confDeployer.install(unpackedDeployable);
            }
            catch (DeployerException e) {
                throw new DeployerException("Could not install configuration files of the deployable " + unpackedDeployable.getShortName(), (Throwable)e);
            }
        }
        try {
            originalURL = deployable.getArchive().getURL();
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get the url of the deployable '" + deployable.getShortName(), (Throwable)e);
        }
        String repositoryDir = AddonUtil.getAddonRepositoryWorkDirectory(AddonUtil.getAddonWorkDirectory(unpackedDeployable));
        File repositoryFile = new File(repositoryDir);
        if (repositoryFile.exists() && repositoryFile.isDirectory()) {
            Repository repository = new Repository();
            repository.setId(unpackedDeployable.toString());
            repository.setType(RepositoryKind.MAVEN_2);
            repository.setUrl("file:" + repositoryFile.getPath());
            try {
                this.repositoryManager.addRepository(repository);
                this.repositories.put(unpackedDeployable, repository);
                logger.debug((Object)("The repository '" + repository + "' was added"), new Object[0]);
            }
            catch (RepositoryIdCollisionException e) {
                throw new DeployerException("Repository '" + repository + "' already added");
            }
            catch (InvalidRepositoryException e) {
                throw new DeployerException("'" + repository + "' is an invalid repository");
            }
        }
        if ((parent = this.getParent(originalURL)) != null) {
            ((AddonDeployableImpl)((Object)AddonDeployableImpl.class.cast(unpackedDeployable))).setParent(parent);
        }
        unpackedDeployable.updateState(2);
        ++this.addonId;
        ((AddonDeployableImpl)((Object)AddonDeployableImpl.class.cast(unpackedDeployable))).setAddonId(this.addonId);
        if (this.deployerLog != null && this.deployerLog.getEntry(URLUtils.urlToFile((URL)originalURL)) == null) {
            try {
                this.deployerLog.addEntry(addonMetadata.getName(), unpackedDeployable.getState(), installFromACommand, originalFile, unpackedFile);
            }
            catch (DeployerLogException e) {
                logger.info((Object)"Cannot added a log entry to the addon logger", new Object[0]);
            }
        }
        try {
            this.workCleanerLog.addEntry((LogEntry)new LogEntryImpl(originalFile, unpackedFile));
        }
        catch (DeployerLogException e) {
            logger.info((Object)"Cannot added a log entry to the addon work cleaner logger", new Object[0]);
        }
        this.addons.put(originalURL, unpackedDeployable);
        if (!isAlreadyInstalled) {
            logger.info((Object)"Deployable ''{0}'' has been installed.", new Object[]{unpackedDeployable});
        }
        return unpackedDeployable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(String addonName) throws DeployerException {
        IAddonDeployable addon;
        block35: {
            block34: {
                if (addonName == null) {
                    throw new DeployerException("The name of the addon to start could not be null");
                }
                addon = this.getAddon(addonName);
                if (addon == null) {
                    throw new DeployerException("The addon " + addonName + " could not be retrieved");
                }
                int state = addon.getState();
                if (2 != state) {
                    if (4 != state) throw new DeployerException("Could not start an addon that does not have an INSTALLED or RESOLVED state");
                }
                addon.updateState(8);
                boolean ok = false;
                try {
                    this.checkRequirements(addon, false);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        addon.updateState(2);
                        try {
                            this.deployerLog.updateEntry(addonName, addon.getState());
                        }
                        catch (DeployerLogException e) {
                            logger.error((Object)("Could not update the log entry of the addon " + addonName), new Object[0]);
                        }
                    }
                }
                ok = false;
                try {
                    this.confDeployer.start(addon.getMetadata().getName());
                    this.deployEmbeddedDeployables(addon);
                    ok = true;
                    logger.info((Object)"''{0}'' addon has been started", new Object[]{addon.getShortName()});
                    if (!ok) break block34;
                }
                catch (Throwable throwable) {
                    if (ok) {
                        addon.updateState(32);
                        List<IAddonDeployable> addons = this.getAddons(2);
                        for (IAddonDeployable deployable : addons) {
                            if (deployable.equals(addon)) continue;
                            try {
                                this.checkRequirements(deployable);
                                deployable.updateState(4);
                                try {
                                    this.deployerLog.updateEntry(deployable.getMetadata().getName(), deployable.getState());
                                }
                                catch (DeployerLogException e) {
                                    logger.error((Object)("Could not update the log entry of the addon " + deployable.getMetadata().getName()), new Object[]{e});
                                }
                            }
                            catch (Exception e) {}
                        }
                    } else {
                        try {
                            this.checkRequirements(addon);
                            addon.updateState(4);
                        }
                        catch (Exception e) {
                            addon.updateState(2);
                        }
                    }
                    try {
                        this.deployerLog.updateEntry(addonName, addon.getState());
                        throw throwable;
                    }
                    catch (DeployerLogException e) {
                        logger.error((Object)("Could not update the log entry of the addon " + addonName), new Object[]{e});
                    }
                    throw throwable;
                }
                addon.updateState(32);
                List<IAddonDeployable> addons = this.getAddons(2);
                for (IAddonDeployable deployable : addons) {
                    if (deployable.equals(addon)) continue;
                    try {
                        this.checkRequirements(deployable);
                        deployable.updateState(4);
                        try {
                            this.deployerLog.updateEntry(deployable.getMetadata().getName(), deployable.getState());
                        }
                        catch (DeployerLogException e) {
                            logger.error((Object)("Could not update the log entry of the addon " + deployable.getMetadata().getName()), new Object[]{e});
                        }
                    }
                    catch (Exception e) {}
                }
                break block35;
            }
            try {
                this.checkRequirements(addon);
                addon.updateState(4);
            }
            catch (Exception e) {
                addon.updateState(2);
            }
        }
        try {
            this.deployerLog.updateEntry(addonName, addon.getState());
            return;
        }
        catch (DeployerLogException e) {
            logger.error((Object)("Could not update the log entry of the addon " + addonName), new Object[]{e});
            return;
        }
    }

    public void doDeploy(IDeployable<IAddonDeployable> deployable) throws DeployerException {
        IAddonDeployable addon = (IAddonDeployable)IAddonDeployable.class.cast(this.install(deployable, false));
        IAddonMetadata metadata = addon.getMetadata();
        if (metadata.getAutostart().booleanValue()) {
            this.start(metadata.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void stop(String addonName) throws DeployerException {
        if (addonName == null) {
            throw new DeployerException("The name of the addon to stop could not be null");
        }
        IAddonDeployable addon = this.getAddon(addonName);
        if (addon == null) {
            throw new DeployerException("The addon " + addonName + " could not be retrieved");
        }
        IAddonDeployable parent = addon.getParent();
        if (parent != null && parent.getState() == 32) {
            throw new DeployerException("The addon " + addonName + " is an embedded addon." + " To stop it, you should stop its parent (ID " + parent.getAddonId() + ")");
        }
        int state = addon.getState();
        if (32 == state) {
            try {
                addon.updateState(16);
                List<IAddonDeployable> addons = this.getAddons(32);
                for (IAddonDeployable deployable : addons) {
                    if (deployable.equals(addon)) continue;
                    try {
                        this.checkRequirements(deployable, addon, true);
                    }
                    catch (Exception error) {
                        logger.warn((Object)("Stopping addon " + deployable.getMetadata().getName() + " ..."), new Object[]{error});
                        this.stop(deployable.getMetadata().getName());
                        logger.warn((Object)("Addon " + deployable + " has been stopped."), new Object[0]);
                        deployable.updateState(2);
                        try {
                            this.deployerLog.updateEntry(deployable.getMetadata().getName(), deployable.getState());
                        }
                        catch (DeployerLogException ex) {
                            logger.error((Object)("Could not update the log entry of the addon " + deployable.getMetadata().getName()), new Object[]{ex});
                        }
                        continue;
                        catch (Exception ex) {
                            try {
                                logger.error((Object)("Could not stop addon " + deployable.getMetadata().getName()), new Object[]{ex});
                            }
                            catch (Throwable throwable) {
                                deployable.updateState(2);
                                try {
                                    this.deployerLog.updateEntry(deployable.getMetadata().getName(), deployable.getState());
                                }
                                catch (DeployerLogException ex2) {
                                    logger.error((Object)("Could not update the log entry of the addon " + deployable.getMetadata().getName()), new Object[]{ex2});
                                }
                                throw throwable;
                            }
                            deployable.updateState(2);
                            try {
                                this.deployerLog.updateEntry(deployable.getMetadata().getName(), deployable.getState());
                            }
                            catch (DeployerLogException ex3) {
                                logger.error((Object)("Could not update the log entry of the addon " + deployable.getMetadata().getName()), new Object[]{ex3});
                            }
                        }
                    }
                }
                try {
                    this.confDeployer.stop(addonName);
                }
                catch (DeployerException e) {
                    logger.error((Object)("Could not remove access to the configuration of the addon " + addonName), new Object[]{e});
                }
                this.undeployEmbeddedDeployables(addon);
            }
            catch (Throwable throwable) {
                addon.updateState(4);
                try {
                    this.deployerLog.updateEntry(addonName, addon.getState());
                }
                catch (DeployerLogException e) {
                    logger.error((Object)("Could not update the log entry of the addon " + addonName), new Object[]{e});
                }
                throw throwable;
            }
            addon.updateState(4);
            try {
                this.deployerLog.updateEntry(addonName, addon.getState());
            }
            catch (DeployerLogException e) {
                logger.error((Object)("Could not update the log entry of the addon " + addonName), new Object[]{e});
            }
        }
    }

    public void uninstall(String addonName) throws DeployerException {
        this.uninstall(addonName, false);
    }

    public void uninstall(String addonName, boolean force) throws DeployerException {
        URL originalAddonURL;
        if (addonName == null) {
            throw new DeployerException("The name of the addon to uninstall could not be null");
        }
        IAddonDeployable addon = this.getAddon(addonName);
        if (addon == null) {
            throw new DeployerException("The addon " + addonName + " could not be retrieved");
        }
        if (!force) {
            int state = addon.getState();
            if (32 == state) {
                throw new DeployerException("Could not uninstall an addon which have an ACTIVE state. Please stop the addon before and try again.");
            }
            if (8 == state) {
                throw new DeployerException("Could not uninstall an addon which have an STARTING state. Please stop the addon before and try again.");
            }
            if (16 == state) {
                throw new DeployerException("Could not uninstall an addon which have an STOPPING state. Please stop the addon before and try again.");
            }
        }
        try {
            this.confDeployer.uninstall(addonName);
        }
        catch (DeployerException e) {
            logger.error((Object)("Configuration files of the addon " + addonName + " could not be uninstalled."), new Object[]{e});
        }
        try {
            originalAddonURL = ((IAddonDeployable)addon.getOriginalDeployable()).getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the Addon deployable '" + addon + "'.", (Throwable)e);
        }
        File originalFile = URLUtils.urlToFile((URL)originalAddonURL);
        IAddonLogEntry logEntry = (IAddonLogEntry)this.deployerLog.getEntry(originalFile);
        if (logEntry != null) {
            try {
                this.deployerLog.removeEntry((LogEntry)logEntry);
            }
            catch (DeployerLogException e) {
                logger.error((Object)"Cannot remove the adddon log entry", new Object[]{e});
            }
        } else {
            logger.error((Object)"Cannot retrieve the addon log entry to remove", new Object[0]);
        }
        Repository repository = this.repositories.get(addon);
        if (repository != null) {
            this.repositoryManager.removeRepository(repository);
            logger.debug((Object)("The repository '" + repository + "' was removed"), new Object[0]);
        }
        this.addons.remove(originalAddonURL);
        addon.updateState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doUndeploy(IDeployable<IAddonDeployable> deployable) throws DeployerException {
        URL addonURL;
        logger.info((Object)"Undeploying {0}", new Object[]{deployable.getShortName()});
        try {
            addonURL = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the Addon deployable '" + deployable + "'.", (Throwable)e);
        }
        String addonName = null;
        try {
            IAddonDeployable unpackedDeployable = null;
            if (!this.addons.containsKey(addonURL)) throw new DeployerException("Cannot get the unpacked deployable " + deployable.getShortName() + " with URL '" + addonURL.getPath() + "'.");
            unpackedDeployable = this.addons.get(addonURL);
            if (unpackedDeployable == null) {
                throw new DeployerException("Cannot get the unpacked deployable " + deployable.getShortName() + " with URL '" + addonURL.getPath() + "'.");
            }
            IAddonMetadata metadata = unpackedDeployable.getMetadata();
            if (metadata == null) {
                File unpackedDeployableFile = null;
                try {
                    unpackedDeployableFile = URLUtils.urlToFile((URL)unpackedDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL on the unpacked deployable '" + unpackedDeployable + "'.", (Throwable)e);
                }
                try {
                    unpackedDeployable.setMetadata(AddonUtil.getAddonMetadata(AddonUtil.getAddonMetadataFile(unpackedDeployable.getArchive()), unpackedDeployableFile.getAbsolutePath()));
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot get metadata of the addon " + unpackedDeployable.getShortName()), new Object[]{e});
                }
                metadata = unpackedDeployable.getMetadata();
                if (metadata == null) {
                    throw new DeployerException("Could not retrieve metadata of the addon " + deployable.getShortName());
                }
            }
            addonName = metadata.getName();
            this.stop(addonName);
            if (addonName == null) throw new DeployerException("Could not uninstall addon " + deployable.getShortName() + ". The name of the addon could not be retrieved");
        }
        catch (Throwable throwable) {
            if (addonName == null) throw new DeployerException("Could not uninstall addon " + deployable.getShortName() + ". The name of the addon could not be retrieved");
            this.uninstall(addonName, true);
            throw throwable;
        }
        this.uninstall(addonName, true);
        logger.info((Object)"''{0}'' addon is now undeployed", new Object[]{deployable.getShortName()});
    }

    public boolean supports(IDeployable<?> deployable) {
        return AddonDeployableImpl.class.isInstance(deployable);
    }

    public List<IAddonDeployable> getAddons() {
        return new ArrayList<IAddonDeployable>(this.addons.values());
    }

    public IAddonDeployable getAddon(long addonId) {
        List<IAddonDeployable> addons = this.getAddons();
        for (IAddonDeployable addon : addons) {
            if (addon.getAddonId() != addonId) continue;
            return addon;
        }
        return null;
    }

    private List<String> getDeployed() {
        ArrayList<String> deployed = new ArrayList<String>();
        Collection<IAddonDeployable> addons = this.addons.values();
        if (addons != null) {
            for (IAddonDeployable addon : addons) {
                String name;
                IAddonMetadata addonMetadata = addon.getMetadata();
                if (addonMetadata == null || (name = addonMetadata.getName()) == null) continue;
                deployed.add(name);
            }
        }
        return deployed;
    }

    private List<IAddonDeployable> getAddons(int state) {
        ArrayList<IAddonDeployable> list = new ArrayList<IAddonDeployable>();
        Collection<IAddonDeployable> addons = this.addons.values();
        if (addons != null) {
            for (IAddonDeployable addon : addons) {
                if (addon.getState() != state) continue;
                list.add(addon);
            }
        }
        return list;
    }

    private void checkAddonMetadata(IAddonDeployable deployable) throws DeployerException {
        IAddonMetadata addonMetadata = deployable.getMetadata();
        if (addonMetadata.getName() == null || addonMetadata.getName().isEmpty()) {
            throw new DeployerException("Addon name not found");
        }
        if (this.getDeployed().contains(addonMetadata.getName())) {
            throw new DeployerException("Cannot install addon " + addonMetadata.getName() + ". An Addon with the same " + "name is already deployed.");
        }
        String JOnASVersion = Version.getNumber();
        if (!addonMetadata.isJOnASVersionSupported(JOnASVersion)) {
            throw new DeployerException("Cannot install addon " + addonMetadata.getName() + ". JOnAS version " + JOnASVersion + " doesn't match ");
        }
        String jvmVersion = System.getProperty("java.version");
        if (!addonMetadata.isJvmVersionSupported(jvmVersion)) {
            throw new DeployerException("Cannot install addon " + addonMetadata.getName() + ". JVM version " + jvmVersion + " doesn't match ");
        }
    }

    public void resolve() {
        List<IAddonDeployable> addons = this.getAddons(2);
        for (IAddonDeployable addon : addons) {
            try {
                this.checkRequirements(addon);
                addon.updateState(4);
                try {
                    this.deployerLog.updateEntry(addon.getMetadata().getName(), addon.getState());
                }
                catch (DeployerLogException e) {
                    logger.error((Object)("Could not update the log entry of the addon " + addon.getMetadata().getName()), new Object[]{e});
                }
            }
            catch (DeployerException e) {
                logger.error((Object)("The addon " + addon.getMetadata().getName() + " could not be resolved."), new Object[]{e});
            }
        }
    }

    public void checkRequirements(IAddonDeployable deployable) throws DeployerException {
        this.checkRequirements(deployable, (IAddonDeployable)null, true);
    }

    public void checkRequirements(IAddonDeployable deployable, boolean excludeEmbeddedAddonsScan) throws DeployerException {
        this.checkRequirements(deployable, (IAddonDeployable)null, excludeEmbeddedAddonsScan);
    }

    private void checkRequirements(IAddonDeployable deployable, IAddonDeployable excluded, boolean excludeEmbeddedAddonsScan) throws DeployerException {
        ArrayList<IAddonDeployable> list = new ArrayList<IAddonDeployable>();
        list.add(excluded);
        this.checkRequirements(deployable, list, excludeEmbeddedAddonsScan);
    }

    private void checkRequirements(IAddonDeployable deployable, List<IAddonDeployable> excluded, boolean excludeEmbeddedAddonsScan) throws DeployerException {
        IAddonMetadata addonMetadata = deployable.getMetadata();
        if (addonMetadata != null) {
            List requirements = addonMetadata.getRequirements();
            List provides = addonMetadata.getProvides();
            if (requirements != null) {
                for (String requirement : requirements) {
                    this.checkRequirement(requirement, provides, deployable.getArchive(), excluded, excludeEmbeddedAddonsScan);
                }
            }
        } else {
            throw new DeployerException("Could not retrieve metadata of deployable " + deployable.getShortName());
        }
    }

    private void checkRequirement(String requirement, List<String> provides, IArchive addonArchive, List<IAddonDeployable> excluded, boolean excludeEmbeddedAddonsScan) throws DeployerException {
        boolean found = AddonUtil.checkRequirement(requirement, provides);
        if (!found) {
            List<String> capabilities;
            if (!excludeEmbeddedAddonsScan) {
                found = AddonUtil.checkRequirement(requirement, this.getCapabilitiesProvideByEmbeddedAddons(addonArchive, excluded));
            }
            if (!found && !(found = AddonUtil.checkRequirement(requirement, capabilities = this.getCapabilities(excluded)))) {
                throw new DeployerException("Missing requirement " + requirement);
            }
        }
    }

    private List<String> getCapabilities(List<IAddonDeployable> excluded) {
        ArrayList<String> capabilities = new ArrayList<String>();
        Collection<IAddonDeployable> addons = this.addons.values();
        if (addons != null) {
            for (IAddonDeployable addon : addons) {
                int state;
                if (excluded != null && excluded.contains(addon) || (state = addon.getState()) != 32) continue;
                capabilities.addAll(addon.getCapabilities());
            }
        }
        return capabilities;
    }

    private final List<String> getCapabilitiesProvideByEmbeddedAddons(IArchive addonArchive, List<IAddonDeployable> excluded) throws DeployerException {
        ArrayList<String> provides = new ArrayList<String>();
        List<IArchive> embeddedAddons = this.getEmbeddedAddons(addonArchive);
        if (embeddedAddons != null) {
            for (IArchive embeddedAddon : embeddedAddons) {
                if (excluded == null || excluded.contains(embeddedAddon)) continue;
                provides.addAll((Collection<String>)AddonUtil.getProvidesRequirements(AddonUtil.getAddonMetadataInpustream(embeddedAddon)).getKey());
                provides.addAll(this.getCapabilitiesProvideByEmbeddedAddons(embeddedAddon, excluded));
            }
        }
        return provides;
    }

    public final List<IArchive> getEmbeddedAddons(IArchive addonArchive) throws DeployerException {
        File[] files;
        URL url;
        try {
            url = addonArchive.getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the url of the archive " + addonArchive.getName(), (Throwable)e);
        }
        File addonFile = URLUtils.urlToFile((URL)url);
        File deployDir = new File(addonFile, "deploy");
        ArrayList<IArchive> embedddedAddons = new ArrayList<IArchive>();
        if (deployDir.exists() && (files = deployDir.listFiles()) != null) {
            for (File file : files) {
                IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
                IDeployable deployable = null;
                try {
                    deployable = this.deployableHelper.getDeployable(archive);
                }
                catch (DeployableHelperException e) {
                    logger.error((Object)("Cannot get the deployable of the archive " + archive.getName()), new Object[]{e});
                }
                if (!this.supports(deployable)) continue;
                embedddedAddons.add(archive);
            }
        }
        return embedddedAddons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployEmbeddedDeployables(IAddonDeployable unpackedDeployable) throws DeployerException {
        String service;
        ArrayList<ISortableDeployable> knownDeployables = new ArrayList<ISortableDeployable>();
        knownDeployables.addAll(unpackedDeployable.getKnownDeployables());
        ArrayList<IDeployable> deployablesWithUnsupportDeployer = new ArrayList<IDeployable>();
        IAddonMetadata addonMetadata = unpackedDeployable.getMetadata();
        if (!knownDeployables.isEmpty()) {
            Object oldTenantContext = null;
            if (this.isMultitenantEnabled()) {
                oldTenantContext = this.multitenantService.getTenantContext();
            }
            try {
                if (this.isMultitenantEnabled()) {
                    this.multitenantService.setTenantIdAndInstanceNameInContext(addonMetadata.getTenantId(), addonMetadata.getInstance());
                }
                List<IDeploymentReport> deploymentReports = this.deploySortableDeployables(knownDeployables);
                int count = 0;
                for (IDeploymentReport deploymentReport : deploymentReports) {
                    if (deploymentReport.isDeploymentOk()) continue;
                    if (UnsupportedDeployerException.class.isInstance(deploymentReport.getException())) {
                        deployablesWithUnsupportDeployer.add(deploymentReport.getDeployable());
                        continue;
                    }
                    logger.error((Object)("The deployable " + deploymentReport.getDeployable().getShortName() + " could not be deployed."), new Object[]{deploymentReport.getException()});
                    ++count;
                }
                if (count > 0) {
                    throw new DeployerException("The addon " + addonMetadata.getName() + " cannot be deployed");
                }
            }
            finally {
                if (this.isMultitenantEnabled()) {
                    this.multitenantService.setTenantContext(oldTenantContext);
                }
            }
        }
        if ((service = addonMetadata.getService()) != null) {
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("service", service);
            this.serviceRegistrations.add(this.bundleContext.registerService(ServiceProperties.class.getName(), (Object)addonMetadata.getServiceProperties(), dictionary));
            try {
                this.serviceManager.startService(service, false);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot create the configuration for the service " + service, (Throwable)e);
            }
        }
        List unknownDeployables = unpackedDeployable.getUnknownDeployables();
        ArrayList<ISortableDeployable> deployablesToDeploy = new ArrayList<ISortableDeployable>();
        for (ISortableDeployable unknownSortableDeployable : unknownDeployables) {
            IDeployable deployable;
            IDeployable unknownDeployable = unknownSortableDeployable.getDeployable();
            boolean ok = false;
            long maxWaitTime = System.currentTimeMillis() + 1000L;
            while (!ok && System.currentTimeMillis() < maxWaitTime) {
                try {
                    deployable = this.deployableHelper.getDeployable(unknownDeployable.getArchive());
                    if (!UnknownDeployable.class.isInstance(deployable)) {
                        ok = true;
                        continue;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                    }
                }
                catch (DeployableHelperException e) {
                    logger.error((Object)"Cannot get a deployable for the archive ''{0}''", new Object[]{unknownDeployable.getArchive(), e});
                }
            }
            try {
                deployable = this.deployableHelper.getDeployable(unknownDeployable.getArchive());
                if (UnknownDeployable.class.isInstance(deployable)) {
                    logger.error((Object)("Unknown deployable " + deployable.getShortName() + ". It will not be deployed."), new Object[0]);
                    continue;
                }
                unpackedDeployable.removeDeployable(unknownSortableDeployable);
                unpackedDeployable.addDeployable(AddonUtil.getSortableDeployable(deployable));
                deployablesToDeploy.add(AddonUtil.getSortableDeployable(deployable));
            }
            catch (DeployableHelperException e) {
                logger.error((Object)"Cannot get a deployable for the archive ''{0}''", new Object[]{unknownDeployable.getArchive(), e});
            }
        }
        if (!deployablesToDeploy.isEmpty()) {
            Object oldTenantContext = null;
            if (this.isMultitenantEnabled()) {
                oldTenantContext = this.multitenantService.getTenantContext();
            }
            try {
                if (this.isMultitenantEnabled()) {
                    this.multitenantService.setTenantIdAndInstanceNameInContext(addonMetadata.getTenantId(), addonMetadata.getInstance());
                }
                List<IDeploymentReport> deploymentReports = this.deploySortableDeployables(deployablesToDeploy);
                int count = 0;
                for (IDeploymentReport deploymentReport : deploymentReports) {
                    if (deploymentReport.isDeploymentOk()) continue;
                    if (UnsupportedDeployerException.class.isInstance(deploymentReport.getException())) {
                        deployablesWithUnsupportDeployer.add(deploymentReport.getDeployable());
                        continue;
                    }
                    logger.error((Object)("The deployable " + deploymentReport.getDeployable().getShortName() + " could not be deployed."), new Object[]{deploymentReport.getException()});
                    ++count;
                }
                if (count > 0) {
                    throw new DeployerException("The addon " + addonMetadata.getName() + " cannot be deployed");
                }
            }
            finally {
                if (this.isMultitenantEnabled()) {
                    this.multitenantService.setTenantContext(oldTenantContext);
                }
            }
        }
        deployablesToDeploy = new ArrayList();
        for (IDeployable deployable : deployablesWithUnsupportDeployer) {
            deployablesToDeploy.add(AddonUtil.getSortableDeployable(deployable));
        }
        boolean ok = false;
        long maxWaitTime = System.currentTimeMillis() + 1000L;
        while (!ok && System.currentTimeMillis() < maxWaitTime) {
            int count = 0;
            List<IDeploymentReport> deploymentReports = this.deploySortableDeployables(deployablesToDeploy);
            for (IDeploymentReport deploymentReport : deploymentReports) {
                if (!deploymentReport.isDeploymentOk()) {
                    if (UnsupportedDeployerException.class.isInstance(deploymentReport.getException())) continue;
                    logger.error((Object)("The deployable " + deploymentReport.getDeployable().getShortName() + " could not be deployed."), new Object[]{deploymentReport.getException()});
                    ISortableDeployable sortableDeployable = AddonUtil.getSortableDeployable(deploymentReport.getDeployable());
                    if (sortableDeployable != null) {
                        deployablesToDeploy.remove(sortableDeployable);
                    }
                    ++count;
                    continue;
                }
                ISortableDeployable deployed = AddonUtil.getSortableDeployable(deployablesToDeploy, deploymentReport.getDeployable());
                if (deployed != null) {
                    deployablesToDeploy.remove(deployed);
                }
                ok = true;
            }
            if (count > 0) {
                throw new DeployerException("The addon " + addonMetadata.getName() + " cannot be deployed");
            }
            if (ok) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
        if (deployablesToDeploy.size() > 0) {
            for (ISortableDeployable sortableDeployable : deployablesToDeploy) {
                IDeployable deployable = sortableDeployable.getDeployable();
                logger.error((Object)("The deployable " + deployable.getShortName() + " could not be deployed."), new Object[]{new UnsupportedDeployerException("No deployer was found for the deployable " + deployable.getShortName())});
            }
            throw new DeployerException("The addon " + addonMetadata.getName() + " cannot be deployed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployEmbeddedDeployables(IAddonDeployable unpackedDeployable) throws DeployerException {
        String service;
        List unknownDeployables = unpackedDeployable.getUnknownDeployables();
        for (ISortableDeployable unknownDeployable : unknownDeployables) {
            logger.error((Object)("Unknown deployable " + unknownDeployable.getDeployable().getShortName() + " .It will not be undeployed"), new Object[0]);
        }
        ArrayList<ISortableDeployable> knownDeployables = new ArrayList<ISortableDeployable>();
        knownDeployables.addAll(unpackedDeployable.getKnownDeployables());
        IAddonMetadata addonMetadata = unpackedDeployable.getMetadata();
        int count = 0;
        if (!knownDeployables.isEmpty()) {
            List<IDeploymentReport> deploymentReports;
            Object oldTenantContext = null;
            if (this.isMultitenantEnabled()) {
                oldTenantContext = this.multitenantService.getTenantContext();
            }
            try {
                if (this.isMultitenantEnabled()) {
                    this.multitenantService.setTenantIdAndInstanceNameInContext(addonMetadata.getTenantId(), addonMetadata.getInstance());
                }
                deploymentReports = this.undeploySortableDeployables(knownDeployables);
            }
            finally {
                if (this.isMultitenantEnabled()) {
                    this.multitenantService.setTenantContext(oldTenantContext);
                }
            }
            for (IDeploymentReport deploymentReport : deploymentReports) {
                if (deploymentReport.isDeploymentOk()) continue;
                logger.error((Object)("The deployable " + deploymentReport.getDeployable().getShortName() + " could not be undeployed."), new Object[]{deploymentReport.getException()});
                ++count;
            }
        }
        if ((service = addonMetadata.getService()) != null) {
            try {
                this.serviceManager.stopService(service);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot delete the configuration for the service " + service, (Throwable)e);
            }
            ServiceRegistration serviceRegistration = AddonUtil.getServiceRegistration(this.serviceRegistrations, "service", addonMetadata.getService());
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
                this.serviceRegistrations.remove(serviceRegistration);
            }
        }
        if (count > 0) {
            throw new DeployerException("The addon " + addonMetadata.getName() + " cannot be undeployed");
        }
    }

    public void updateDeployables(String unpackedDeployablePath, IAddonDeployable unpackedDeployable, boolean copyJOnASPlans) {
        File addonDeployWorkDirectory = new File(AddonUtil.getAddonDeployWorkDirectory(unpackedDeployablePath));
        if (addonDeployWorkDirectory.isDirectory()) {
            for (File file : addonDeployWorkDirectory.listFiles()) {
                File jonasDeploymentPlanImpl;
                String implementation;
                IAddonMetadata addonMetadata;
                String service;
                IDeployable deployable = AddonUtil.getDeployable(this.deployableHelper, file);
                unpackedDeployable.addDeployable(AddonUtil.getSortableDeployable(deployable));
                if (!copyJOnASPlans || !(deployable instanceof DeploymentPlanDeployable) || (service = (addonMetadata = unpackedDeployable.getMetadata()).getService()) == null) continue;
                File urlInternalDirectory = new File(AddonUtil.JONAS_ROOT_URL_INTERNAL_DIRECTORY);
                if (!urlInternalDirectory.exists()) {
                    urlInternalDirectory.getParentFile().mkdirs();
                }
                if ((implementation = addonMetadata.getImplementation()) == null) {
                    String defaultDeploymentPlanName = AddonUtil.getDefaultDeploymentPlan(service);
                    File defaultDeploymentPlan = new File(addonDeployWorkDirectory.getAbsolutePath(), defaultDeploymentPlanName);
                    if (!defaultDeploymentPlan.exists()) continue;
                    AddonUtil.copyFile(defaultDeploymentPlan, new File(urlInternalDirectory.getAbsolutePath(), defaultDeploymentPlanName));
                    continue;
                }
                String jonasAbstractDeploymentPlanName = AddonUtil.getAbstractDeploymentPlan(service);
                String jonasDeploymentPlanImplName = AddonUtil.getImplDeploymentPlan(service, implementation);
                File jonasAbstractDeploymentPlan = new File(addonDeployWorkDirectory.getAbsolutePath(), jonasAbstractDeploymentPlanName);
                if (jonasAbstractDeploymentPlan.exists()) {
                    AddonUtil.copyFile(jonasAbstractDeploymentPlan, new File(urlInternalDirectory.getAbsolutePath(), jonasAbstractDeploymentPlanName));
                }
                if (!(jonasDeploymentPlanImpl = new File(addonDeployWorkDirectory.getAbsolutePath(), jonasDeploymentPlanImplName)).exists()) continue;
                AddonUtil.copyFile(jonasDeploymentPlanImpl, new File(urlInternalDirectory.getAbsolutePath(), jonasDeploymentPlanImplName));
            }
        }
    }

    private List<IDeploymentReport> deploySortableDeployables(List<ISortableDeployable> sortableDeployables) {
        ArrayList<IDeploymentReport> deploymentReports = new ArrayList<IDeploymentReport>();
        AddonUtil.sortSortableDeployable(sortableDeployables);
        ArrayList<IDeployable> deployables = new ArrayList<IDeployable>();
        for (ISortableDeployable sortableDeployable : sortableDeployables) {
            IDeployable deployable = sortableDeployable.getDeployable();
            try {
                if (this.deployerManager.isDeployed(deployable)) continue;
                deployables.add(sortableDeployable.getDeployable());
            }
            catch (DeployerException e) {
                logger.error((Object)("Could not find if the deployable " + deployable.getShortName() + " is already deployed"), new Object[]{e});
            }
            catch (UnsupportedDeployerException e) {
                DeploymentReport deploymentReport = new DeploymentReport();
                deploymentReport.setDeploymentOk(false);
                deploymentReport.setException((Exception)((Object)e));
                deploymentReport.setDeployable(sortableDeployable.getDeployable());
                deploymentReports.add((IDeploymentReport)deploymentReport);
            }
        }
        List reports = this.deployerManager.deploy(deployables);
        if (reports != null) {
            deploymentReports.addAll(reports);
        }
        return deploymentReports;
    }

    private List<IDeploymentReport> undeploySortableDeployables(List<ISortableDeployable> sortableDeployables) {
        AddonUtil.sortSortableDeployable(sortableDeployables);
        Collections.reverse(sortableDeployables);
        ArrayList<IDeployable> deployables = new ArrayList<IDeployable>();
        for (ISortableDeployable sortableDeployable : sortableDeployables) {
            deployables.add(sortableDeployable.getDeployable());
        }
        return this.deployerManager.undeploy(deployables);
    }

    public boolean isAddonDeployedByWorkName(String unpackName) {
        if (!this.isInitialized()) {
            return true;
        }
        for (IAddonDeployable addonDeployable : this.addons.values()) {
            try {
                File unpackedFile = URLUtils.urlToFile((URL)addonDeployable.getArchive().getURL());
                if (!unpackName.equals(unpackedFile.getName())) continue;
                return true;
            }
            catch (ArchiveException e) {
                logger.debug((Object)"Cannot retrieve the name of the unpacked addon {0}", new Object[]{unpackName});
            }
        }
        return false;
    }

    private boolean isInitialized() {
        if (!this.isInitialized) {
            int deployerLogSize = this.deployerLog.getEntries().size();
            this.isInitialized = deployerLogSize == 0 || deployerLogSize == this.addons.size();
        }
        return this.isInitialized;
    }

    private void validate(File addonMetadataFile) throws DeployerException {
        InputStream xsdInputStream = ((Object)((Object)this)).getClass().getResourceAsStream(XSD_RESOURCE);
        if (xsdInputStream != null) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            try {
                schema = factory.newSchema(new StreamSource(xsdInputStream));
            }
            catch (SAXException e) {
                throw new DeployerException("Cannot create a new Schema from the resource /META-INF/jonas-addon-1.0.xsd", (Throwable)e);
            }
            Validator validator = schema.newValidator();
            DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
            xmlFactory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            try {
                builder = xmlFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new DeployerException("Cannot create a new DocumentBuilder", (Throwable)e);
            }
            Document document = null;
            try {
                document = builder.parse(addonMetadataFile);
            }
            catch (SAXException e) {
                throw new DeployerException("Cannot parse the file " + addonMetadataFile.getAbsolutePath(), (Throwable)e);
            }
            catch (IOException e) {
                throw new DeployerException("Cannot parse the file " + addonMetadataFile.getAbsolutePath(), (Throwable)e);
            }
            try {
                validator.validate(new DOMSource(document));
            }
            catch (SAXException e) {
                throw new DeployerException("Cannot validate the file " + addonMetadataFile.getAbsolutePath() + " from the XSD " + "resource " + XSD_RESOURCE, (Throwable)e);
            }
            catch (IOException e) {
                throw new DeployerException("Cannot validate the Node " + addonMetadataFile.getAbsolutePath() + " from the XSD " + "resource " + XSD_RESOURCE, (Throwable)e);
            }
        }
        throw new DeployerException("Cannot get the inputstream of the resource /META-INF/jonas-addon-1.0.xsd");
    }

    protected boolean isMultitenantEnabled() {
        return this.multitenantService != null;
    }

    public void setMultitenantService(MultitenantService multitenantService) {
        this.multitenantService = multitenantService;
    }

    public void unsetMultitenantService() {
        this.multitenantService = null;
    }

    public IAddonDeployable getAddon(String addonName) {
        String name = null;
        if (this.addons != null && addonName != null) {
            for (IAddonDeployable addon : this.addons.values()) {
                IAddonMetadata metadata = addon.getMetadata();
                if (metadata == null || !addonName.equals(name = metadata.getName())) continue;
                return addon;
            }
        }
        return null;
    }

    public List<IDeploymentReport> doDeploy(List<IDeployable<IAddonDeployable>> deployables) {
        ArrayList<IDeploymentReport> deploymentReports = new ArrayList<IDeploymentReport>();
        if (deployables != null) {
            ArrayList<IDeployable<IAddonDeployable>> addons = new ArrayList<IDeployable<IAddonDeployable>>();
            for (IDeployable<IAddonDeployable> deployable : deployables) {
                try {
                    addons.add(this.install(deployable, false));
                }
                catch (DeployerException e) {
                    DeploymentReport deploymentReport = new DeploymentReport();
                    deploymentReport.setDeployable(deployable);
                    deploymentReport.setDeploymentOk(false);
                    deploymentReport.setException((Exception)((Object)e));
                    deploymentReports.add((IDeploymentReport)deploymentReport);
                }
            }
            if (!addons.isEmpty()) {
                List<AddonProvidesRequirements> addonProvidesRequirementsList = this.getAddonProvidesRequirementsList(addons);
                AddonUtil.sort(addonProvidesRequirementsList);
                for (AddonProvidesRequirements addonProvidesRequirements : addonProvidesRequirementsList) {
                    IAddonDeployable addon = (IAddonDeployable)IAddonDeployable.class.cast(addonProvidesRequirements.getDeployable());
                    DeploymentReport deploymentReport = new DeploymentReport();
                    deploymentReport.setDeployable(addon.getOriginalDeployable());
                    try {
                        this.start(addon.getMetadata().getName());
                        deploymentReport.setDeploymentOk(true);
                    }
                    catch (DeployerException e) {
                        deploymentReport.setDeploymentOk(false);
                        deploymentReport.setException((Exception)((Object)e));
                    }
                    deploymentReports.add((IDeploymentReport)deploymentReport);
                }
            }
        }
        return deploymentReports;
    }

    public List<IDeploymentReport> doUndeploy(List<IDeployable<IAddonDeployable>> deployables) {
        ArrayList<IDeploymentReport> deploymentReports = new ArrayList<IDeploymentReport>();
        if (deployables != null) {
            DeploymentReport deploymentReport;
            ArrayList<IDeployable<IAddonDeployable>> unpackedDeployables = new ArrayList<IDeployable<IAddonDeployable>>();
            for (IDeployable<IAddonDeployable> deployable : deployables) {
                IDeployable unpackedDeployable = deployable.getUnpackedDeployable();
                if (unpackedDeployable == null) {
                    try {
                        URL addonURL = deployable.getArchive().getURL();
                        if (this.addons.containsKey(addonURL)) {
                            unpackedDeployable = (IDeployable)this.addons.get(addonURL);
                        } else {
                            DeploymentReport deploymentReport2 = new DeploymentReport();
                            deploymentReport2.setDeployable(deployable);
                            deploymentReport2.setDeploymentOk(false);
                            deploymentReport2.setException((Exception)((Object)new DeployerException("Cannot get the unpacked deployable " + deployable.getShortName() + " with URL '" + addonURL.getPath() + "'.Deployable " + deployable.getShortName() + " will not be undeployed.")));
                            deploymentReports.add((IDeploymentReport)deploymentReport2);
                        }
                    }
                    catch (ArchiveException e) {
                        deploymentReport = new DeploymentReport();
                        deploymentReport.setDeployable(deployable);
                        deploymentReport.setDeploymentOk(false);
                        deploymentReport.setException((Exception)((Object)new DeployerException("Cannot get the URL on the Addon deployable '" + deployable + ".Deployable " + deployable.getShortName() + " will not be undeployed.", (Throwable)e)));
                        deploymentReports.add((IDeploymentReport)deploymentReport);
                    }
                }
                if (unpackedDeployable == null) continue;
                if (deployable.getUnpackedDeployable() == null) {
                    deployable.setUnpackedDeployable(unpackedDeployable);
                }
                if (unpackedDeployable.getOriginalDeployable() == null) {
                    unpackedDeployable.setOriginalDeployable(deployable);
                }
                unpackedDeployables.add((IDeployable<IAddonDeployable>)unpackedDeployable);
            }
            List<AddonProvidesRequirements> addonProvidesRequirementsList = this.getAddonProvidesRequirementsList(unpackedDeployables);
            AddonUtil.sort(addonProvidesRequirementsList);
            Collections.reverse(addonProvidesRequirementsList);
            for (AddonProvidesRequirements addon : addonProvidesRequirementsList) {
                IDeployable<IAddonDeployable> unpackedDeployable = addon.getDeployable();
                IDeployable deployable = unpackedDeployable.getOriginalDeployable();
                deploymentReport = new DeploymentReport();
                deploymentReport.setDeployable(deployable);
                try {
                    this.doUndeploy((IDeployable<IAddonDeployable>)deployable);
                    deploymentReport.setDeploymentOk(true);
                }
                catch (DeployerException e) {
                    deploymentReport.setDeploymentOk(false);
                    deploymentReport.setException((Exception)((Object)e));
                }
                deploymentReports.add((IDeploymentReport)deploymentReport);
            }
        }
        return deploymentReports;
    }

    private List<AddonProvidesRequirements> getAddonProvidesRequirementsList(List<IDeployable<IAddonDeployable>> deployables) {
        ArrayList<AddonProvidesRequirements> addonProvidesRequirementsList = new ArrayList<AddonProvidesRequirements>();
        if (deployables != null) {
            for (IDeployable<IAddonDeployable> deployable : deployables) {
                List<String> provides = null;
                List<String> requirements = null;
                Map.Entry<List<String>, List<String>> providesRequirements = this.getProvidesRequirements(deployable);
                if (providesRequirements != null) {
                    provides = providesRequirements.getKey();
                    requirements = providesRequirements.getValue();
                }
                addonProvidesRequirementsList.add(new AddonProvidesRequirements(deployable, provides, requirements));
            }
        }
        return addonProvidesRequirementsList;
    }

    private Map.Entry<List<String>, List<String>> getProvidesRequirements(IDeployable<IAddonDeployable> deployable) {
        IArchive archive = deployable.getArchive();
        Map.Entry<List<String>, List<String>> entry = null;
        try {
            entry = AddonUtil.getProvidesRequirements(AddonUtil.getAddonMetadataInpustream(archive));
        }
        catch (DeployerException e) {
            logger.error((Object)("Cannot get the couple of <provides, requirements> of the deployable " + deployable.getShortName()), new Object[]{e});
        }
        ArrayList provides = new ArrayList();
        ArrayList requirements = new ArrayList();
        if (entry != null) {
            if (entry.getKey() != null) {
                provides.addAll(entry.getKey());
            }
            if (entry.getValue() != null) {
                requirements.addAll(entry.getValue());
            }
        }
        List<IArchive> embeddedArchives = null;
        try {
            embeddedArchives = this.getEmbeddedAddons(archive);
        }
        catch (DeployerException e) {
            logger.error((Object)("Cannot get the list of embedded deployable of the deployable " + deployable.getShortName()), new Object[]{e});
        }
        if (embeddedArchives != null) {
            for (IArchive embeddedArchive : embeddedArchives) {
                Map.Entry<List<String>, List<String>> providesRequirements = this.getProvidesRequirements((IDeployable<IAddonDeployable>)new AddonDeployableImpl(embeddedArchive));
                if (providesRequirements == null) continue;
                if (providesRequirements.getKey() != null) {
                    provides.addAll(providesRequirements.getKey());
                }
                if (providesRequirements.getValue() == null) continue;
                requirements.addAll(providesRequirements.getValue());
            }
        }
        return new AbstractMap.SimpleEntry<List<String>, List<String>>(provides, requirements);
    }
}

