/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.addon.deploy.api.config.IAddonConfig;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonMetadata;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonDeployer;
import org.ow2.jonas.addon.deploy.api.deployer.IConfDeployer;
import org.ow2.jonas.addon.deploy.impl.config.AddonConfigImpl;
import org.ow2.jonas.addon.deploy.impl.deployable.AddonDeployableImpl;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ConfDeployerImpl
implements IConfDeployer {
    private static Log logger = LogFactory.getLog(ConfDeployerImpl.class);
    public final String SERVICE_REGISTRATION_ADDON_PROPERTY = "addon";
    private BundleContext bundleContext;
    private List<ServiceRegistration> serviceRegistrations;
    private IAddonDeployer addonDeployer;

    public ConfDeployerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceRegistrations = new ArrayList<ServiceRegistration>();
    }

    public void deploy(IAddonDeployable unpackedDeployable) throws DeployerException {
        try {
            this.install(unpackedDeployable);
            try {
                this.start(unpackedDeployable.getMetadata().getName());
            }
            catch (DeployerException e) {
                throw new DeployerException("Could not add access to the configuration files of the addon " + unpackedDeployable.getMetadata().getName() + " through the OSGi registry.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new DeployerException("Could not install configuration files of the deployable " + unpackedDeployable.getShortName(), (Throwable)e);
        }
    }

    public void install(IAddonDeployable unpackedDeployable) throws DeployerException {
        File JOnASAddonDirectory;
        String JOnASAddonDirectoryPath;
        String addonConfigurationPath = null;
        try {
            String addonDirectory = unpackedDeployable.getArchive().getURL().getPath();
            addonConfigurationPath = addonDirectory + "conf";
        }
        catch (ArchiveException e) {
            logger.error((Object)"Cant get URL archive to install", new Object[]{e});
        }
        IAddonMetadata addonMetadata = unpackedDeployable.getMetadata();
        if (addonMetadata != null && addonMetadata.getName() != null && addonMetadata.getMetaDataFile() != null) {
            String addonName = addonMetadata.getName();
            JOnASAddonDirectoryPath = AddonUtil.getAddonDirectoryPath(addonName);
            JOnASAddonDirectory = new File(JOnASAddonDirectoryPath);
            if (!JOnASAddonDirectory.exists()) {
                JOnASAddonDirectory.mkdirs();
            }
            File addonMetaDataFile = addonMetadata.getMetaDataFile();
            try {
                FileUtils.copyFile((String)addonMetaDataFile.getAbsolutePath(), (String)(JOnASAddonDirectory + File.separator + addonMetaDataFile.getName()));
            }
            catch (FileUtilsException e) {
                logger.error((Object)("Cannot copy file " + addonMetaDataFile.getAbsolutePath() + "."), new Object[]{e});
            }
        } else {
            throw new DeployerException("Configuration file couldn't be installed");
        }
        AddonUtil.copyFiles(addonConfigurationPath, JOnASAddonDirectoryPath);
        AddonDeployableImpl addon = (AddonDeployableImpl)((Object)AddonDeployableImpl.class.cast(unpackedDeployable));
        addon.setConfigurationDirectory(JOnASAddonDirectory.getAbsoluteFile());
    }

    public void start(String addonName) throws DeployerException {
        if (addonName == null) {
            throw new DeployerException("The name of the addon to start could not be null");
        }
        String directoryPath = AddonUtil.getAddonDirectoryPath(addonName);
        if (!new File(directoryPath).exists()) {
            throw new DeployerException("Directory " + directoryPath + " doesn't exist ");
        }
        try {
            this.register(directoryPath, addonName);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot register a new IAddonConfig component with " + directoryPath + " directory", (Throwable)e);
        }
    }

    public void stop(String addonName) throws DeployerException {
        if (addonName == null) {
            throw new DeployerException("The name of the addon to start could not be null");
        }
        this.unregister(addonName);
    }

    public void uninstall(String addonName) throws DeployerException {
        IAddonDeployable addon;
        if (addonName == null) {
            throw new DeployerException("The name of the addon to start could not be null");
        }
        String directoryPath = AddonUtil.getAddonDirectoryPath(addonName);
        File file = new File(directoryPath);
        if (file.exists() && !FileUtils.delete((String)directoryPath)) {
            logger.error((Object)("Could not delete directory " + directoryPath), new Object[0]);
        }
        if (this.addonDeployer != null && (addon = this.addonDeployer.getAddon(addonName)) != null) {
            ((AddonDeployableImpl)((Object)AddonDeployableImpl.class.cast(addon))).setConfigurationDirectory(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(IAddonDeployable unpackedDeployable) {
        IAddonMetadata addonMetadata = unpackedDeployable.getMetadata();
        if (addonMetadata != null) {
            String addonName = addonMetadata.getName();
            try {
                this.stop(addonName);
            }
            catch (DeployerException e) {
                logger.error((Object)("Could not remove access to configuration files of the addon " + addonName), new Object[0]);
            }
            finally {
                try {
                    this.uninstall(addonName);
                }
                catch (DeployerException e) {
                    logger.error((Object)("Could not uninstall configuration files of the addon " + addonName), new Object[0]);
                }
            }
        } else {
            logger.error((Object)("Could not retrieve metadata of the addon " + unpackedDeployable.getShortName() + ". Configuration files couldn't be undeployed"), new Object[0]);
        }
    }

    private void register(String configurationDirectory, String addonName) throws Exception {
        AddonConfigImpl addonConfig = new AddonConfigImpl(configurationDirectory);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("addon", addonName);
        this.serviceRegistrations.add(this.bundleContext.registerService(IAddonConfig.class.getName(), (Object)addonConfig, dictionary));
    }

    private void unregister(String addonName) {
        ServiceRegistration serviceRegistration = AddonUtil.getServiceRegistration(this.serviceRegistrations, "addon", addonName);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
            this.serviceRegistrations.remove(serviceRegistration);
        }
    }

    public void setAddonDeployer(IAddonDeployer addonDeployer) {
        this.addonDeployer = addonDeployer;
    }
}

