/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.jonas.addon.deploy.impl.xml.JonasAddonPropertiesManager;
import org.ow2.jonas.addon.deploy.impl.xml.JonasAddonVersion;
import org.ow2.jonas.addon.deploy.impl.xml.JonasAddonXmlLoader;
import org.ow2.jonas.addon.deploy.jonasaddon.v1.generated.JonasAddonType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JonasAddonDesc {
    protected static Log logger = LogFactory.getLog(JonasAddonDesc.class);
    protected Object jonasAddon;
    protected JonasAddonVersion jonasAddonVersion;
    private static final String JONAS_ADDON_PROPERTIES_NAME = "properties/jonas-addon.properties";
    private static final JonasAddonVersion DEFAULT_JONAS_ADDON_VERSION = JonasAddonVersion.JONAS_ADDON_1;
    protected List<URL> xsdUrls;
    protected Map<String, Node> namespaces;
    public static final Pattern XMLNS_PATTERN = Pattern.compile("xmlns.*");

    public JonasAddonDesc() throws Exception {
        this.init();
    }

    public JonasAddonDesc(URL urlJonasAddon) throws Exception {
        this.init();
        this.loadCloudApplication(urlJonasAddon);
    }

    public JonasAddonDesc(String jonasAddon) throws Exception {
        this.init();
        this.loadCloudApplication(jonasAddon);
    }

    private void setXsdUrls() throws Exception {
        this.setXsdUrls(this.jonasAddonVersion);
    }

    private void setXsdUrls(JonasAddonVersion jonasAddonVersion) throws Exception {
        String xsdJonasAddon = JonasAddonPropertiesManager.getXsdCloudApplicationPath(jonasAddonVersion);
        LinkedHashMap resources = new LinkedHashMap();
        resources.put(xsdJonasAddon, JonasAddonVersion.class);
        this.xsdUrls = this.getXsdURL(resources);
    }

    private void init() throws Exception {
        this.xsdUrls = new LinkedList<URL>();
        this.namespaces = new LinkedHashMap<String, Node>();
        JonasAddonPropertiesManager.setProperties(this.loadProperties(JONAS_ADDON_PROPERTIES_NAME, this.getClass().getClassLoader()));
    }

    public void loadCloudApplication(URL urlJonasAddon) throws Exception {
        this.initJonasAddonVersion(urlJonasAddon);
        this.setXsdUrls();
        JonasAddonXmlLoader jonasAddonXmlLoader = new JonasAddonXmlLoader(urlJonasAddon, this.jonasAddonVersion, this.xsdUrls);
        this.jonasAddon = jonasAddonXmlLoader.getJonasAddon();
    }

    public void loadCloudApplication(String jonasAddon) throws Exception {
        this.initJonasAddonVersion(jonasAddon);
        this.setXsdUrls();
        JonasAddonXmlLoader jonasAddonXmlLoader = new JonasAddonXmlLoader(jonasAddon, this.jonasAddonVersion, this.xsdUrls);
        this.jonasAddon = jonasAddonXmlLoader.getJonasAddon();
    }

    public String generateJonasAddon(JAXBElement<JonasAddonType> jonasAddon) throws Exception {
        JonasAddonXmlLoader jonasAddonXmlLoader = new JonasAddonXmlLoader();
        this.setXsdUrls(DEFAULT_JONAS_ADDON_VERSION);
        return jonasAddonXmlLoader.toXml(jonasAddon, this.xsdUrls, DEFAULT_JONAS_ADDON_VERSION);
    }

    public void generateJonasAddon(JAXBElement<JonasAddonType> jonasAddon, ZipOutputStream zipOutputStream) throws Exception {
        JonasAddonXmlLoader jonasAddonXmlLoader = new JonasAddonXmlLoader();
        this.setXsdUrls(DEFAULT_JONAS_ADDON_VERSION);
        jonasAddonXmlLoader.toXml(jonasAddon, this.xsdUrls, DEFAULT_JONAS_ADDON_VERSION, zipOutputStream);
    }

    private void initJonasAddonVersion(URL urlJonasAddon) {
        this.initJonasAddonVersion(this.getFile(urlJonasAddon));
    }

    private void initJonasAddonVersion(File jonasAddonFile) {
        this.initJonasAddonVersion(this.getDocument(jonasAddonFile));
    }

    private void initJonasAddonVersion(String jonasAddon) {
        this.initJonasAddonVersion(this.getDocument(jonasAddon));
    }

    private void initJonasAddonVersion(Document document) {
        if (document != null) {
            this.getNamespace(document);
        }
        this.jonasAddonVersion = JonasAddonPropertiesManager.getJonasAddonVersion(new LinkedList<String>(this.namespaces.keySet()));
    }

    protected Properties loadProperties(String location, ClassLoader classLoader) throws Exception {
        Properties properties = new Properties();
        InputStream input = classLoader.getResourceAsStream(location);
        try {
            properties.load(input);
        }
        catch (Exception e) {
            throw new Exception("Cannot load " + location + " properties file", e);
        }
        finally {
            input.close();
        }
        return properties;
    }

    protected void getNamespace(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int y = 0; y < namedNodeMap.getLength(); ++y) {
                Attr attribute = (Attr)Attr.class.cast(namedNodeMap.item(y));
                if (!XMLNS_PATTERN.matcher(attribute.getName()).matches()) continue;
                String namespace = attribute.getValue();
                if (namespace != null && !namespace.isEmpty()) {
                    this.namespaces.put(namespace, child);
                }
                this.getNamespace(child);
            }
        }
    }

    protected List<URL> getXsdURL(Map<String, Class<?>> resources) throws Exception {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (Map.Entry<String, Class<?>> resource : resources.entrySet()) {
            URL url = this.getXsdURL(resource);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    protected URL getXsdURL(Map.Entry<String, Class<?>> resource) throws Exception {
        String resourceName = resource.getKey();
        Class<?> clazz = resource.getValue();
        return this.getXsdURL(resourceName, clazz);
    }

    protected URL getXsdURL(String resource, Class clazz) throws Exception {
        URL url = clazz.getClassLoader().getResource(resource);
        if (url == null && (url = clazz.getResource(resource)) == null) {
            throw new Exception("Cannot get the URL of the resource " + resource + "\n");
        }
        return url;
    }

    protected File getFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Cannot get the URI of the URL " + url.getFile()), new Object[]{e});
            return null;
        }
    }

    protected Document getDocument(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Cannot get the instance of the DocumentBuilder", new Object[]{e});
        }
        if (documentBuilder != null) {
            try {
                document = documentBuilder.parse(file);
            }
            catch (SAXException e) {
                logger.error((Object)("Cannot parse XML file " + file.getAbsolutePath()), new Object[]{e});
            }
            catch (IOException e) {
                logger.error((Object)("Cannot parse XML file " + file.getAbsolutePath()), new Object[]{e});
            }
        }
        return document;
    }

    protected Document getDocument(String content) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Cannot get the instance of the DocumentBuilder", new Object[]{e});
        }
        if (documentBuilder != null) {
            try {
                document = documentBuilder.parse(new InputSource(new StringReader(content.trim())));
            }
            catch (SAXException e) {
                logger.error((Object)("Cannot parse XML content of " + content), new Object[]{e});
            }
            catch (IOException e) {
                logger.error((Object)("Cannot parse XML content of " + content), new Object[]{e});
            }
        }
        return document;
    }
}

