/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.console;

import java.io.PrintStream;
import java.util.Set;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.fusesource.jansi.Ansi;
import org.ow2.shelbie.core.IUsagePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
public class AnsiUsagePrinter
implements IUsagePrinter,
Pojo {
    private InstanceManager __IM;
    private boolean __MprintUsage$org_apache_felix_gogo_commands_Command$java_util_Set$java_util_Set$java_io_PrintStream;
    private boolean __Mindent$org_fusesource_jansi_Ansi$int;
    private boolean __Meol$org_fusesource_jansi_Ansi$int;
    private boolean __MsectionTitle$org_fusesource_jansi_Ansi$java_lang_String;
    private boolean __Mbold$org_fusesource_jansi_Ansi$java_lang_String;
    private boolean __Munderline$org_fusesource_jansi_Ansi$java_lang_String;

    public AnsiUsagePrinter() {
        this(null);
    }

    private AnsiUsagePrinter(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Override
    public void printUsage(Command command, Set<Option> set, Set<Argument> set2, PrintStream printStream) {
        if (!this.__MprintUsage$org_apache_felix_gogo_commands_Command$java_util_Set$java_util_Set$java_io_PrintStream) {
            this.__M_printUsage(command, set, set2, printStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printUsage$org_apache_felix_gogo_commands_Command$java_util_Set$java_util_Set$java_io_PrintStream", new Object[]{command, set, set2, printStream});
            this.__M_printUsage(command, set, set2, printStream);
            this.__IM.onExit((Object)this, "printUsage$org_apache_felix_gogo_commands_Command$java_util_Set$java_util_Set$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printUsage$org_apache_felix_gogo_commands_Command$java_util_Set$java_util_Set$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __M_printUsage(Command command, Set<Option> options, Set<Argument> arguments, PrintStream out) {
        Ansi buffer = Ansi.ansi();
        if (command.description() != null && command.description().length() > 0) {
            this.eol(buffer, 1);
            this.indent(buffer, 1);
            this.bold(buffer, command.name());
            buffer.a(" - ");
            buffer.a(command.description());
            this.eol(buffer, 2);
        }
        this.sectionTitle(buffer, "Syntax");
        this.indent(buffer, 1);
        this.bold(buffer, command.scope() + ":" + command.name());
        if (options.size() > 0) {
            buffer.a(" [");
            this.underline(buffer, "options");
            buffer.a("]...");
        }
        if (arguments.size() > 0) {
            buffer.a(" [");
            this.underline(buffer, "arguments");
            buffer.a("]...");
        }
        this.eol(buffer, 2);
        if (arguments.size() > 0) {
            this.sectionTitle(buffer, "Arguments");
            for (Argument argument : arguments) {
                this.indent(buffer, 1);
                this.bold(buffer, argument.name());
                buffer.a(" : ");
                buffer.a(argument.description());
                this.eol(buffer, 1);
            }
            this.eol(buffer, 1);
        }
        if (options.size() > 0) {
            this.sectionTitle(buffer, "Options");
            for (Option option : options) {
                this.indent(buffer, 1);
                this.bold(buffer, option.name());
                if (option.aliases().length > 0) {
                    for (String alias : option.aliases()) {
                        buffer.a(", ");
                        this.bold(buffer, alias);
                    }
                }
                if (option.required()) {
                    this.bold(buffer, " [required]");
                }
                this.eol(buffer, 1);
                this.indent(buffer, 2);
                buffer.a(option.description());
                if (option.multiValued()) {
                    this.eol(buffer, 1);
                    this.indent(buffer, 3);
                    buffer.a("- this option accept multiple occurrences on the same command line -");
                }
                this.eol(buffer, 1);
            }
            this.eol(buffer, 1);
        }
        out.println(buffer.toString());
    }

    private void indent(Ansi ansi, int n) {
        if (!this.__Mindent$org_fusesource_jansi_Ansi$int) {
            this.__M_indent(ansi, n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "indent$org_fusesource_jansi_Ansi$int", new Object[]{ansi, new Integer(n)});
            this.__M_indent(ansi, n);
            this.__IM.onExit((Object)this, "indent$org_fusesource_jansi_Ansi$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "indent$org_fusesource_jansi_Ansi$int", throwable);
            throw throwable;
        }
    }

    private void __M_indent(Ansi buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.a("  ");
        }
    }

    private void eol(Ansi ansi, int n) {
        if (!this.__Meol$org_fusesource_jansi_Ansi$int) {
            this.__M_eol(ansi, n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "eol$org_fusesource_jansi_Ansi$int", new Object[]{ansi, new Integer(n)});
            this.__M_eol(ansi, n);
            this.__IM.onExit((Object)this, "eol$org_fusesource_jansi_Ansi$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "eol$org_fusesource_jansi_Ansi$int", throwable);
            throw throwable;
        }
    }

    private void __M_eol(Ansi buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.a("\n");
        }
    }

    private void sectionTitle(Ansi ansi, String string) {
        if (!this.__MsectionTitle$org_fusesource_jansi_Ansi$java_lang_String) {
            this.__M_sectionTitle(ansi, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "sectionTitle$org_fusesource_jansi_Ansi$java_lang_String", new Object[]{ansi, string});
            this.__M_sectionTitle(ansi, string);
            this.__IM.onExit((Object)this, "sectionTitle$org_fusesource_jansi_Ansi$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "sectionTitle$org_fusesource_jansi_Ansi$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_sectionTitle(Ansi buffer, String message) {
        buffer.fg(Ansi.Color.BLUE);
        this.bold(buffer, " **** " + message + " ****");
        buffer.reset();
        this.eol(buffer, 1);
    }

    private void bold(Ansi ansi, String string) {
        if (!this.__Mbold$org_fusesource_jansi_Ansi$java_lang_String) {
            this.__M_bold(ansi, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bold$org_fusesource_jansi_Ansi$java_lang_String", new Object[]{ansi, string});
            this.__M_bold(ansi, string);
            this.__IM.onExit((Object)this, "bold$org_fusesource_jansi_Ansi$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bold$org_fusesource_jansi_Ansi$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_bold(Ansi buffer, String message) {
        buffer.a(Ansi.Attribute.INTENSITY_BOLD);
        buffer.a(message);
        buffer.a(Ansi.Attribute.INTENSITY_BOLD_OFF);
    }

    private void underline(Ansi ansi, String string) {
        if (!this.__Munderline$org_fusesource_jansi_Ansi$java_lang_String) {
            this.__M_underline(ansi, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "underline$org_fusesource_jansi_Ansi$java_lang_String", new Object[]{ansi, string});
            this.__M_underline(ansi, string);
            this.__IM.onExit((Object)this, "underline$org_fusesource_jansi_Ansi$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "underline$org_fusesource_jansi_Ansi$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_underline(Ansi buffer, String message) {
        buffer.a(Ansi.Attribute.UNDERLINE);
        buffer.a(message);
        buffer.a(Ansi.Attribute.UNDERLINE_OFF);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("printUsage$org_apache_felix_gogo_commands_Command$java_util_Set$java_util_Set$java_io_PrintStream")) {
                this.__MprintUsage$org_apache_felix_gogo_commands_Command$java_util_Set$java_util_Set$java_io_PrintStream = true;
            }
            if (set.contains("indent$org_fusesource_jansi_Ansi$int")) {
                this.__Mindent$org_fusesource_jansi_Ansi$int = true;
            }
            if (set.contains("eol$org_fusesource_jansi_Ansi$int")) {
                this.__Meol$org_fusesource_jansi_Ansi$int = true;
            }
            if (set.contains("sectionTitle$org_fusesource_jansi_Ansi$java_lang_String")) {
                this.__MsectionTitle$org_fusesource_jansi_Ansi$java_lang_String = true;
            }
            if (set.contains("bold$org_fusesource_jansi_Ansi$java_lang_String")) {
                this.__Mbold$org_fusesource_jansi_Ansi$java_lang_String = true;
            }
            if (set.contains("underline$org_fusesource_jansi_Ansi$java_lang_String")) {
                this.__Munderline$org_fusesource_jansi_Ansi$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

