/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.converter;

import java.io.ByteArrayInputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.service.command.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
public class BasicTypesConverter
implements Converter,
Pojo {
    private InstanceManager __IM;
    private boolean __Mconvert$java_lang_Class$java_lang_Object;
    private boolean __Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter;

    public BasicTypesConverter() {
        this(null);
    }

    private BasicTypesConverter(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object convert(Class<?> clazz, Object object) throws Exception {
        Object object2;
        if (!this.__Mconvert$java_lang_Class$java_lang_Object) {
            return this.__M_convert(clazz, object);
        }
        try {
            this.__IM.onEntry((Object)this, "convert$java_lang_Class$java_lang_Object", new Object[]{clazz, object});
            object2 = this.__M_convert(clazz, object);
            this.__IM.onExit((Object)this, "convert$java_lang_Class$java_lang_Object", object2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convert$java_lang_Class$java_lang_Object", throwable);
            throw throwable;
        }
        return object2;
    }

    private Object __M_convert(Class<?> toType, Object value) throws Exception {
        if (Class.class.equals(toType)) {
            try {
                return Class.forName(value.toString());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (Locale.class.equals(toType)) {
            String[] tokens = value.toString().split("_");
            if (tokens.length == 1) {
                return new Locale(tokens[0]);
            }
            if (tokens.length == 2) {
                return new Locale(tokens[0], tokens[1]);
            }
            if (tokens.length == 3) {
                return new Locale(tokens[0], tokens[1], tokens[2]);
            }
            throw new Exception("Invalid locale string:" + value);
        }
        if (Pattern.class.equals(toType)) {
            return Pattern.compile(value.toString());
        }
        if (Properties.class.equals(toType)) {
            Properties props = new Properties();
            ByteArrayInputStream in = new ByteArrayInputStream(value.toString().getBytes("UTF8"));
            props.load(in);
            return props;
        }
        if (Boolean.class.equals(toType) || Boolean.TYPE.equals(toType)) {
            if ("yes".equalsIgnoreCase(value.toString()) || "true".equalsIgnoreCase(value.toString()) || "on".equalsIgnoreCase(value.toString())) {
                return Boolean.TRUE;
            }
            if ("no".equalsIgnoreCase(value.toString()) || "false".equalsIgnoreCase(value.toString()) || "off".equalsIgnoreCase(value.toString())) {
                return Boolean.FALSE;
            }
            throw new Exception("Invalid boolean value: " + value);
        }
        if (Integer.class.equals(toType) || Integer.TYPE.equals(toType)) {
            return Integer.valueOf(value.toString());
        }
        if (Short.class.equals(toType) || Short.TYPE.equals(toType)) {
            return Short.valueOf(value.toString());
        }
        if (Long.class.equals(toType) || Long.TYPE.equals(toType)) {
            return Long.valueOf(value.toString());
        }
        if (Float.class.equals(toType) || Float.TYPE.equals(toType)) {
            return Float.valueOf(value.toString());
        }
        if (Double.class.equals(toType) || Double.TYPE.equals(toType)) {
            return Double.valueOf(value.toString());
        }
        if (Character.class.equals(toType) || Character.TYPE.equals(toType)) {
            if (value.toString().length() == 6 && value.toString().startsWith("\\u")) {
                int code = Integer.parseInt(value.toString().substring(2), 16);
                return Character.valueOf((char)code);
            }
            if (value.toString().length() == 1) {
                return Character.valueOf(value.toString().charAt(0));
            }
            throw new Exception("Invalid value for character type: " + value);
        }
        if (Byte.class.equals(toType) || Byte.TYPE.equals(toType)) {
            return Byte.valueOf(value.toString());
        }
        if (Enum.class.isAssignableFrom(toType)) {
            return Enum.valueOf(toType, value.toString());
        }
        return null;
    }

    public CharSequence format(Object object, int n, Converter converter) throws Exception {
        CharSequence charSequence;
        if (!this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter) {
            return this.__M_format(object, n, converter);
        }
        try {
            this.__IM.onEntry((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", new Object[]{object, new Integer(n), converter});
            charSequence = this.__M_format(object, n, converter);
            this.__IM.onExit((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_format(Object o, int i, Converter converter) throws Exception {
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("convert$java_lang_Class$java_lang_Object")) {
                this.__Mconvert$java_lang_Class$java_lang_Object = true;
            }
            if (set.contains("format$java_lang_Object$int$org_apache_felix_service_command_Converter")) {
                this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

