/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.configadmin.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.cm.Configuration;
import org.ow2.jonas.configadmin.AdapterException;
import org.ow2.jonas.configadmin.ConfigurationInfo;
import org.ow2.jonas.configadmin.XmlConfigurationAdapter;
import org.ow2.jonas.configadmin.XmlConfigurationAdapterRegistry;
import org.ow2.jonas.configadmin.internal.AdapterRegistryEvent;
import org.ow2.jonas.configadmin.internal.AdapterRegistryListener;
import org.ow2.jonas.configadmin.internal.ConfigurationAssociationEvent;
import org.ow2.jonas.configadmin.internal.ConfigurationAssociationListener;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Element;

public class ConfigurationItem
implements AdapterRegistryListener {
    private static final Log logger = LogFactory.getLog(ConfigurationItem.class);
    private Element element;
    private Set<Configuration> configurations;
    private XmlConfigurationAdapterRegistry registry;
    private List<ConfigurationAssociationListener> listeners = new ArrayList<ConfigurationAssociationListener>();
    private boolean failed = false;

    public ConfigurationItem(Element element) {
        this.configurations = new HashSet<Configuration>();
        this.element = element;
    }

    public Set<Configuration> getConfigurations() {
        return this.configurations;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void addAssociationListener(ConfigurationAssociationListener listener) {
        this.listeners.add(listener);
    }

    public void removeAssociationListener(ConfigurationAssociationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onAdapterRegistryArrival(AdapterRegistryEvent event) {
        XmlConfigurationAdapterRegistry registry;
        XmlConfigurationAdapter adapter;
        if (this.registry == null && event.getNamespace().equals(this.element.getNamespaceURI()) && (adapter = (registry = event.getSource()).getAdapter(this.element.getLocalName())) != null) {
            try {
                this.firesAssociationEvent(adapter.convert(this.element));
                this.registry = registry;
                this.failed = false;
            }
            catch (AdapterException e) {
                logger.error((Object)"Cannot convert <{0}:{1} ...> using {2}", new Object[]{this.element.getPrefix(), this.element.getLocalName(), adapter.getClass(), e});
                this.failed = true;
            }
            catch (RuntimeException re) {
                logger.error((Object)"Error when handling <{0}:{1} ...>", new Object[]{this.element.getPrefix(), this.element.getLocalName(), re});
                this.failed = true;
            }
        }
    }

    private void firesAssociationEvent(Set<ConfigurationInfo> info) {
        ConfigurationAssociationEvent event = new ConfigurationAssociationEvent(this, info);
        for (ConfigurationAssociationListener listener : this.listeners) {
            listener.onAssociation(event);
        }
    }

    @Override
    public void onAdapterRegistryRemoval(AdapterRegistryEvent event) {
        if (this.registry != null && this.registry == event.getSource()) {
            this.registry = null;
            this.firesDissociationEvent();
        }
    }

    private void firesDissociationEvent() {
        ConfigurationAssociationEvent event = new ConfigurationAssociationEvent(this, null);
        for (ConfigurationAssociationListener listener : this.listeners) {
            listener.onDissociation(event);
        }
    }

    public void close() {
        if (this.registry != null) {
            this.firesDissociationEvent();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigurationItem");
        sb.append("{element=").append(this.element);
        sb.append(", configurations=").append(this.configurations);
        sb.append('}');
        return sb.toString();
    }
}

