/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployable.factory;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.util.archive.api.IFileArchive;
import org.ow2.util.ee.deploy.api.deployable.FileDeployable;
import org.ow2.util.ee.deploy.api.deployable.factory.FileDeployableException;
import org.ow2.util.ee.deploy.api.deployable.factory.XmlFileDeployableFactory;
import org.ow2.util.ee.deploy.impl.deployable.factory.utils.XmlHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFileDeployableFactoryImpl
implements XmlFileDeployableFactory {
    private Log logger = LogFactory.getLog(XmlFileDeployableFactoryImpl.class);
    private XmlHelper xmlHelper = new XmlHelper();
    private Map<String, Class<? extends FileDeployable<?, ?>>> xmlNSToDeployableMap = new HashMap();

    private FileDeployable<?, ?> getXmlFileDeployable(IFileArchive fileArchive, String nameSpace) throws FileDeployableException {
        Class<FileDeployable<?, ?>> clazz = this.xmlNSToDeployableMap.get(nameSpace);
        if (clazz == null) {
            this.logger.debug((Object)"The XML namespace {0} found in the archive ''{0}'' is not handled by a factory", new Object[]{nameSpace, fileArchive});
            return null;
        }
        Constructor<FileDeployable<?, ?>> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(IFileArchive.class);
        }
        catch (NoSuchMethodException e) {
            this.logger.error((Object)"No {0}(IArchive archive) constructor; aborting deployable generation", new Object[]{clazz.getName()});
            throw new FileDeployableException(e);
        }
        try {
            return constructor.newInstance(fileArchive);
        }
        catch (InvocationTargetException e) {
            Throwable nested = e.getCause();
            throw new FileDeployableException(nested);
        }
        catch (Exception e) {
            this.logger.error((Object)"Caught error on constructor invokation : {0}", new Object[]{e});
            throw new FileDeployableException();
        }
    }

    @Override
    public FileDeployable<?, ?> getFileDeployable(IFileArchive fileArchive) throws FileDeployableException {
        String namespace = null;
        try {
            namespace = this.xmlHelper.getRootElementNameSpace(fileArchive.getFile());
        }
        catch (IOException e) {
            this.logger.error((Object)"IO Exception while parsing file {0}", new Object[]{fileArchive.getFile(), e});
            throw new FileDeployableException(e);
        }
        catch (SAXException e) {
            this.logger.error((Object)"Exception while parsing file {0} : this is not a XML file", new Object[]{fileArchive.getFile(), e});
            throw new FileDeployableException(e);
        }
        return this.getXmlFileDeployable(fileArchive, namespace);
    }

    @Override
    public void registerFileDeployable(Class<? extends FileDeployable<?, ?>> clazz, String nameSpace) {
        this.xmlNSToDeployableMap.put(nameSpace, clazz);
    }

    @Override
    public void unregisterFileDeployable(String nameSpace) {
        this.xmlNSToDeployableMap.remove(nameSpace);
    }
}

