/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonService;

@Command(name="inspect", scope="addon", description="inspect addon dependency information")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class InspectCommand
implements Action,
Pojo {
    private InstanceManager __IM;
    public static final String REQUIREMENT_TOKEN = "requirement";
    public static final String CAPABILITY_TOKEN = "capability";
    private boolean __FaddonService;
    @Requires(optional=false)
    private IAddonService addonService;
    private boolean __Farguments;
    @Argument(name="arguments", required=true, multiValued=true)
    private List<String> arguments;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    IAddonService __getaddonService() {
        if (!this.__FaddonService) {
            return this.addonService;
        }
        return (IAddonService)this.__IM.onGet((Object)this, "addonService");
    }

    void __setaddonService(IAddonService iAddonService) {
        if (!this.__FaddonService) {
            this.addonService = iAddonService;
            return;
        }
        this.__IM.onSet((Object)this, "addonService", (Object)iAddonService);
    }

    List __getarguments() {
        if (!this.__Farguments) {
            return this.arguments;
        }
        return (List)this.__IM.onGet((Object)this, "arguments");
    }

    void __setarguments(List list) {
        if (!this.__Farguments) {
            this.arguments = list;
            return;
        }
        this.__IM.onSet((Object)this, "arguments", (Object)list);
    }

    public InspectCommand() {
        this(null);
    }

    private InspectCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession commandSession) throws Exception {
        int nbArgs = this.__getarguments().size();
        if (nbArgs < 1) {
            return "Invalid arguments";
        }
        String type = (String)this.__getarguments().get(0);
        if (REQUIREMENT_TOKEN.equals(type)) {
            Long addonId;
            if (nbArgs != 2) {
                return "Invalid arguments";
            }
            try {
                addonId = Long.parseLong((String)this.__getarguments().get(1));
            }
            catch (NumberFormatException e) {
                return "Invalid addon id";
            }
            IAddonDeployable addon = this.__getaddonService().getAddon(addonId.longValue());
            if (addon == null) {
                return "Could not retrieve addon with id " + addonId;
            }
            List requirements = addon.getRequirements();
            return InspectCommand.printList(requirements);
        }
        if (CAPABILITY_TOKEN.equals(type)) {
            if (nbArgs == 1) {
                List addons = this.__getaddonService().getAddons();
                ArrayList<String> capabilities = new ArrayList<String>();
                for (IAddonDeployable addon : addons) {
                    List list = addon.getCapabilities();
                    for (String capability : list) {
                        if (capabilities.contains(capability)) continue;
                        capabilities.add(capability);
                    }
                }
                return InspectCommand.printList(capabilities);
            }
            if (nbArgs == 2) {
                Long addonId;
                try {
                    addonId = Long.parseLong((String)this.__getarguments().get(1));
                }
                catch (NumberFormatException e) {
                    return "Invalid addon id";
                }
                IAddonDeployable addon = this.__getaddonService().getAddon(addonId.longValue());
                if (addon == null) {
                    return "Could not retrieve addon with id " + addonId;
                }
                List capabilities = addon.getCapabilities();
                return InspectCommand.printList(capabilities);
            }
            return "Invalid arguments";
        }
        return "Invalid arguments";
    }

    public static String printList(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append(list.get(i));
                if (i >= list.size() - 1) continue;
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("addonService")) {
                this.__FaddonService = true;
            }
            if (set.contains("arguments")) {
                this.__Farguments = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

