/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.commands;

import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="list", scope="addon", description="list all installed addons")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class ListAddonCommand
implements Action,
Pojo {
    private InstanceManager __IM;
    public static final String EOL = "\n";
    private boolean __FaddonService;
    @Requires(optional=false)
    private IAddonService addonService;
    private static Log logger = LogFactory.getLog(ListAddonCommand.class);
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    IAddonService __getaddonService() {
        if (!this.__FaddonService) {
            return this.addonService;
        }
        return (IAddonService)this.__IM.onGet((Object)this, "addonService");
    }

    void __setaddonService(IAddonService iAddonService) {
        if (!this.__FaddonService) {
            this.addonService = iAddonService;
            return;
        }
        this.__IM.onSet((Object)this, "addonService", (Object)iAddonService);
    }

    public ListAddonCommand() {
        this(null);
    }

    private ListAddonCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession commandSession) throws Exception {
        List addons = this.__getaddonService().getAddons();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("   ID|Parent ID|State      |Name");
            for (IAddonDeployable addon : addons) {
                String state = ListAddonCommand.getStateAsString(addon.getState());
                if (state == null) continue;
                String id = String.valueOf(addon.getAddonId());
                while (id.length() < 4) {
                    id = " " + id;
                }
                IAddonDeployable parent = addon.getParent();
                String parentId = parent != null ? String.valueOf(parent.getAddonId()) : "none";
                while (parentId.length() < 4) {
                    parentId = " " + parentId;
                }
                stringBuilder.append("\n " + id + "|     " + parentId + "|" + state + "|" + addon.getMetadata().getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could get the list of addons", new Object[]{e});
        }
        return stringBuilder.toString();
    }

    public static String getStateAsString(Integer state) {
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("addonService")) {
            this.__FaddonService = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

