/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.bootstrap;

import org.apache.tools.ant.taskdefs.Java;
import org.ow2.jonas.antmodular.bootstrap.BootstrapTask;

public class JOnASTask
extends BootstrapTask {
    private static final String ADMIN_CLASS = "org.ow2.jonas.commands.admin.ClientAdmin";
    private static final String CHECKENV_CLASS = "org.ow2.jonas.commands.check.CheckEnv";
    private static final String VERSION_CLASS = "org.ow2.jonas.Version";
    private Mode mode = Mode.START;

    public void execute() {
        Java bootstrapTask = this.getBootstraptask(this.mode.getMainClass());
        this.mode.configureJava(bootstrapTask);
        bootstrapTask.executeJava();
    }

    public void setMode(String mode) {
        this.mode = Mode.valueOf(mode.toUpperCase());
    }

    private static enum Mode {
        START{

            @Override
            public void configureJava(Java task) {
                task.clearArgs();
                task.setClassname(JOnASTask.ADMIN_CLASS);
                task.createArg().setValue("-start");
            }

            @Override
            public String getMainClass() {
                return JOnASTask.ADMIN_CLASS;
            }
        }
        ,
        STOP{

            @Override
            public void configureJava(Java task) {
                task.createArg().setValue("-stop");
            }

            @Override
            public String getMainClass() {
                return JOnASTask.ADMIN_CLASS;
            }
        }
        ,
        JNDI{

            @Override
            public void configureJava(Java task) {
                task.createArg().setValue("-j");
            }

            @Override
            public String getMainClass() {
                return JOnASTask.ADMIN_CLASS;
            }
        }
        ,
        CHECK{

            @Override
            public void configureJava(Java task) {
            }

            @Override
            public String getMainClass() {
                return JOnASTask.CHECKENV_CLASS;
            }
        }
        ,
        VERSION{

            @Override
            public void configureJava(Java task) {
            }

            @Override
            public String getMainClass() {
                return JOnASTask.VERSION_CLASS;
            }
        }
        ,
        PING{

            @Override
            public void configureJava(Java task) {
                task.createArg().setValue("-ping");
            }

            @Override
            public String getMainClass() {
                return JOnASTask.ADMIN_CLASS;
            }
        };


        public abstract void configureJava(Java var1);

        public abstract String getMainClass();
    }
}

