/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader.locator;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.ow2.jonas.lib.loader.locator.Locator;

public class JarFileLocator
extends Locator {
    private JarFile file = null;

    public JarFileLocator(URL jar) throws IOException {
        String filename = jar.getFile();
        this.file = new JarFile(filename);
    }

    @Override
    public boolean hasFile(String path) {
        ZipEntry entry = this.file.getEntry(path);
        return entry != null;
    }

    @Override
    public boolean hasDirectory(String path) {
        boolean found = false;
        Enumeration<JarEntry> e = this.file.entries();
        while (e.hasMoreElements() && !found) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().startsWith(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List listContent(String path) {
        Vector<String> libs = new Vector<String>();
        Enumeration<JarEntry> e = this.file.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().startsWith(path)) continue;
            libs.add(entry.getName());
        }
        return libs;
    }
}

