/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.ow2.carol.jndi.wrapping.JNDIRemoteResource;
import org.ow2.carol.jndi.wrapping.RemoteReference;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;
import org.ow2.carol.util.configuration.ConfigurationRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsContext
implements Context {
    private static final String JAVA_GLOBAL_PREFIX = "java:global/";
    private static final int JAVA_GLOBAL_PREFIX_LENGTH = "java:global/".length();
    private Context wrappedContext = null;
    private Hashtable<Object, Object> exportedObjects = new Hashtable();

    protected AbsContext(Context ctx) {
        this.wrappedContext = ctx;
    }

    protected abstract Object unwrapObject(Object var1, Name var2) throws NamingException;

    protected abstract Object wrapObject(Object var1, Name var2, boolean var3) throws NamingException;

    protected Object defaultUnwrapObject(Object o, Name name) throws NamingException {
        try {
            if (o instanceof JNDIRemoteResource) {
                return ((JNDIRemoteResource)o).getResource();
            }
            if (o instanceof RemoteReference) {
                Reference objRef = ((RemoteReference)o).getReference();
                if (objRef instanceof LinkRef) {
                    return this.lookup(((LinkRef)objRef).getLinkName());
                }
                return NamingManager.getObjectInstance(objRef, name, this, this.getEnvironment());
            }
            return o;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot unwrap object '" + o + "' with name '" + name + "' :" + e.getMessage(), e);
        }
    }

    protected int getObjectPort() {
        return 0;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        return this.unwrapObject(this.wrappedContext.lookup(this.encode(name)), name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name.startsWith(JAVA_GLOBAL_PREFIX)) {
            return this.lookup(name.substring(JAVA_GLOBAL_PREFIX_LENGTH));
        }
        return this.lookup(new CompositeName(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot bind empty name");
        }
        this.wrappedContext.bind(this.encode(name), this.wrapObject(obj, name, false));
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot rebind empty name");
        }
        this.wrappedContext.rebind(this.encode(name), this.wrapObject(obj, name, true));
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot unbind empty name");
        }
        try {
            this.wrappedContext.unbind(this.encode(name));
            if (this.exportedObjects.containsKey(name)) {
                ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject().unexportObject((Remote)this.exportedObjects.remove(name));
            }
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot unbind name '" + name + "' : " + e.getMessage(), e);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (this.exportedObjects.containsKey(oldName)) {
            this.exportedObjects.put(newName, this.exportedObjects.remove(oldName));
        }
        this.wrappedContext.rename(this.encode(oldName), this.encode(newName));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return new WrappedEnumeration<NameClassPair>(this.wrappedContext.list(this.encode(name)));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return new WrappedEnumeration<Binding>(this.wrappedContext.listBindings(this.encode(name)));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.wrappedContext.destroySubcontext(this.encode(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.wrappedContext.createSubcontext(this.encode(name));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.wrappedContext.lookupLink(this.encode(name));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.wrappedContext.getNameParser(this.encode(name));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return (Name)name.clone();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.wrappedContext.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.wrappedContext.removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.wrappedContext.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.wrappedContext.getNameInNamespace();
    }

    protected Object addToExported(Name name, Object o) {
        return this.exportedObjects.put(name, o);
    }

    protected Context getWrappedContext() {
        return this.wrappedContext;
    }

    protected Name encode(Name initialName) {
        String name = initialName.toString();
        if (name.length() < 1) {
            return initialName;
        }
        StringBuffer newname = new StringBuffer(name);
        for (int i = 0; i < newname.length(); ++i) {
            char c = newname.charAt(i);
            if (c != '/' && c != '\\') continue;
            newname.insert(i, '\\');
            ++i;
        }
        if (newname.charAt(0) == '\"' || newname.charAt(0) == '\'') {
            newname.insert(0, '\\');
        }
        try {
            return new CompositeName(newname.toString());
        }
        catch (InvalidNameException e) {
            return initialName;
        }
    }

    protected String decode(String name) {
        StringBuffer newname = new StringBuffer(name);
        if (newname.length() >= 2 && (newname.charAt(0) == '\"' || newname.charAt(0) == '\'') && newname.charAt(0) == newname.charAt(newname.length() - 1)) {
            newname.deleteCharAt(0);
            newname.deleteCharAt(newname.length() - 1);
        }
        if (name.indexOf(92) < 0) {
            return newname.toString();
        }
        int i = 0;
        while (i < newname.length()) {
            if (newname.charAt(i) == '\\') {
                newname.deleteCharAt(i);
                ++i;
                continue;
            }
            ++i;
        }
        return newname.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WrappedEnumeration<T extends NameClassPair>
    implements NamingEnumeration<T> {
        private NamingEnumeration<T> wrappedEnumeration;

        WrappedEnumeration(NamingEnumeration<T> wrappedEnumeration) {
            this.wrappedEnumeration = wrappedEnumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.wrappedEnumeration.hasMoreElements();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public T nextElement() {
            NameClassPair ncp = (NameClassPair)this.wrappedEnumeration.nextElement();
            ncp.setName(AbsContext.this.decode(ncp.getName()));
            return (T)ncp;
        }

        @Override
        public T next() {
            return (T)this.nextElement();
        }

        @Override
        public void close() throws NamingException {
            this.wrappedEnumeration = null;
        }
    }
}

