/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUtil;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.ProviderUtil;

public class Persistence {
    @Deprecated
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PeristenceProvider";
    @Deprecated
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    private static final String PERSISTENCE_PROVIDER_MAP_PROPERTY = "javax.persistence.provider";

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, null);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        if (properties != null) {
            Object object = properties.get(PERSISTENCE_PROVIDER_MAP_PROPERTY);
            if (!(object instanceof String)) {
                throw new PersistenceException("Found 'javax.persistence.provider' property in the map but the value is not a String. Found object : '" + object + "'.");
            }
            String persistenceProviderName = (String)object;
            PersistenceProvider persistenceProvider = Persistence.getProviderForName(persistenceProviderName);
            if (persistenceProvider == null) {
                throw new PersistenceException("Property 'javax.persistence.provider' with value '" + persistenceProviderName + "' was provided in the Map properties but no persistence provider with this name has been found");
            }
            EntityManagerFactory entityManagerFactory = persistenceProvider.createEntityManagerFactory(persistenceUnitName, properties);
            if (entityManagerFactory == null) {
                throw new PersistenceException("Property 'javax.persistence.provider' with value '" + persistenceProviderName + "' was provided in the Map properties but the persistence provider returns " + "an empty factory for the given persistence unit '" + persistenceUnitName + "'.");
            }
            return entityManagerFactory;
        }
        EntityManagerFactory entityManagerFactory = null;
        for (PersistenceProvider persistenceProvider : PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders()) {
            entityManagerFactory = persistenceProvider.createEntityManagerFactory(persistenceUnitName, properties);
            if (entityManagerFactory == null) continue;
            return entityManagerFactory;
        }
        throw new PersistenceException("No EntityManagerFactory have been created in the list of '" + providers.size() + "' providers available.");
    }

    private static PersistenceProvider getProviderForName(String persistenceProviderName) {
        PersistenceProvider persistenceProvider = null;
        for (PersistenceProvider tmpProvider : PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders()) {
            if (!tmpProvider.getClass().getName().equals(persistenceProviderName)) continue;
            persistenceProvider = tmpProvider;
            break;
        }
        return persistenceProvider;
    }

    public static PersistenceUtil getPersistenceUtil() {
        return new PersistenceUtilImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PersistenceUtilImpl
    implements PersistenceUtil {
        private PersistenceUtilImpl() {
        }

        private static List<PersistenceProvider> getPersistenceProviders() {
            return PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders();
        }

        @Override
        public boolean isLoaded(Object entity, String attributeName) {
            LoadState loadState;
            ProviderUtil providerUtil;
            List<PersistenceProvider> persistenceProviders = PersistenceUtilImpl.getPersistenceProviders();
            if (persistenceProviders == null) {
                return true;
            }
            for (PersistenceProvider persistenceProvider : persistenceProviders) {
                providerUtil = null;
                try {
                    providerUtil = persistenceProvider.getProviderUtil();
                }
                catch (IncompatibleClassChangeError ame) {
                    continue;
                }
                loadState = providerUtil.isLoadedWithoutReference(entity, attributeName);
                if (LoadState.LOADED == loadState) {
                    return true;
                }
                if (LoadState.NOT_LOADED != loadState) continue;
                return false;
            }
            for (PersistenceProvider persistenceProvider : persistenceProviders) {
                providerUtil = null;
                try {
                    providerUtil = persistenceProvider.getProviderUtil();
                }
                catch (IncompatibleClassChangeError ame) {
                    continue;
                }
                loadState = providerUtil.isLoadedWithReference(entity, attributeName);
                if (LoadState.LOADED == loadState) {
                    return true;
                }
                if (LoadState.NOT_LOADED != loadState) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isLoaded(Object entity) {
            for (PersistenceProvider persistenceProvider : PersistenceUtilImpl.getPersistenceProviders()) {
                ProviderUtil providerUtil = null;
                try {
                    providerUtil = persistenceProvider.getProviderUtil();
                }
                catch (IncompatibleClassChangeError ame) {
                    continue;
                }
                LoadState loadState = providerUtil.isLoaded(entity);
                if (LoadState.LOADED == loadState) {
                    return true;
                }
                if (LoadState.NOT_LOADED != loadState) continue;
                return false;
            }
            return true;
        }
    }
}

