/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.timer;

import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.timer.TimerEventListener;
import org.ow2.jonas.lib.timer.TraceTimer;

public class TimerEvent {
    private TimerEventListener listener = null;
    private Object arg = null;
    private long remaining;
    private long startvalue;
    private long createtime;
    private boolean permanent = false;
    private boolean stopped = false;

    public TimerEvent(TimerEventListener l, long timeout, Object a, boolean p) {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("listener = " + l + ",timeout = " + timeout + " ,object = " + a + " ,permanent = " + p + ")"));
        }
        this.listener = l;
        this.remaining = timeout;
        this.startvalue = timeout;
        this.createtime = System.currentTimeMillis();
        this.arg = a;
        this.permanent = p;
    }

    public long update() {
        this.remaining = this.startvalue + this.createtime - System.currentTimeMillis();
        if (TraceTimer.isDebug() && this.remaining <= 10L) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("listener = " + this.listener + " remaining = " + this.remaining));
        }
        return this.remaining;
    }

    public long restart() {
        this.stopped = false;
        this.createtime = System.currentTimeMillis() + this.remaining;
        this.remaining += this.startvalue;
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("listener = " + this.listener + " remaining = " + this.remaining));
        }
        return this.remaining;
    }

    public void process() {
        if (this.listener != null) {
            if (TraceTimer.isDebug()) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("listener = " + this.listener + " remaining = " + this.remaining));
            }
            this.listener.timeoutExpired(this.arg);
        }
    }

    public void change(long timeout, Object a) {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("listener = " + this.listener + " timeout = " + timeout + ",object = " + a));
        }
        this.stopped = false;
        this.remaining = this.startvalue = timeout;
        this.arg = a;
    }

    public void unset() {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("listener = " + this.listener));
        }
        this.remaining = 100L;
        this.arg = null;
        this.listener = null;
        this.permanent = false;
        this.stopped = false;
    }

    public void stop() {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("listener = " + this.listener));
        }
        this.remaining = 1000000L;
        this.stopped = true;
    }

    public boolean valid() {
        return this.listener != null;
    }

    public boolean ispermanent() {
        return this.permanent;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public long getRemaining() {
        return this.remaining;
    }
}

