/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployable;

import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.ow2.jonas.addon.deploy.api.deployable.ISortableDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;

public class SortableDeployableComparator
implements Serializable,
Comparator<ISortableDeployable> {
    private static Log logger = LogFactory.getLog(SortableDeployableComparator.class);

    @Override
    public int compare(ISortableDeployable sortableDeployable1, ISortableDeployable sortableDeployable2) {
        if (sortableDeployable1.getPriority() > sortableDeployable2.getPriority()) {
            return 1;
        }
        if (sortableDeployable1.getPriority() < sortableDeployable2.getPriority()) {
            return -1;
        }
        IDeployable deployable1 = sortableDeployable1.getDeployable();
        IDeployable deployable2 = sortableDeployable2.getDeployable();
        if (deployable1 instanceof DeploymentPlanDeployable && deployable2 instanceof DeploymentPlanDeployable) {
            Pattern pattern = Pattern.compile(".*-base.xml");
            Boolean isAbstractDeploymentPlan1 = pattern.matcher(deployable1.getShortName()).matches();
            Boolean isAbstractDeploymentPlan2 = pattern.matcher(deployable2.getShortName()).matches();
            if (isAbstractDeploymentPlan1.booleanValue() && !isAbstractDeploymentPlan2.booleanValue()) {
                return -1;
            }
            if (!isAbstractDeploymentPlan1.booleanValue() && isAbstractDeploymentPlan2.booleanValue()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }
}

