/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.jonas.addon.deploy.impl.xml.JonasAddonPropertiesManager;
import org.ow2.jonas.addon.deploy.impl.xml.JonasAddonVersion;
import org.ow2.jonas.addon.deploy.jonasaddon.v1.generated.JonasAddonType;

public class JonasAddonXmlLoader {
    Object jonasAddon;

    public JonasAddonXmlLoader() {
    }

    public JonasAddonXmlLoader(URL cloudApplicationURL, JonasAddonVersion jonasAddonVersion, List<URL> xsdURLs) throws Exception {
        this.jonasAddon = this.loadSchemaAndFile(xsdURLs, JonasAddonPropertiesManager.getCloudApplicationXMLNS(jonasAddonVersion), JonasAddonPropertiesManager.getCloudApplicationSchemaLocation(jonasAddonVersion), "jonas-addon", this.getRootClass(jonasAddonVersion), cloudApplicationURL);
    }

    public JonasAddonXmlLoader(String xml, JonasAddonVersion jonasAddonVersion, List<URL> xsdURLs) throws Exception {
        this.jonasAddon = this.loadSchemaAndFile(xsdURLs, JonasAddonPropertiesManager.getCloudApplicationXMLNS(jonasAddonVersion), JonasAddonPropertiesManager.getCloudApplicationSchemaLocation(jonasAddonVersion), "jonas-addon", this.getRootClass(jonasAddonVersion), xml);
    }

    private Class getRootClass(JonasAddonVersion jonasAddonVersion) {
        if (JonasAddonVersion.JONAS_ADDON_1.equals((Object)jonasAddonVersion)) {
            return JonasAddonType.class;
        }
        return null;
    }

    public Object getJonasAddon() {
        return this.jonasAddon;
    }

    public <T> T loadSchemaAndFile(List<URL> xsdPaths, String xmlns, String schemaLocation, String xmlRoot, Class<T> rootClass, URL urlXML) throws Exception {
        String xml = JonasAddonXmlLoader.readURL(urlXML);
        return this.loadSchemaAndFile(xsdPaths, xmlns, schemaLocation, xmlRoot, rootClass, xml);
    }

    public <T> T loadSchemaAndFile(List<URL> xsdPaths, String xmlns, String schemaLocation, String xmlRoot, Class<T> rootClass, String xml) throws Exception {
        int xmlnsIndex;
        int xmlRootEnd;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{rootClass});
        Unmarshaller unMarshaller = jc.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        List<Source> xsdSources = this.getSources(xsdPaths);
        Schema schema = schemaFactory.newSchema(xsdSources.toArray(new Source[xsdSources.size()]));
        unMarshaller.setSchema(schema);
        int xmlRootStart = xml.indexOf("<" + xmlRoot);
        if (xmlRootStart != -1 && (xmlRootEnd = xml.indexOf(">", xmlRootStart)) != -1 && (xmlnsIndex = xml.indexOf("xmlns", xmlRootStart)) == -1) {
            xml = xml.substring(0, xmlRootStart) + "<" + xmlRoot + " xmlns=\"" + xmlns + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"" + xmlns + " " + schemaLocation + "\"" + xml.substring(xmlRootStart + xmlRoot.length() + 1);
        }
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xml.getBytes());
        JAXBElement root = unMarshaller.unmarshal((Source)new StreamSource(xmlInputStream), rootClass);
        Object value = root.getValue();
        return (T)value;
    }

    public String toXml(JAXBElement<?> jaxbElement, List<URL> xsdURLs, JonasAddonVersion jonasAddonVersion) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.getRootClass(jonasAddonVersion)});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        List<Source> xsdSources = this.getSources(xsdURLs);
        Schema schema = schemaFactory.newSchema(xsdSources.toArray(new Source[xsdSources.size()]));
        marshaller.setSchema(schema);
        StringWriter sw = new StringWriter();
        marshaller.marshal(jaxbElement, (Writer)sw);
        return sw.toString();
    }

    public void toXml(JAXBElement<?> jaxbElement, List<URL> xsdURLs, JonasAddonVersion jonasAddonVersion, ZipOutputStream zipOutputStream) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.getRootClass(jonasAddonVersion)});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        List<Source> xsdSources = this.getSources(xsdURLs);
        Schema schema = schemaFactory.newSchema(xsdSources.toArray(new Source[xsdSources.size()]));
        marshaller.setSchema(schema);
        marshaller.marshal(jaxbElement, (OutputStream)zipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readURL(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String inputLine;
            StringBuilder sb = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(inputLine);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    protected List<Source> getSources(List<URL> urls) throws Exception {
        ArrayList<Source> sources = new ArrayList<Source>();
        for (URL url : urls) {
            Source source = this.getSource(url);
            if (source == null) continue;
            sources.add(source);
        }
        return sources;
    }

    protected Source getSource(URL url) throws Exception {
        if (url != null) {
            InputStream inputStream = null;
            try {
                inputStream = url.openStream();
            }
            catch (IOException e) {
                throw new Exception("Cannot get the inpustream of the URL " + url.getPath() + "\n");
            }
            try {
                return new StreamSource(inputStream);
            }
            catch (Exception e) {
                throw new Exception("Cannot create a new StreamSource for the URL : " + url.getPath() + "\n", e);
            }
        }
        return null;
    }
}

