/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.report.extensions.ipojo.factories.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.report.api.IReportExtension;
import org.ow2.jonas.report.extensions.ipojo.factories.generated.IpojoFactories;
import org.ow2.jonas.report.extensions.ipojo.factories.generated.IpojoFactoryType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class IpojoFactoriesReportExtension
implements IReportExtension,
Pojo {
    private InstanceManager __IM;
    public static final Log logger = LogFactory.getLog(IpojoFactoriesReportExtension.class);
    public static final String XSD_PATH = "xsd/ipojo-factories-report.xsd";
    private boolean __Ffactories;
    private List<Factory> factories;
    private boolean __MgenerateReport;
    private boolean __MgetXsd;
    private boolean __MgetRootClass;
    private boolean __MbindFactory$org_apache_felix_ipojo_Factory;
    private boolean __MunbindFactory$org_apache_felix_ipojo_Factory;

    List __getfactories() {
        if (!this.__Ffactories) {
            return this.factories;
        }
        return (List)this.__IM.onGet((Object)this, "factories");
    }

    void __setfactories(List list) {
        if (!this.__Ffactories) {
            this.factories = list;
            return;
        }
        this.__IM.onSet((Object)this, "factories", (Object)list);
    }

    public IpojoFactoriesReportExtension() {
        this(null);
    }

    private IpojoFactoriesReportExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setfactories(new ArrayList());
    }

    public Object generateReport() {
        Object object;
        if (!this.__MgenerateReport) {
            return this.__M_generateReport();
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport", new Object[0]);
            object = this.__M_generateReport();
            this.__IM.onExit((Object)this, "generateReport", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_generateReport() {
        IpojoFactories ipojoFactories = new IpojoFactories();
        List<IpojoFactoryType> factoryTypeList = ipojoFactories.getIpojoFactory();
        for (Factory factory : this.__getfactories()) {
            IpojoFactoryType factoryType = new IpojoFactoryType();
            factoryType.setName(factory.getName());
            factoryType.setBundleId(factory.getBundleContext().getBundle().getBundleId());
            int state = factory.getState();
            if (1 == state) {
                factoryType.setState("VALID");
            } else {
                factoryType.setState("INVALID");
                factoryType.setArch(factory.getDescription().toString());
            }
            factoryTypeList.add(factoryType);
        }
        return ipojoFactories;
    }

    public Source getXsd() {
        Source source;
        if (!this.__MgetXsd) {
            return this.__M_getXsd();
        }
        try {
            this.__IM.onEntry((Object)this, "getXsd", new Object[0]);
            source = this.__M_getXsd();
            this.__IM.onExit((Object)this, "getXsd", (Object)source);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXsd", throwable);
            throw throwable;
        }
        return source;
    }

    private Source __M_getXsd() {
        InputStream xsd = this.getRootClass().getClassLoader().getResourceAsStream(XSD_PATH);
        StreamSource source = null;
        if (xsd != null) {
            source = new StreamSource(xsd);
        } else {
            logger.error((Object)"Cannot find XSD xsd/ipojo-factories-report.xsd", new Object[0]);
        }
        return source;
    }

    public Class getRootClass() {
        Class clazz;
        if (!this.__MgetRootClass) {
            return this.__M_getRootClass();
        }
        try {
            this.__IM.onEntry((Object)this, "getRootClass", new Object[0]);
            clazz = this.__M_getRootClass();
            this.__IM.onExit((Object)this, "getRootClass", (Object)clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRootClass", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class __M_getRootClass() {
        return IpojoFactories.class;
    }

    public void bindFactory(Factory factory) {
        if (!this.__MbindFactory$org_apache_felix_ipojo_Factory) {
            this.__M_bindFactory(factory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", new Object[]{factory});
            this.__M_bindFactory(factory);
            this.__IM.onExit((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", throwable);
            throw throwable;
        }
    }

    private void __M_bindFactory(Factory factory) {
        this.__getfactories().add(factory);
    }

    public void unbindFactory(Factory factory) {
        if (!this.__MunbindFactory$org_apache_felix_ipojo_Factory) {
            this.__M_unbindFactory(factory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", new Object[]{factory});
            this.__M_unbindFactory(factory);
            this.__IM.onExit((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", throwable);
            throw throwable;
        }
    }

    private void __M_unbindFactory(Factory factory) {
        this.__getfactories().remove(factory);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("factories")) {
            this.__Ffactories = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("generateReport")) {
                this.__MgenerateReport = true;
            }
            if (set.contains("getXsd")) {
                this.__MgetXsd = true;
            }
            if (set.contains("getRootClass")) {
                this.__MgetRootClass = true;
            }
            if (set.contains("bindFactory$org_apache_felix_ipojo_Factory")) {
                this.__MbindFactory$org_apache_felix_ipojo_Factory = true;
            }
            if (set.contains("unbindFactory$org_apache_felix_ipojo_Factory")) {
                this.__MunbindFactory$org_apache_felix_ipojo_Factory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

