/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resourcemonitor.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.resourcemonitor.ResourceMonitorService;
import org.ow2.jonas.resourcemonitor.internal.JOnASResourceMonitorServiceMBean;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.Deployment;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.plan.deployer.api.FragmentUndeploymentException;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.monitor.api.IResourceMonitor;

public class JOnASResourceMonitorService
extends AbsServiceImpl
implements ResourceMonitorService,
JOnASResourceMonitorServiceMBean,
Pojo {
    private InstanceManager __IM;
    private static final long DEFAULT_MONITOR_TIME_INTERVAL = 60000L;
    private boolean __Flogger;
    private Log logger;
    private boolean __FresourceMonitor;
    private IResourceMonitor resourceMonitor;
    private boolean __FmonitorInterval;
    private Long monitorInterval;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __FdeploymentPlanDeployer;
    private IDeploymentPlanDeployer deploymentPlanDeployer;
    private boolean __FmonitoringThread;
    private MonitoringThread monitoringThread;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MgetMonitoredResourcesCount;
    private boolean __MgetMonitoredResourcesDescriptions;
    private boolean __MgetMonitoringInterval;
    private boolean __MsetMonitoringInterval$java_lang_Long;
    private boolean __MsetResourceMonitor$org_ow2_util_plan_monitor_api_IResourceMonitor;
    private boolean __MgetResourceMonitor;
    private boolean __MgetJmxService;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsetDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer;
    private boolean __MgetDeploymentPlanDeployer;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    IResourceMonitor __getresourceMonitor() {
        if (!this.__FresourceMonitor) {
            return this.resourceMonitor;
        }
        return (IResourceMonitor)this.__IM.onGet((Object)this, "resourceMonitor");
    }

    void __setresourceMonitor(IResourceMonitor iResourceMonitor) {
        if (!this.__FresourceMonitor) {
            this.resourceMonitor = iResourceMonitor;
            return;
        }
        this.__IM.onSet((Object)this, "resourceMonitor", (Object)iResourceMonitor);
    }

    Long __getmonitorInterval() {
        if (!this.__FmonitorInterval) {
            return this.monitorInterval;
        }
        return (Long)this.__IM.onGet((Object)this, "monitorInterval");
    }

    void __setmonitorInterval(Long l) {
        if (!this.__FmonitorInterval) {
            this.monitorInterval = l;
            return;
        }
        this.__IM.onSet((Object)this, "monitorInterval", (Object)l);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    IDeploymentPlanDeployer __getdeploymentPlanDeployer() {
        if (!this.__FdeploymentPlanDeployer) {
            return this.deploymentPlanDeployer;
        }
        return (IDeploymentPlanDeployer)this.__IM.onGet((Object)this, "deploymentPlanDeployer");
    }

    void __setdeploymentPlanDeployer(IDeploymentPlanDeployer iDeploymentPlanDeployer) {
        if (!this.__FdeploymentPlanDeployer) {
            this.deploymentPlanDeployer = iDeploymentPlanDeployer;
            return;
        }
        this.__IM.onSet((Object)this, "deploymentPlanDeployer", (Object)iDeploymentPlanDeployer);
    }

    MonitoringThread __getmonitoringThread() {
        if (!this.__FmonitoringThread) {
            return this.monitoringThread;
        }
        return (MonitoringThread)this.__IM.onGet((Object)this, "monitoringThread");
    }

    void __setmonitoringThread(MonitoringThread monitoringThread) {
        if (!this.__FmonitoringThread) {
            this.monitoringThread = monitoringThread;
            return;
        }
        this.__IM.onSet((Object)this, "monitoringThread", (Object)monitoringThread);
    }

    public JOnASResourceMonitorService() {
        this(null);
    }

    private JOnASResourceMonitorService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(JOnASResourceMonitorService.class));
        this.__setresourceMonitor(null);
        this.__setmonitorInterval(null);
        this.__setjmxService(null);
        this.__setdeploymentPlanDeployer(null);
        this.__setmonitoringThread(new MonitoringThread());
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        try {
            ObjectName objectName = JonasObjectName.resourceMonitor((String)this.getDomainName());
            this.__getjmxService().registerMBean((Object)this, objectName);
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"JMX registration error, {0}", new Object[]{e});
            throw new ServiceException("JMX registration error", (Throwable)e);
        }
        if (this.__getmonitorInterval() == null) {
            this.__setmonitorInterval(60000L);
        }
        this.__getmonitoringThread().start();
        this.__getlogger().info((Object)"Resource Monitor Service Started", new Object[0]);
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        this.__getmonitoringThread().isStopping = true;
        if (this.__getjmxService() != null) {
            try {
                ObjectName objectName = JonasObjectName.resourceMonitor((String)this.getDomainName());
                this.__getjmxService().unregisterMBean(objectName);
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"JMX registration error, {0}", new Object[]{e});
                throw new ServiceException("JMX registration error", (Throwable)e);
            }
        }
        this.__getlogger().info((Object)"Resource Monitor Service Stopped", new Object[0]);
    }

    @Override
    public Integer getMonitoredResourcesCount() {
        Integer n;
        if (!this.__MgetMonitoredResourcesCount) {
            return this.__M_getMonitoredResourcesCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getMonitoredResourcesCount", new Object[0]);
            n = this.__M_getMonitoredResourcesCount();
            this.__IM.onExit((Object)this, "getMonitoredResourcesCount", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMonitoredResourcesCount", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __M_getMonitoredResourcesCount() {
        return this.__getresourceMonitor().getMonitoredResourcesCount();
    }

    @Override
    public List<String> getMonitoredResourcesDescriptions() {
        List<String> list;
        if (!this.__MgetMonitoredResourcesDescriptions) {
            return this.__M_getMonitoredResourcesDescriptions();
        }
        try {
            this.__IM.onEntry((Object)this, "getMonitoredResourcesDescriptions", new Object[0]);
            list = this.__M_getMonitoredResourcesDescriptions();
            this.__IM.onExit((Object)this, "getMonitoredResourcesDescriptions", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMonitoredResourcesDescriptions", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getMonitoredResourcesDescriptions() {
        return this.__getresourceMonitor().getMonitoredResourcesDescriptions();
    }

    @Override
    public Long getMonitoringInterval() {
        Long l;
        if (!this.__MgetMonitoringInterval) {
            return this.__M_getMonitoringInterval();
        }
        try {
            this.__IM.onEntry((Object)this, "getMonitoringInterval", new Object[0]);
            l = this.__M_getMonitoringInterval();
            this.__IM.onExit((Object)this, "getMonitoringInterval", (Object)l);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMonitoringInterval", throwable);
            throw throwable;
        }
        return l;
    }

    private Long __M_getMonitoringInterval() {
        return this.__getmonitorInterval();
    }

    @Override
    public void setMonitoringInterval(Long interval) {
        if (!this.__MsetMonitoringInterval$java_lang_Long) {
            this.__M_setMonitoringInterval(interval);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMonitoringInterval$java_lang_Long", new Object[]{interval});
            this.__M_setMonitoringInterval(interval);
            this.__IM.onExit((Object)this, "setMonitoringInterval$java_lang_Long", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMonitoringInterval$java_lang_Long", throwable);
            throw throwable;
        }
    }

    private void __M_setMonitoringInterval(Long interval) {
        this.__getlogger().debug((Object)"Monitoring interval set to {0}", new Object[]{interval});
        this.__setmonitorInterval(interval);
    }

    public void setResourceMonitor(IResourceMonitor resourceMonitor) {
        if (!this.__MsetResourceMonitor$org_ow2_util_plan_monitor_api_IResourceMonitor) {
            this.__M_setResourceMonitor(resourceMonitor);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setResourceMonitor$org_ow2_util_plan_monitor_api_IResourceMonitor", new Object[]{resourceMonitor});
            this.__M_setResourceMonitor(resourceMonitor);
            this.__IM.onExit((Object)this, "setResourceMonitor$org_ow2_util_plan_monitor_api_IResourceMonitor", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setResourceMonitor$org_ow2_util_plan_monitor_api_IResourceMonitor", throwable);
            throw throwable;
        }
    }

    private void __M_setResourceMonitor(IResourceMonitor resourceMonitor) {
        this.__setresourceMonitor(resourceMonitor);
    }

    public IResourceMonitor getResourceMonitor() {
        IResourceMonitor iResourceMonitor;
        if (!this.__MgetResourceMonitor) {
            return this.__M_getResourceMonitor();
        }
        try {
            this.__IM.onEntry((Object)this, "getResourceMonitor", new Object[0]);
            iResourceMonitor = this.__M_getResourceMonitor();
            this.__IM.onExit((Object)this, "getResourceMonitor", (Object)iResourceMonitor);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getResourceMonitor", throwable);
            throw throwable;
        }
        return iResourceMonitor;
    }

    private IResourceMonitor __M_getResourceMonitor() {
        return this.__getresourceMonitor();
    }

    public JmxService getJmxService() {
        JmxService jmxService;
        if (!this.__MgetJmxService) {
            return this.__M_getJmxService();
        }
        try {
            this.__IM.onEntry((Object)this, "getJmxService", new Object[0]);
            jmxService = this.__M_getJmxService();
            this.__IM.onExit((Object)this, "getJmxService", (Object)jmxService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmxService", throwable);
            throw throwable;
        }
        return jmxService;
    }

    private JmxService __M_getJmxService() {
        return this.__getjmxService();
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void setDeploymentPlanDeployer(IDeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__MsetDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer) {
            this.__M_setDeploymentPlanDeployer(deploymentPlanDeployer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer", new Object[]{deploymentPlanDeployer});
            this.__M_setDeploymentPlanDeployer(deploymentPlanDeployer);
            this.__IM.onExit((Object)this, "setDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer", throwable);
            throw throwable;
        }
    }

    private void __M_setDeploymentPlanDeployer(IDeploymentPlanDeployer deploymentPlanDeployer) {
        this.__setdeploymentPlanDeployer(deploymentPlanDeployer);
    }

    public IDeploymentPlanDeployer getDeploymentPlanDeployer() {
        IDeploymentPlanDeployer iDeploymentPlanDeployer;
        if (!this.__MgetDeploymentPlanDeployer) {
            return this.__M_getDeploymentPlanDeployer();
        }
        try {
            this.__IM.onEntry((Object)this, "getDeploymentPlanDeployer", new Object[0]);
            iDeploymentPlanDeployer = this.__M_getDeploymentPlanDeployer();
            this.__IM.onExit((Object)this, "getDeploymentPlanDeployer", (Object)iDeploymentPlanDeployer);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeploymentPlanDeployer", throwable);
            throw throwable;
        }
        return iDeploymentPlanDeployer;
    }

    private IDeploymentPlanDeployer __M_getDeploymentPlanDeployer() {
        return this.__getdeploymentPlanDeployer();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("deploymentPlanDeployer")) {
                this.__FdeploymentPlanDeployer = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("monitorInterval")) {
                this.__FmonitorInterval = true;
            }
            if (set.contains("monitoringThread")) {
                this.__FmonitoringThread = true;
            }
            if (set.contains("resourceMonitor")) {
                this.__FresourceMonitor = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("getMonitoredResourcesCount")) {
                this.__MgetMonitoredResourcesCount = true;
            }
            if (set.contains("getMonitoredResourcesDescriptions")) {
                this.__MgetMonitoredResourcesDescriptions = true;
            }
            if (set.contains("getMonitoringInterval")) {
                this.__MgetMonitoringInterval = true;
            }
            if (set.contains("setMonitoringInterval$java_lang_Long")) {
                this.__MsetMonitoringInterval$java_lang_Long = true;
            }
            if (set.contains("setResourceMonitor$org_ow2_util_plan_monitor_api_IResourceMonitor")) {
                this.__MsetResourceMonitor$org_ow2_util_plan_monitor_api_IResourceMonitor = true;
            }
            if (set.contains("getResourceMonitor")) {
                this.__MgetResourceMonitor = true;
            }
            if (set.contains("getJmxService")) {
                this.__MgetJmxService = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer")) {
                this.__MsetDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer = true;
            }
            if (set.contains("getDeploymentPlanDeployer")) {
                this.__MgetDeploymentPlanDeployer = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class MonitoringThread
    extends Thread {
        boolean isStopping = false;

        private MonitoringThread() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(JOnASResourceMonitorService.this.__getmonitorInterval());
                }
                catch (InterruptedException e) {
                    JOnASResourceMonitorService.this.__getlogger().warn((Object)"Sleep interrupted", new Object[0]);
                }
                if (this.isStopping) {
                    return;
                }
                Iterator i$ = JOnASResourceMonitorService.this.__getresourceMonitor().getChangedResources().iterator();
                do {
                    if (!i$.hasNext()) continue block2;
                    IResourceFetcher resourceFetcher = (IResourceFetcher)i$.next();
                    this.processResource(resourceFetcher);
                } while (!this.isStopping);
                break;
            }
        }

        private void processResource(IResourceFetcher resourceFetcher) {
            try {
                JOnASResourceMonitorService.this.__getdeploymentPlanDeployer().undeployDeployment((Deployment)resourceFetcher.getDeployment());
            }
            catch (FragmentUndeploymentException e) {
                JOnASResourceMonitorService.this.__getlogger().error((Object)"Exception while trying to redeploy deployment {0} (during undeployment) - trying to go on.", new Object[]{resourceFetcher.getDeployment()});
            }
            try {
                JOnASResourceMonitorService.this.__getdeploymentPlanDeployer().deployDeployment((Deployment)resourceFetcher.getDeployment());
                JOnASResourceMonitorService.this.__getlogger().debug((Object)"Resource {0} changed and was redeployed", new Object[]{resourceFetcher.getDeployment()});
            }
            catch (Exception e) {
                JOnASResourceMonitorService.this.__getlogger().error((Object)"Exception while trying to redeploy deployment {0} (during deployment) - aborting", new Object[]{resourceFetcher.getDeployment()});
                DeploymentPlanDeployable deploymentPlanDeployable = JOnASResourceMonitorService.this.__getdeploymentPlanDeployer().getOwnerDeploymentPlanDeployable((Deployment)resourceFetcher.getDeployment());
                if (deploymentPlanDeployable == null) {
                    JOnASResourceMonitorService.this.__getlogger().error((Object)"Could not find which deployment plan owns the deployment {0} - stopping undeployment", new Object[]{resourceFetcher.getDeployment()});
                }
                try {
                    JOnASResourceMonitorService.this.__getdeploymentPlanDeployer().undeploy((IDeployable)deploymentPlanDeployable);
                }
                catch (DeployerException deployerException) {
                    JOnASResourceMonitorService.this.__getlogger().error((Object)"Could not undeploy deployment plan {0}", new Object[]{deploymentPlanDeployable});
                }
            }
        }
    }
}

