/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPlugin;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.properties.ServiceProperties;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOnASConfiguration
implements ConfigurationManager,
ConfigurationPlugin,
Pojo {
    private InstanceManager __IM;
    private boolean __FconfigurationAdmin;
    private ConfigurationAdmin configurationAdmin;
    private static final String JONAS_SERVICE = "jonas.service";
    private boolean __Fbc;
    private BundleContext bc;
    private boolean __FmandatoryServices;
    private List<String> mandatoryServices;
    private boolean __Flogger;
    private Log logger;
    private boolean __FserverProperties;
    private JProp serverProperties;
    private boolean __FlastModified;
    private long lastModified;
    private boolean __FservicePropertiesList;
    private List<ServiceProperties> servicePropertiesList;
    private boolean __Mconfigure;
    private boolean __MhaltServer;
    private boolean __MupdateServiceConfiguration$java_lang_String;
    private boolean __MdeleteServiceConfiguration$java_lang_String;
    private boolean __MmatchService$java_lang_String;
    private boolean __MmanageServiceConfigurations$java_util_List$boolean;
    private boolean __MgetMandatoryServices;
    private boolean __MgetAllServices;
    private boolean __MgetOptionalServices;
    private boolean __MgetDeclaredServices;
    private boolean __MgetServiceProperties$java_lang_String;
    private boolean __MgetServicesProperties$java_util_Properties$java_lang_String;
    private boolean __MgetConfiguration$java_lang_String;
    private boolean __MgetFactoryPID$java_lang_String;
    private boolean __MmodifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary;
    private boolean __MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin;
    private boolean __MisConfigurationModified$java_util_Dictionary$java_util_Dictionary;
    private boolean __MdeleteServiceConfigurations;
    private boolean __MgetServerProperties;
    private boolean __MremoveDuplicateServices$java_util_List;
    private boolean __MaddServiceProperties$org_ow2_jonas_properties_ServiceProperties;
    private boolean __MremoveServiceProperties$org_ow2_jonas_properties_ServiceProperties;

    ConfigurationAdmin __getconfigurationAdmin() {
        if (!this.__FconfigurationAdmin) {
            return this.configurationAdmin;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "configurationAdmin");
    }

    void __setconfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__FconfigurationAdmin) {
            this.configurationAdmin = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "configurationAdmin", (Object)configurationAdmin);
    }

    BundleContext __getbc() {
        if (!this.__Fbc) {
            return this.bc;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bc");
    }

    void __setbc(BundleContext bundleContext) {
        if (!this.__Fbc) {
            this.bc = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bc", (Object)bundleContext);
    }

    List __getmandatoryServices() {
        if (!this.__FmandatoryServices) {
            return this.mandatoryServices;
        }
        return (List)this.__IM.onGet((Object)this, "mandatoryServices");
    }

    void __setmandatoryServices(List list) {
        if (!this.__FmandatoryServices) {
            this.mandatoryServices = list;
            return;
        }
        this.__IM.onSet((Object)this, "mandatoryServices", (Object)list);
    }

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    JProp __getserverProperties() {
        if (!this.__FserverProperties) {
            return this.serverProperties;
        }
        return (JProp)this.__IM.onGet((Object)this, "serverProperties");
    }

    void __setserverProperties(JProp jProp) {
        if (!this.__FserverProperties) {
            this.serverProperties = jProp;
            return;
        }
        this.__IM.onSet((Object)this, "serverProperties", (Object)jProp);
    }

    long __getlastModified() {
        if (!this.__FlastModified) {
            return this.lastModified;
        }
        Object object = this.__IM.onGet((Object)this, "lastModified");
        Long l = (Long)object;
        return l;
    }

    void __setlastModified(long l) {
        if (!this.__FlastModified) {
            this.lastModified = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "lastModified", (Object)l2);
    }

    List __getservicePropertiesList() {
        if (!this.__FservicePropertiesList) {
            return this.servicePropertiesList;
        }
        return (List)this.__IM.onGet((Object)this, "servicePropertiesList");
    }

    void __setservicePropertiesList(List list) {
        if (!this.__FservicePropertiesList) {
            this.servicePropertiesList = list;
            return;
        }
        this.__IM.onSet((Object)this, "servicePropertiesList", (Object)list);
    }

    public JOnASConfiguration(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private JOnASConfiguration(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setconfigurationAdmin(null);
        this.__setbc(null);
        this.__setmandatoryServices(null);
        this.__setlogger(LogFactory.getLog(JOnASConfiguration.class));
        this.__setserverProperties(null);
        this.__setbc(bc);
        this.__setmandatoryServices(new ArrayList());
        this.__getmandatoryServices().add("registry");
        this.__getmandatoryServices().add("security");
        this.__getmandatoryServices().add("jmx");
        if (this.getDeclaredServices().contains("discovery")) {
            this.__getmandatoryServices().add("discovery");
        }
        this.__setservicePropertiesList(new ArrayList());
    }

    public void configure() throws Exception {
        if (!this.__Mconfigure) {
            this.__M_configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__M_configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    private void __M_configure() throws Exception {
        this.deleteServiceConfigurations();
        this.manageServiceConfigurations(this.__getmandatoryServices(), false);
        ServiceReference sr = this.__getbc().getServiceReference(ServerProperties.class.getName());
        if (sr == null) {
            this.__getbc().registerService(ServerProperties.class.getName(), (Object)this.getServerProperties(), null);
        }
    }

    public void haltServer() throws Exception {
        if (!this.__MhaltServer) {
            this.__M_haltServer();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "haltServer", new Object[0]);
            this.__M_haltServer();
            this.__IM.onExit((Object)this, "haltServer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "haltServer", throwable);
            throw throwable;
        }
    }

    private void __M_haltServer() throws Exception {
        this.__getbc().getBundle(0L).stop();
    }

    public synchronized void updateServiceConfiguration(String service) throws Exception {
        if (!this.__MupdateServiceConfiguration$java_lang_String) {
            this.__M_updateServiceConfiguration(service);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateServiceConfiguration$java_lang_String", new Object[]{service});
            this.__M_updateServiceConfiguration(service);
            this.__IM.onExit((Object)this, "updateServiceConfiguration$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateServiceConfiguration$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_updateServiceConfiguration(String service) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        services.add(service);
        this.manageServiceConfigurations(services, false);
    }

    public synchronized void deleteServiceConfiguration(String service) throws Exception {
        if (!this.__MdeleteServiceConfiguration$java_lang_String) {
            this.__M_deleteServiceConfiguration(service);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteServiceConfiguration$java_lang_String", new Object[]{service});
            this.__M_deleteServiceConfiguration(service);
            this.__IM.onExit((Object)this, "deleteServiceConfiguration$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteServiceConfiguration$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_deleteServiceConfiguration(String service) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        services.add(service);
        this.manageServiceConfigurations(services, true);
    }

    public boolean matchService(String service) {
        boolean bl;
        if (!this.__MmatchService$java_lang_String) {
            return this.__M_matchService(service);
        }
        try {
            this.__IM.onEntry((Object)this, "matchService$java_lang_String", new Object[]{service});
            bl = this.__M_matchService(service);
            this.__IM.onExit((Object)this, "matchService$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "matchService$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_matchService(String service) {
        String factoryPID = this.getFactoryPID(service);
        return factoryPID != null;
    }

    private void manageServiceConfigurations(List<String> services, boolean delete) throws Exception {
        if (!this.__MmanageServiceConfigurations$java_util_List$boolean) {
            this.__M_manageServiceConfigurations(services, delete);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "manageServiceConfigurations$java_util_List$boolean", new Object[]{services, new Boolean(delete)});
            this.__M_manageServiceConfigurations(services, delete);
            this.__IM.onExit((Object)this, "manageServiceConfigurations$java_util_List$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "manageServiceConfigurations$java_util_List$boolean", throwable);
            throw throwable;
        }
    }

    private void __M_manageServiceConfigurations(List<String> services, boolean delete) throws Exception {
        for (String service : this.removeDuplicateServices(services)) {
            Dictionary newProperties = null;
            if (!delete) {
                newProperties = this.getServiceProperties(service);
            }
            Configuration configuration = this.getConfiguration(service);
            if (!delete && configuration == null) {
                configuration = this.__getconfigurationAdmin().createFactoryConfiguration(this.getFactoryPID(service), null);
                configuration.update(newProperties);
                continue;
            }
            if (configuration == null) continue;
            configuration = this.__getconfigurationAdmin().getConfiguration(configuration.getPid(), null);
            if (delete) {
                configuration.delete();
                continue;
            }
            Dictionary storedProperties = configuration.getProperties();
            if (!this.isConfigurationModified(storedProperties, newProperties)) continue;
            configuration.update(newProperties);
        }
    }

    public List<String> getMandatoryServices() {
        List<String> list;
        if (!this.__MgetMandatoryServices) {
            return this.__M_getMandatoryServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getMandatoryServices", new Object[0]);
            list = this.__M_getMandatoryServices();
            this.__IM.onExit((Object)this, "getMandatoryServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMandatoryServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getMandatoryServices() {
        return this.__getmandatoryServices();
    }

    public List<String> getAllServices() {
        List<String> list;
        if (!this.__MgetAllServices) {
            return this.__M_getAllServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getAllServices", new Object[0]);
            list = this.__M_getAllServices();
            this.__IM.onExit((Object)this, "getAllServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getAllServices() {
        List<String> allServices = this.getOptionalServices();
        for (int i = 0; i < this.__getmandatoryServices().size(); ++i) {
            allServices.add(i, (String)this.__getmandatoryServices().get(i));
        }
        return allServices;
    }

    public List<String> getOptionalServices() {
        List<String> list;
        if (!this.__MgetOptionalServices) {
            return this.__M_getOptionalServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getOptionalServices", new Object[0]);
            list = this.__M_getOptionalServices();
            this.__IM.onExit((Object)this, "getOptionalServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOptionalServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getOptionalServices() {
        ArrayList<String> optionalServices = new ArrayList<String>();
        for (String declaredService : this.getDeclaredServices()) {
            if (this.__getmandatoryServices().contains(declaredService) || !declaredService.equals("depmonitor") && !declaredService.equals("wm") && !declaredService.equals("wc")) continue;
            optionalServices.add(declaredService);
        }
        return optionalServices;
    }

    private List<String> getDeclaredServices() {
        List<String> list;
        if (!this.__MgetDeclaredServices) {
            return this.__M_getDeclaredServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getDeclaredServices", new Object[0]);
            list = this.__M_getDeclaredServices();
            this.__IM.onExit((Object)this, "getDeclaredServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeclaredServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getDeclaredServices() {
        String[] declaredServices = this.getServerProperties().getValueAsArray("jonas.services");
        return Arrays.asList(declaredServices);
    }

    public Dictionary getServiceProperties(String service) {
        Dictionary dictionary;
        if (!this.__MgetServiceProperties$java_lang_String) {
            return this.__M_getServiceProperties(service);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceProperties$java_lang_String", new Object[]{service});
            dictionary = this.__M_getServiceProperties(service);
            this.__IM.onExit((Object)this, "getServiceProperties$java_lang_String", (Object)dictionary);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceProperties$java_lang_String", throwable);
            throw throwable;
        }
        return dictionary;
    }

    private Dictionary __M_getServiceProperties(String service) {
        JProp serverProperties = this.getServerProperties();
        Dictionary<String, String> props = this.getServicesProperties(serverProperties.getConfigFileEnv(), service);
        if (props.isEmpty()) {
            for (int i = 0; i < this.__getservicePropertiesList().size() && props.isEmpty(); ++i) {
                ServiceProperties serviceProperties = (ServiceProperties)this.__getservicePropertiesList().get(i);
                if (!serviceProperties.getService().equals(service)) continue;
                props = this.getServicesProperties(serviceProperties.getProperties(), service);
            }
        }
        props.put(JONAS_SERVICE, service);
        return props;
    }

    private Dictionary<String, String> getServicesProperties(Properties properties, String service) {
        Dictionary<String, String> dictionary;
        if (!this.__MgetServicesProperties$java_util_Properties$java_lang_String) {
            return this.__M_getServicesProperties(properties, service);
        }
        try {
            this.__IM.onEntry((Object)this, "getServicesProperties$java_util_Properties$java_lang_String", new Object[]{properties, service});
            dictionary = this.__M_getServicesProperties(properties, service);
            this.__IM.onExit((Object)this, "getServicesProperties$java_util_Properties$java_lang_String", dictionary);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServicesProperties$java_util_Properties$java_lang_String", throwable);
            throw throwable;
        }
        return dictionary;
    }

    private Dictionary<String, String> __M_getServicesProperties(Properties properties, String service) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        for (Object key : properties.keySet()) {
            String servicePrefix;
            String name = (String)key;
            if (!name.startsWith(servicePrefix = "jonas.service." + service + ".")) continue;
            String value = properties.getProperty(name);
            name = name.substring(servicePrefix.length());
            ((Dictionary)props).put(name, value);
        }
        return props;
    }

    private Configuration getConfiguration(String service) throws Exception {
        Configuration configuration;
        if (!this.__MgetConfiguration$java_lang_String) {
            return this.__M_getConfiguration(service);
        }
        try {
            this.__IM.onEntry((Object)this, "getConfiguration$java_lang_String", new Object[]{service});
            configuration = this.__M_getConfiguration(service);
            this.__IM.onExit((Object)this, "getConfiguration$java_lang_String", (Object)configuration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConfiguration$java_lang_String", throwable);
            throw throwable;
        }
        return configuration;
    }

    private Configuration __M_getConfiguration(String service) throws Exception {
        Configuration[] storedConfigurations = this.__getconfigurationAdmin().listConfigurations("(service.factoryPid=" + this.getFactoryPID(service) + ")");
        if (storedConfigurations != null && storedConfigurations.length == 1) {
            return storedConfigurations[0];
        }
        return null;
    }

    private String getFactoryPID(String service) {
        String string;
        if (!this.__MgetFactoryPID$java_lang_String) {
            return this.__M_getFactoryPID(service);
        }
        try {
            this.__IM.onEntry((Object)this, "getFactoryPID$java_lang_String", new Object[]{service});
            string = this.__M_getFactoryPID(service);
            this.__IM.onExit((Object)this, "getFactoryPID$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFactoryPID$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getFactoryPID(String service) {
        String serviceClass = "jonas.service." + service + ".class";
        String factoryPID = this.getServerProperties().getValue(serviceClass);
        if (factoryPID == null) {
            for (ServiceProperties serviceProperties : this.__getservicePropertiesList()) {
                if (!serviceProperties.getService().equals(service)) continue;
                return serviceProperties.getValue(serviceClass);
            }
        }
        return factoryPID;
    }

    public void modifyConfiguration(ServiceReference serviceReference, Dictionary storedProperties) {
        if (!this.__MmodifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary) {
            this.__M_modifyConfiguration(serviceReference, storedProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary", new Object[]{serviceReference, storedProperties});
            this.__M_modifyConfiguration(serviceReference, storedProperties);
            this.__IM.onExit((Object)this, "modifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_modifyConfiguration(ServiceReference serviceReference, Dictionary storedProperties) {
        try {
            Dictionary newProperties;
            String serviceName = (String)storedProperties.get(JONAS_SERVICE);
            if (serviceName != null && this.isConfigurationModified(storedProperties, newProperties = this.getServiceProperties(serviceName))) {
                Enumeration enProps = newProperties.keys();
                while (enProps.hasMoreElements()) {
                    String key = (String)enProps.nextElement();
                    storedProperties.put(key, newProperties.get(key));
                }
            }
        }
        catch (Exception e) {
            this.__getlogger().error((Object)e, new Object[0]);
        }
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin) {
            this.__M_setConfigurationAdmin(configurationAdmin);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", new Object[]{configurationAdmin});
            this.__M_setConfigurationAdmin(configurationAdmin);
            this.__IM.onExit((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", throwable);
            throw throwable;
        }
    }

    private void __M_setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.__setconfigurationAdmin(configurationAdmin);
    }

    private boolean isConfigurationModified(Dictionary<String, String> storedProperties, Dictionary<String, String> newProperties) {
        boolean bl;
        if (!this.__MisConfigurationModified$java_util_Dictionary$java_util_Dictionary) {
            return this.__M_isConfigurationModified(storedProperties, newProperties);
        }
        try {
            this.__IM.onEntry((Object)this, "isConfigurationModified$java_util_Dictionary$java_util_Dictionary", new Object[]{storedProperties, newProperties});
            bl = this.__M_isConfigurationModified(storedProperties, newProperties);
            this.__IM.onExit((Object)this, "isConfigurationModified$java_util_Dictionary$java_util_Dictionary", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isConfigurationModified$java_util_Dictionary$java_util_Dictionary", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isConfigurationModified(Dictionary<String, String> storedProperties, Dictionary<String, String> newProperties) {
        storedProperties.remove("service.pid");
        storedProperties.remove("service.factoryPid");
        storedProperties.remove("service.bundleLocation");
        if (storedProperties.size() != newProperties.size()) {
            return true;
        }
        Enumeration<String> enProps = storedProperties.keys();
        while (enProps.hasMoreElements()) {
            String key = enProps.nextElement();
            if (newProperties.get(key) == null) {
                return true;
            }
            if (storedProperties.get(key).equals(newProperties.get(key))) continue;
            return true;
        }
        return false;
    }

    private void deleteServiceConfigurations() throws Exception {
        if (!this.__MdeleteServiceConfigurations) {
            this.__M_deleteServiceConfigurations();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteServiceConfigurations", new Object[0]);
            this.__M_deleteServiceConfigurations();
            this.__IM.onExit((Object)this, "deleteServiceConfigurations", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteServiceConfigurations", throwable);
            throw throwable;
        }
    }

    private void __M_deleteServiceConfigurations() throws Exception {
        Configuration[] storedConfigurations = this.__getconfigurationAdmin().listConfigurations(null);
        if (storedConfigurations != null) {
            for (Configuration configuration : storedConfigurations) {
                String serviceName = (String)configuration.getProperties().get(JONAS_SERVICE);
                if (serviceName == null) continue;
                configuration.delete();
            }
        }
    }

    private JProp getServerProperties() {
        JProp jProp;
        if (!this.__MgetServerProperties) {
            return this.__M_getServerProperties();
        }
        try {
            this.__IM.onEntry((Object)this, "getServerProperties", new Object[0]);
            jProp = this.__M_getServerProperties();
            this.__IM.onExit((Object)this, "getServerProperties", (Object)jProp);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServerProperties", throwable);
            throw throwable;
        }
        return jProp;
    }

    private JProp __M_getServerProperties() {
        File conf = new File(JProp.getJonasBase(), "conf");
        File jonasPropertyFile = new File(conf, "jonas.properties");
        long currentLastModified = jonasPropertyFile.lastModified();
        if (currentLastModified != this.__getlastModified()) {
            this.__setserverProperties(new JProp());
            this.__setlastModified(currentLastModified);
        }
        return this.__getserverProperties();
    }

    private List<String> removeDuplicateServices(List<String> services) {
        List<String> list;
        if (!this.__MremoveDuplicateServices$java_util_List) {
            return this.__M_removeDuplicateServices(services);
        }
        try {
            this.__IM.onEntry((Object)this, "removeDuplicateServices$java_util_List", new Object[]{services});
            list = this.__M_removeDuplicateServices(services);
            this.__IM.onExit((Object)this, "removeDuplicateServices$java_util_List", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeDuplicateServices$java_util_List", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_removeDuplicateServices(List<String> services) {
        LinkedList<String> result = new LinkedList<String>();
        for (String service : services) {
            if (!result.contains(service)) {
                result.add(service);
                continue;
            }
            this.__getlogger().warn((Object)"Service ''{0}'' declared many times in jonas.properties", new Object[]{service});
        }
        return result;
    }

    public void addServiceProperties(ServiceProperties serviceProperties) {
        if (!this.__MaddServiceProperties$org_ow2_jonas_properties_ServiceProperties) {
            this.__M_addServiceProperties(serviceProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addServiceProperties$org_ow2_jonas_properties_ServiceProperties", new Object[]{serviceProperties});
            this.__M_addServiceProperties(serviceProperties);
            this.__IM.onExit((Object)this, "addServiceProperties$org_ow2_jonas_properties_ServiceProperties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addServiceProperties$org_ow2_jonas_properties_ServiceProperties", throwable);
            throw throwable;
        }
    }

    private void __M_addServiceProperties(ServiceProperties serviceProperties) {
        this.__getservicePropertiesList().add(serviceProperties);
    }

    public void removeServiceProperties(ServiceProperties serviceProperties) {
        if (!this.__MremoveServiceProperties$org_ow2_jonas_properties_ServiceProperties) {
            this.__M_removeServiceProperties(serviceProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeServiceProperties$org_ow2_jonas_properties_ServiceProperties", new Object[]{serviceProperties});
            this.__M_removeServiceProperties(serviceProperties);
            this.__IM.onExit((Object)this, "removeServiceProperties$org_ow2_jonas_properties_ServiceProperties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeServiceProperties$org_ow2_jonas_properties_ServiceProperties", throwable);
            throw throwable;
        }
    }

    private void __M_removeServiceProperties(ServiceProperties serviceProperties) {
        this.__getservicePropertiesList().remove(serviceProperties);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bc")) {
                this.__Fbc = true;
            }
            if (set.contains("configurationAdmin")) {
                this.__FconfigurationAdmin = true;
            }
            if (set.contains("lastModified")) {
                this.__FlastModified = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("mandatoryServices")) {
                this.__FmandatoryServices = true;
            }
            if (set.contains("serverProperties")) {
                this.__FserverProperties = true;
            }
            if (set.contains("servicePropertiesList")) {
                this.__FservicePropertiesList = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("haltServer")) {
                this.__MhaltServer = true;
            }
            if (set.contains("updateServiceConfiguration$java_lang_String")) {
                this.__MupdateServiceConfiguration$java_lang_String = true;
            }
            if (set.contains("deleteServiceConfiguration$java_lang_String")) {
                this.__MdeleteServiceConfiguration$java_lang_String = true;
            }
            if (set.contains("matchService$java_lang_String")) {
                this.__MmatchService$java_lang_String = true;
            }
            if (set.contains("manageServiceConfigurations$java_util_List$boolean")) {
                this.__MmanageServiceConfigurations$java_util_List$boolean = true;
            }
            if (set.contains("getMandatoryServices")) {
                this.__MgetMandatoryServices = true;
            }
            if (set.contains("getAllServices")) {
                this.__MgetAllServices = true;
            }
            if (set.contains("getOptionalServices")) {
                this.__MgetOptionalServices = true;
            }
            if (set.contains("getDeclaredServices")) {
                this.__MgetDeclaredServices = true;
            }
            if (set.contains("getServiceProperties$java_lang_String")) {
                this.__MgetServiceProperties$java_lang_String = true;
            }
            if (set.contains("getServicesProperties$java_util_Properties$java_lang_String")) {
                this.__MgetServicesProperties$java_util_Properties$java_lang_String = true;
            }
            if (set.contains("getConfiguration$java_lang_String")) {
                this.__MgetConfiguration$java_lang_String = true;
            }
            if (set.contains("getFactoryPID$java_lang_String")) {
                this.__MgetFactoryPID$java_lang_String = true;
            }
            if (set.contains("modifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary")) {
                this.__MmodifyConfiguration$org_osgi_framework_ServiceReference$java_util_Dictionary = true;
            }
            if (set.contains("setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin")) {
                this.__MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin = true;
            }
            if (set.contains("isConfigurationModified$java_util_Dictionary$java_util_Dictionary")) {
                this.__MisConfigurationModified$java_util_Dictionary$java_util_Dictionary = true;
            }
            if (set.contains("deleteServiceConfigurations")) {
                this.__MdeleteServiceConfigurations = true;
            }
            if (set.contains("getServerProperties")) {
                this.__MgetServerProperties = true;
            }
            if (set.contains("removeDuplicateServices$java_util_List")) {
                this.__MremoveDuplicateServices$java_util_List = true;
            }
            if (set.contains("addServiceProperties$org_ow2_jonas_properties_ServiceProperties")) {
                this.__MaddServiceProperties$org_ow2_jonas_properties_ServiceProperties = true;
            }
            if (set.contains("removeServiceProperties$org_ow2_jonas_properties_ServiceProperties")) {
                this.__MremoveServiceProperties$org_ow2_jonas_properties_ServiceProperties = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

