/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.impl.jms;

import java.net.ConnectException;
import java.util.Arrays;
import java.util.List;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.ow2.cmi.controller.server.ClusterView;
import org.ow2.cmi.controller.server.Domain;
import org.ow2.cmi.controller.server.ServerView;
import org.ow2.cmi.controller.server.impl.jms.Config;
import org.ow2.cmi.controller.server.impl.jms.JORAMServerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JORAMHelper {
    private static Log logger = LogFactory.getLog(JORAMHelper.class);

    private JORAMHelper() {
    }

    public static javax.jms.Topic createTopic(String topicName, javax.jms.Topic ourTopic, javax.jms.Topic superTopic) throws JORAMServerException {
        Topic topic;
        try {
            topic = Topic.create((String)topicName);
            topic.setFreeReading();
            topic.setFreeWriting();
            if (superTopic != null && superTopic instanceof Topic) {
                topic.setParent((Topic)superTopic);
            } else if (ourTopic != null && ourTopic instanceof Topic) {
                topic.addClusteredTopic((Topic)ourTopic);
            }
        }
        catch (ConnectException e) {
            logger.error((Object)("Unable to create the topic with name " + topicName), new Object[]{e});
            throw new JORAMServerException("Unable to create the topic with name " + topicName, e);
        }
        catch (AdminException e) {
            logger.error((Object)("Unable to create the topic with name " + topicName), new Object[]{e});
            throw new JORAMServerException("Unable to create the topic with name " + topicName, e);
        }
        return topic;
    }

    public static void checkMyTopic(javax.jms.Topic myTopic, javax.jms.Topic ourTopic, javax.jms.Topic superTopic) throws JORAMServerException {
        block10: {
            if (superTopic != null && superTopic instanceof Topic) {
                try {
                    Topic topic = ((Topic)myTopic).getHierarchicalFather();
                    if (!superTopic.equals(topic)) {
                        logger.error((Object)"Not a hierarchical topic as expected.", new Object[0]);
                        throw new JORAMServerException("Not a hierarchical topic as expected.");
                    }
                    break block10;
                }
                catch (ConnectException e) {
                    logger.error((Object)"Unable to check the use of hierarchical topic", new Object[]{e});
                    throw new JORAMServerException("Unable to check the use of hierarchical topic", e);
                }
                catch (AdminException e) {
                    logger.error((Object)"Unable to check the use of hierarchical topic", new Object[]{e});
                    throw new JORAMServerException("Unable to check the use of hierarchical topic", e);
                }
            }
            if (ourTopic != null && ourTopic instanceof Topic) {
                try {
                    List fellows = ((Topic)myTopic).getClusterFellows();
                    if (!fellows.contains(ourTopic)) {
                        logger.error((Object)"Not a clustered topic as expected.", new Object[0]);
                        throw new JORAMServerException("Not a clustered topic as expected.");
                    }
                }
                catch (ConnectException e) {
                    logger.error((Object)"Unable to check the use of clustered topic", new Object[]{e});
                    throw new JORAMServerException("Unable to check the use of clustered topic", e);
                }
                catch (AdminException e) {
                    logger.error((Object)"Unable to check the use of clustered topic", new Object[]{e});
                    throw new JORAMServerException("Unable to check the use of clustered topic", e);
                }
            }
        }
    }

    public static void setDistributedConfig(Config config, ClusterView clusterView) throws JORAMServerException {
        String domainName = config.getDomainName();
        if (domainName == null) {
            logger.error((Object)"Unable to set a distributed config without domain name!", new Object[0]);
            throw new JORAMServerException("Unable to set a distributed config without domain name!");
        }
        try {
            if (!Arrays.asList(AdminModule.getDomainNames((int)config.getServerId().shortValue())).contains(domainName)) {
                if (config.getDomainPort() == null) {
                    logger.error((Object)"Unable to add a domain without its domain name", new Object[0]);
                    throw new JORAMServerException("Unable to add a domain without its domain name");
                }
                AdminModule.addDomain((String)domainName, (int)config.getServerId().shortValue(), (int)config.getDomainPort());
                if (clusterView != null) {
                    for (ServerView serverView : clusterView.getServerViews(domainName)) {
                        Domain domain = serverView.getDomain(domainName);
                        AdminModule.addServer((int)serverView.getId(), (String)serverView.getServerRef().getHostname(), (String)domainName, (int)domain.getPort(), (String)serverView.getServerName());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to administrate the JORAM server", new Object[]{e});
            throw new JORAMServerException("Unable to administrate the JORAM server", e);
        }
    }

    public static String getServerName() throws JORAMServerException {
        try {
            return AdminModule.getLocalServer().getName();
        }
        catch (ConnectException e) {
            logger.error((Object)"Unable to retrieve the local server name", new Object[]{e});
            throw new JORAMServerException("Unable to retrieve the local server name", e);
        }
        catch (AdminException e) {
            logger.error((Object)"Unable to retrieve the local server name", new Object[]{e});
            throw new JORAMServerException("Unable to retrieve the local server name", e);
        }
    }
}

