/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.coyote.ActionCode;

public class SSLAuthenticator
extends AuthenticatorBase {
    protected static final String info = "org.apache.catalina.authenticator.SSLAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        X509Certificate[] certs;
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            String ssoId;
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("Already authenticated '" + principal.getName() + "'");
            }
            if ((ssoId = (String)request.getNote("org.apache.catalina.request.SSOID")) != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug(" Looking up certificates");
        }
        if ((certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate")) == null || certs.length < 1) {
            request.getCoyoteRequest().action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        if (certs == null || certs.length < 1) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("  No certificates included with this request");
            }
            response.sendError(400, sm.getString("authenticator.certificates"));
            return false;
        }
        principal = this.context.getRealm().authenticate(certs);
        if (principal == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("  Realm.authenticate() returned false");
            }
            response.sendError(401, sm.getString("authenticator.unauthorized"));
            return false;
        }
        this.register(request, response, principal, "CLIENT_CERT", null, null);
        return true;
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

