/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class PersistentValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.PersistentValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Session hsess;
        Store store;
        Context context = request.getContext();
        if (context == null) {
            response.sendError(500, sm.getString("standardHost.noContext"));
            return;
        }
        Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        String sessionId = request.getRequestedSessionId();
        Manager manager = context.getManager();
        if (sessionId != null && manager != null && manager instanceof PersistentManager && (store = ((PersistentManager)manager).getStore()) != null) {
            Session session = null;
            try {
                session = store.load(sessionId);
            }
            catch (Exception e) {
                this.container.getLogger().error("deserializeError");
            }
            if (session != null) {
                if (!session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
                    if (this.container.getLogger().isDebugEnabled()) {
                        this.container.getLogger().debug("session swapped in is invalid or expired");
                    }
                    session.expire();
                    store.remove(sessionId);
                } else {
                    session.setManager(manager);
                    manager.add(session);
                    session.access();
                }
            }
        }
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug("sessionId: " + sessionId);
        }
        this.getNext().invoke(request, response);
        try {
            hsess = request.getSessionInternal();
        }
        catch (Exception ex) {
            hsess = null;
        }
        String newsessionId = null;
        if (hsess != null) {
            newsessionId = hsess.getIdInternal();
        }
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug("newsessionId: " + newsessionId);
        }
        if (newsessionId != null) {
            if (manager instanceof PersistentManager) {
                Session session = manager.findSession(newsessionId);
                Store store2 = ((PersistentManager)manager).getStore();
                if (store2 != null && session != null && session.isValid() && !this.isSessionStale(session, System.currentTimeMillis())) {
                    store2.save(session);
                    ((PersistentManager)manager).removeSuper(session);
                    session.recycle();
                } else if (this.container.getLogger().isDebugEnabled()) {
                    this.container.getLogger().debug("newsessionId store: " + store2 + " session: " + session + " valid: " + session.isValid() + " Staled: " + this.isSessionStale(session, System.currentTimeMillis()));
                }
            } else if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().debug("newsessionId Manager: " + manager);
            }
        }
    }

    protected boolean isSessionStale(Session session, long timeNow) {
        int timeIdle;
        int maxInactiveInterval = session.getMaxInactiveInterval();
        return maxInactiveInterval >= 0 && (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) >= maxInactiveInterval;
    }
}

