/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6;

import java.net.URL;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.tomcat.util.modeler.Registry;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.web.tomcat6.Tomcat6Service;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JOnASStandardContext
extends StandardContext {
    private static final long serialVersionUID = 1L;
    private static transient Tomcat6Service catalinaService = null;
    private static Log logger = LogFactory.getLog(JOnASStandardContext.class);
    private URL earURL = null;
    private boolean inEarCase = false;
    private boolean inServerXml = false;
    private boolean java2DelegationModel = false;
    private WebContainerDeploymentDesc webDeploymentDescriptor = null;
    private String jonasDeploymentDescriptor = null;
    private boolean startedJStdx = false;
    private URL warURL = null;
    private String earON = null;

    public JOnASStandardContext() {
        this(true, true, false);
    }

    public JOnASStandardContext(boolean inServerXml, boolean java2DelegationModel, boolean inEarCase) {
        this.inServerXml = inServerXml;
        this.java2DelegationModel = java2DelegationModel;
        this.inEarCase = inEarCase;
    }

    public void setTomcatService(Tomcat6Service tomcat) {
        catalinaService = tomcat;
    }

    public URL getEarURL() {
        return this.earURL;
    }

    public WebContainerDeploymentDesc getWebDeploymentDescriptor() {
        return this.webDeploymentDescriptor;
    }

    public String getJonasDeploymentDescriptor() {
        return this.jonasDeploymentDescriptor;
    }

    public URL getWarURL() {
        return this.warURL;
    }

    public boolean isInEarCase() {
        return this.inEarCase;
    }

    public boolean isInServerXml() {
        return this.inServerXml;
    }

    public boolean isJava2DelegationModel() {
        return this.java2DelegationModel;
    }

    protected void setEarURL(URL earURL) {
        this.earURL = earURL;
        ObjectName j2eeAppOn = null;
        String appName = this.getJ2EEApplication();
        String serverON = this.getServer();
        if (appName != null && serverON != null) {
            try {
                ObjectName serverOn = ObjectName.getInstance(serverON);
                String domainName = serverOn.getDomain();
                String serverName = serverOn.getKeyProperty("name");
                j2eeAppOn = J2eeObjectName.J2EEApplication((String)domainName, (String)serverName, (String)appName);
            }
            catch (MalformedObjectNameException e) {
                logger.error((Object)"Cannot build the ObjectName for the context ''{0}''", new Object[]{e});
            }
        }
        if (j2eeAppOn != null) {
            this.earON = j2eeAppOn.toString();
        }
    }

    protected void setInEarCase(boolean inEarCase) {
        this.inEarCase = inEarCase;
    }

    protected void setJava2DelegationModel(boolean java2DelegationModel) {
        this.java2DelegationModel = java2DelegationModel;
    }

    public void setWebDeploymentDescriptor(WebContainerDeploymentDesc webDeploymentDescriptor) {
        this.webDeploymentDescriptor = webDeploymentDescriptor;
    }

    public void setJonasDeploymentDescriptor(String jonasDeploymentDescriptor) {
        this.jonasDeploymentDescriptor = jonasDeploymentDescriptor;
    }

    protected void setWarURL(URL warURL) {
        this.warURL = warURL;
    }

    public synchronized void start() throws LifecycleException {
        if (catalinaService != null && catalinaService.isTomcatStarted()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Tomcat in Web container service is started, starting the context...", new Object[0]);
            }
            this.startedJStdx = true;
            super.start();
        }
    }

    public synchronized void stop() throws LifecycleException {
        if (this.startedJStdx) {
            this.startedJStdx = false;
            super.stop();
            this.unregisterJMX();
        }
    }

    private void unregisterJMX() {
        if (this.getObjectName() != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.getObjectName());
        }
    }

    public void addResource(ContextResource resource) {
    }

    public void addEnvironment(ContextEnvironment environment) {
    }

    public void addMessageDestinationRef(MessageDestinationRef mdr) {
    }

    public void setParentClassLoader(ClassLoader parent) {
        if (!this.startedJStdx) {
            super.setParentClassLoader(parent);
        }
    }

    public String getEarON() {
        return this.earON;
    }
}

