/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.DefaultAnnotationProcessor;
import org.apache.catalina.util.ServerInfo;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.tomcat.util.digester.Digester;
import org.objectweb.util.monolog.api.BasicLevel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.easybeans.deployment.api.EZBInjectionHolder;
import org.ow2.jonas.asm.ClassReader;
import org.ow2.jonas.asm.ClassVisitor;
import org.ow2.jonas.asm.ClassWriter;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerManager;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.base.lib.PermissionManager;
import org.ow2.jonas.web.tomcat6.CheckOpenResourcesValve;
import org.ow2.jonas.web.tomcat6.JCatalinaRuleSet;
import org.ow2.jonas.web.tomcat6.JOnASContextConfig;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;
import org.ow2.jonas.web.tomcat6.ResetAuthenticationValve;
import org.ow2.jonas.web.tomcat6.security.Realm;
import org.ow2.jonas.web.tomcat6.tx.TransactionValve;
import org.ow2.jonas.web.tomcat6.versioning.ConnectorTransformer;
import org.ow2.jonas.web.tomcat6.versioning.ContextFinder;
import org.ow2.jonas.web.tomcat6.versioning.CoyoteAdapterTransformer;
import org.ow2.jonas.web.tomcat6.ws.WSContextLifecycleListener;
import org.ow2.jonas.web.tomcat6.ws.WSDeployment;
import org.ow2.jonas.web.tomcat6.ws.WebservicesWebDeployer;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.ejb.IWebDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tomcat6Service
extends BaseWebContainerService
implements JWebContainerService,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(Tomcat6Service.class);
    protected static final String CONFIG_FILE = "conf" + File.separator + "tomcat6-server.xml";
    public static final String CONNECTOR_CLASS_NAME = "org.apache.catalina.connector.Connector";
    public static final String COYOTE_ADAPTER_CLASS_NAME = "org.apache.catalina.connector.CoyoteAdapter";
    private static boolean tomcatTransformed = false;
    private boolean __Fserver;
    private Server server;
    private boolean __FexternalLoader;
    private ClassLoader externalLoader;
    private boolean __FtomcatStarted;
    private boolean tomcatStarted;
    private boolean __FsecurityService;
    private SecurityService securityService;
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __Freg;
    private ServiceRegistration reg;
    private boolean __Freg2;
    private ServiceRegistration reg2;
    private boolean __FtransactionService;
    private TransactionService transactionService;
    private boolean __FresourceCheckerManager;
    private IResourceCheckerManager resourceCheckerManager;
    private boolean __MinitCatalinaEnvironment;
    private boolean __MdoStart;
    private boolean __MstartInternalWebContainer;
    private boolean __MsetWebEnvironment$javax_naming_Context$org_ow2_easybeans_deployment_api_EZBInjectionHolder$java_lang_ClassLoader;
    private boolean __MisInternalContainerStarted;
    private boolean __MdoStop;
    private boolean __MdoRegisterWar$javax_naming_Context;
    private boolean __McreateContextConfig;
    private boolean __McreateJOnASRealm$java_lang_String$boolean;
    private boolean __MgetConfiguredMatchingJonasContexts$java_lang_String$java_io_File$java_lang_String;
    private boolean __McheckStartedContext$org_apache_catalina_Context$org_ow2_jonas_web_base_lib_PermissionManager;
    private boolean __MgetEngines;
    private boolean __MgetContexts;
    private boolean __MdoUnRegisterWar$javax_naming_Context;
    private boolean __MremoveContext$org_apache_catalina_Context;
    private boolean __MisTomcatStarted;
    private boolean __MsetServer$org_apache_catalina_Server;
    private boolean __MgetServer;
    private boolean __MgetConfigFile;
    private boolean __MfindHost$java_lang_String;
    private boolean __McreateServerDigester;
    private boolean __MupdateServerInfos;
    private boolean __MgetDefaultHost;
    private boolean __MgetDefaultHttpPort;
    private boolean __MgetDefaultHttpsPort;
    private boolean __MgetPort$java_lang_String;
    private boolean __MgetFirstService;
    private boolean __MregisterWar$java_lang_String;
    private boolean __MunRegisterWar$java_lang_String;
    private boolean __MsetSecurityService$org_ow2_jonas_security_SecurityService;
    private boolean __MgetSecurityService;
    private boolean __MsetTransactionService$org_ow2_jonas_tm_TransactionService;
    private boolean __MgetTransactionService;
    private boolean __MgetResourceCheckerManager;
    private boolean __MsetResourceCheckerManager$org_ow2_jonas_jndi_checker_api_IResourceCheckerManager;
    private boolean __MunsetResourceCheckerManager;
    private boolean __MtransformConnector;
    private boolean __MtransformCoyoteAdaptor;
    private boolean __MtransformClass$java_lang_String$java_lang_Class;

    Server __getserver() {
        if (!this.__Fserver) {
            return this.server;
        }
        return (Server)this.__IM.onGet((Object)this, "server");
    }

    void __setserver(Server server) {
        if (!this.__Fserver) {
            this.server = server;
            return;
        }
        this.__IM.onSet((Object)this, "server", (Object)server);
    }

    ClassLoader __getexternalLoader() {
        if (!this.__FexternalLoader) {
            return this.externalLoader;
        }
        return (ClassLoader)this.__IM.onGet((Object)this, "externalLoader");
    }

    void __setexternalLoader(ClassLoader classLoader) {
        if (!this.__FexternalLoader) {
            this.externalLoader = classLoader;
            return;
        }
        this.__IM.onSet((Object)this, "externalLoader", (Object)classLoader);
    }

    boolean __gettomcatStarted() {
        if (!this.__FtomcatStarted) {
            return this.tomcatStarted;
        }
        Object object = this.__IM.onGet((Object)this, "tomcatStarted");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __settomcatStarted(boolean bl) {
        if (!this.__FtomcatStarted) {
            this.tomcatStarted = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "tomcatStarted", (Object)bl2);
    }

    SecurityService __getsecurityService() {
        if (!this.__FsecurityService) {
            return this.securityService;
        }
        return (SecurityService)this.__IM.onGet((Object)this, "securityService");
    }

    void __setsecurityService(SecurityService securityService) {
        if (!this.__FsecurityService) {
            this.securityService = securityService;
            return;
        }
        this.__IM.onSet((Object)this, "securityService", (Object)securityService);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ServiceRegistration __getreg() {
        if (!this.__Freg) {
            return this.reg;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "reg");
    }

    void __setreg(ServiceRegistration serviceRegistration) {
        if (!this.__Freg) {
            this.reg = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "reg", (Object)serviceRegistration);
    }

    ServiceRegistration __getreg2() {
        if (!this.__Freg2) {
            return this.reg2;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "reg2");
    }

    void __setreg2(ServiceRegistration serviceRegistration) {
        if (!this.__Freg2) {
            this.reg2 = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "reg2", (Object)serviceRegistration);
    }

    TransactionService __gettransactionService() {
        if (!this.__FtransactionService) {
            return this.transactionService;
        }
        return (TransactionService)this.__IM.onGet((Object)this, "transactionService");
    }

    void __settransactionService(TransactionService transactionService) {
        if (!this.__FtransactionService) {
            this.transactionService = transactionService;
            return;
        }
        this.__IM.onSet((Object)this, "transactionService", (Object)transactionService);
    }

    IResourceCheckerManager __getresourceCheckerManager() {
        if (!this.__FresourceCheckerManager) {
            return this.resourceCheckerManager;
        }
        return (IResourceCheckerManager)this.__IM.onGet((Object)this, "resourceCheckerManager");
    }

    void __setresourceCheckerManager(IResourceCheckerManager iResourceCheckerManager) {
        if (!this.__FresourceCheckerManager) {
            this.resourceCheckerManager = iResourceCheckerManager;
            return;
        }
        this.__IM.onSet((Object)this, "resourceCheckerManager", (Object)iResourceCheckerManager);
    }

    public Tomcat6Service(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private Tomcat6Service(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setserver(null);
        this.__setexternalLoader(null);
        this.__settomcatStarted(false);
        this.__setsecurityService(null);
        this.__settransactionService(null);
        this.__setresourceCheckerManager(null);
        this.__setcontext(context);
    }

    protected void initCatalinaEnvironment() throws ServiceException {
        if (!this.__MinitCatalinaEnvironment) {
            this.__initCatalinaEnvironment();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initCatalinaEnvironment", new Object[0]);
            this.__initCatalinaEnvironment();
            this.__IM.onExit((Object)this, "initCatalinaEnvironment", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initCatalinaEnvironment", throwable);
            throw throwable;
        }
    }

    private void __initCatalinaEnvironment() throws ServiceException {
        String jonasRoot = System.getProperty("jonas.root");
        String jonasBase = System.getProperty("jonas.base");
        String catalinaHome = System.getProperty("catalina.home");
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaHome != null && !jonasRoot.equals(catalinaHome)) {
            logger.warn((Object)"The CATALINA_HOME property was set to ''{0}'', fix it by using JONAS_ROOT ''{1}''", new Object[]{catalinaHome, jonasRoot});
        }
        System.setProperty("catalina.home", jonasRoot);
        if (catalinaBase != null && !jonasBase.equals(catalinaBase)) {
            logger.warn((Object)"The CATALINA_BASE property was set to ''{0}'', fix it by using JONAS_BASE ''{1}''", new Object[]{catalinaBase, jonasBase});
        }
        System.setProperty("catalina.base", jonasBase);
        System.setProperty("catalina.useNaming", "false");
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        this.initCatalinaEnvironment();
        if (!this.isOnDemandFeatureEnabled()) {
            this.startInternalWebContainer();
        }
        super.doStart();
    }

    public synchronized void startInternalWebContainer() throws JWebContainerServiceException {
        if (!this.__MstartInternalWebContainer) {
            this.__startInternalWebContainer();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startInternalWebContainer", new Object[0]);
            this.__startInternalWebContainer();
            this.__IM.onExit((Object)this, "startInternalWebContainer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startInternalWebContainer", throwable);
            throw throwable;
        }
    }

    private void __startInternalWebContainer() throws JWebContainerServiceException {
        if (this.__gettomcatStarted()) {
            return;
        }
        LoaderManager lm = LoaderManager.getInstance();
        try {
            this.__setexternalLoader((ClassLoader)lm.getExternalLoader());
        }
        catch (Exception e1) {
            throw new ServiceException("Cannot get Application/Tomcat ClassLoader", (Throwable)e1);
        }
        ContextFinder.setParent(this);
        ContextFinder.setJmxService(this.jmxService);
        if (!tomcatTransformed) {
            this.transformCoyoteAdaptor();
            this.transformConnector();
            tomcatTransformed = true;
        }
        Digester digester = this.createServerDigester();
        File configFile = null;
        try {
            configFile = this.getConfigFile();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot find the file ''{0}''", new Object[]{CONFIG_FILE, e});
            throw new ServiceException("Cannot find the configuration file", (Throwable)e);
        }
        try {
            InputSource is = new InputSource("file://" + configFile.getAbsolutePath());
            FileInputStream fis = new FileInputStream(configFile);
            is.setByteStream(fis);
            digester.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            digester.push((Object)this);
            digester.parse(is);
            fis.close();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot parse the configuration file ''{0}''", new Object[]{configFile, e});
            throw new ServiceException("Cannot parse the configuration file '" + configFile + "'", (Throwable)e);
        }
        for (StandardEngine engine : this.getEngines()) {
            engine.setDomain(this.getDomainName());
            engine.setName(this.getDomainName());
        }
        if (this.isOnDemandFeatureEnabled()) {
            Service[] services = this.getServer().findServices();
            for (int s = 0; s < services.length; ++s) {
                Connector[] connectors = services[s].findConnectors();
                if (connectors.length < 1) continue;
                Connector connector = connectors[0];
                connector.setProperty("maxKeepAliveRequests", "1");
                connector.setPort(this.getOnDemandRedirectPort());
            }
        }
        IExecution<Void> startExec = new IExecution<Void>(){

            public Void execute() throws ServiceException {
                if (Tomcat6Service.this.__getserver() instanceof Lifecycle) {
                    try {
                        Tomcat6Service.this.__getserver().initialize();
                        ((Lifecycle)((Object)Tomcat6Service.this.__getserver())).start();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Cannot start the Tomcat server", new Object[]{e});
                        throw new ServiceException("Cannot start the Tomcat server", (Throwable)e);
                    }
                }
                return null;
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            logger.error((Object)"Cannot start the Tomcat server", new Object[]{startExecResult.getException()});
            throw new ServiceException("Cannot start the Tomcat Server", (Throwable)startExecResult.getException());
        }
        WSDeployment manager = new WSDeployment(this);
        manager.setWorkDirectory(WORK_DIR);
        this.__setreg(this.__getcontext().registerService(IWebServiceDeploymentManager.class.getName(), (Object)manager, null));
        WebservicesWebDeployer webDeployer = new WebservicesWebDeployer(this);
        webDeployer.setWorkDirectory(WORK_DIR);
        this.__setreg2(this.__getcontext().registerService(IWebDeployer.class.getName(), (Object)webDeployer, null));
        this.__settomcatStarted(true);
    }

    protected void setWebEnvironment(javax.naming.Context context, EZBInjectionHolder eZBInjectionHolder, ClassLoader classLoader) throws JWebContainerServiceException {
        if (!this.__MsetWebEnvironment$javax_naming_Context$org_ow2_easybeans_deployment_api_EZBInjectionHolder$java_lang_ClassLoader) {
            this.__setWebEnvironment(context, eZBInjectionHolder, classLoader);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setWebEnvironment$javax_naming_Context$org_ow2_easybeans_deployment_api_EZBInjectionHolder$java_lang_ClassLoader", new Object[]{context, eZBInjectionHolder, classLoader});
            this.__setWebEnvironment(context, eZBInjectionHolder, classLoader);
            this.__IM.onExit((Object)this, "setWebEnvironment$javax_naming_Context$org_ow2_easybeans_deployment_api_EZBInjectionHolder$java_lang_ClassLoader", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setWebEnvironment$javax_naming_Context$org_ow2_easybeans_deployment_api_EZBInjectionHolder$java_lang_ClassLoader", throwable);
            throw throwable;
        }
    }

    private void __setWebEnvironment(javax.naming.Context ctxParam, EZBInjectionHolder ezbInjectionHolder, ClassLoader webAppClassLoader) throws JWebContainerServiceException {
        super.setWebEnvironment(ctxParam, ezbInjectionHolder, webAppClassLoader);
        try {
            this.getNaming().getComponentContext(webAppClassLoader).bind("comp/env/BundleContext", (Object)this.__getcontext());
        }
        catch (NamingException e) {
            throw new JWebContainerServiceException("Cannot bind bundle context", (Throwable)e);
        }
    }

    public boolean isInternalContainerStarted() {
        boolean bl;
        if (!this.__MisInternalContainerStarted) {
            return this.__isInternalContainerStarted();
        }
        try {
            this.__IM.onEntry((Object)this, "isInternalContainerStarted", new Object[0]);
            bl = this.__isInternalContainerStarted();
            this.__IM.onExit((Object)this, "isInternalContainerStarted", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isInternalContainerStarted", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isInternalContainerStarted() {
        return this.__gettomcatStarted();
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        super.doStop();
        if (this.__getreg() != null) {
            this.__getreg().unregister();
        }
        if (this.__getreg2() != null) {
            this.__getreg2().unregister();
        }
        if (this.__gettomcatStarted() && this.__getserver() instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.__getserver())).stop();
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
        }
        this.__settomcatStarted(false);
    }

    protected void doRegisterWar(javax.naming.Context context) throws JWebContainerServiceException {
        if (!this.__MdoRegisterWar$javax_naming_Context) {
            this.__doRegisterWar(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doRegisterWar$javax_naming_Context", new Object[]{context});
            this.__doRegisterWar(context);
            this.__IM.onExit((Object)this, "doRegisterWar$javax_naming_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doRegisterWar$javax_naming_Context", throwable);
            throw throwable;
        }
    }

    private void __doRegisterWar(javax.naming.Context ctx) throws JWebContainerServiceException {
        URL warURL = null;
        URL earURL = null;
        URL unpackedWarURL = null;
        String contextRoot = null;
        boolean java2DelegationModel = true;
        PermissionManager permissionManager = null;
        boolean inEarCase = true;
        String earAppName = null;
        WebContainerDeploymentDesc webDD = null;
        String userURI = null;
        Map webservices = null;
        try {
            warURL = (URL)ctx.lookup("warURL");
            unpackedWarURL = (URL)ctx.lookup("unpackedWarURL");
            contextRoot = (String)ctx.lookup("contextRoot");
            Boolean bool = (Boolean)ctx.lookup("java2DelegationModel");
            java2DelegationModel = bool;
            webDD = (WebContainerDeploymentDesc)ctx.lookup("webDD");
            permissionManager = (PermissionManager)ctx.lookup("permissionManager");
            userURI = (String)ctx.lookup("userURI");
            webservices = (Map)ctx.lookup("webservices-metadatas");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get default parameters", new Object[]{e});
            throw new JWebContainerServiceException("Unable to get default parameters", (Throwable)e);
        }
        EZBInjectionHolder injectionHolder = null;
        try {
            injectionHolder = (EZBInjectionHolder)ctx.lookup(EZBInjectionHolder.class.getName());
        }
        catch (NamingException e) {
            logger.debug((Object)"No injection holder", new Object[0]);
        }
        try {
            earAppName = (String)ctx.lookup("earAppName");
            earURL = (URL)ctx.lookup("earURL");
        }
        catch (NamingException e) {
            inEarCase = false;
            earURL = warURL;
        }
        ClassLoader webClassLoader = null;
        try {
            webClassLoader = (ClassLoader)ctx.lookup("parentCL");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get parentCL parameter", new Object[]{e});
            throw new JWebContainerServiceException("Unable to get parentCL parameter", (Throwable)e);
        }
        String hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            hostName = "";
        }
        contextRoot = contextRoot.equals("/") ? "" : "/" + contextRoot;
        File fWar = new File(warURL.getFile());
        String destDir = null;
        destDir = fWar.isDirectory() ? warURL.getFile() : unpackedWarURL.getFile();
        File contextXmlFile = new File(destDir + File.separator + "META-INF" + File.separator + "context.xml");
        List<JOnASStandardContext> jonasContexts = this.getConfiguredMatchingJonasContexts(contextRoot, fWar, destDir);
        Host deployer = null;
        if (jonasContexts.isEmpty()) {
            deployer = this.findHost(hostName);
            JOnASStandardContext context = new JOnASStandardContext(false, java2DelegationModel, inEarCase);
            context.setDocBase(destDir);
            context.setPath(contextRoot);
            ContextConfig config = this.createContextConfig();
            context.addLifecycleListener(config);
            jonasContexts.add(context);
        }
        for (JOnASStandardContext jStdCtx : jonasContexts) {
            jStdCtx.setTomcatService(this);
            jStdCtx.setParentClassLoader(webClassLoader);
            jStdCtx.setDelegate(java2DelegationModel);
            if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Webapp class loader java 2 delegation model set to " + java2DelegationModel));
            }
            jStdCtx.addValve(new ResetAuthenticationValve());
            if (this.__gettransactionService() != null) {
                jStdCtx.addValve(new TransactionValve((TransactionManager)this.__gettransactionService().getTransactionManager()));
            }
            if (this.__getresourceCheckerManager() != null) {
                jStdCtx.addValve(new CheckOpenResourcesValve(this.__getresourceCheckerManager()));
            }
            if (!webservices.isEmpty()) {
                WSContextLifecycleListener listener = new WSContextLifecycleListener(webservices, this.getJAXWSService());
                jStdCtx.addLifecycleListener(listener);
            }
            if (contextXmlFile.exists()) {
                jStdCtx.setConfigFile(contextXmlFile.getAbsolutePath());
            }
            javax.naming.Context envCtx = null;
            try {
                envCtx = (javax.naming.Context)this.getNaming().getComponentContext(webClassLoader).lookup("comp/env");
            }
            catch (NamingException e) {
                Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot get the context of the webapplication '" + warURL + "'."), (Throwable)e);
            }
            DefaultAnnotationProcessor annotationProcessor = new DefaultAnnotationProcessor(envCtx);
            annotationProcessor.setEncBindingHolder(webDD.getENCBindingHolder());
            jStdCtx.setAnnotationProcessor(annotationProcessor);
            jStdCtx.setJ2EEServer(this.getJonasServerName());
            jStdCtx.setServer(J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName()).toString());
            MBeanServer mbeanServer = this.jmxService.getJmxServer();
            ObjectName j2eeServerOn = J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName());
            try {
                String[] as = (String[])mbeanServer.getAttribute(j2eeServerOn, "javaVMs");
                jStdCtx.setJavaVMs(as);
            }
            catch (Exception e) {
                Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Set MBean JVM error : " + e.getClass().getName() + " " + e.getMessage()));
            }
            if (earAppName != null) {
                jStdCtx.setJ2EEApplication(earAppName);
            } else {
                jStdCtx.setJ2EEApplication("null");
            }
            jStdCtx.setJonasDeploymentDescriptor(webDD.getJOnASXmlContent());
            jStdCtx.setWebDeploymentDescriptor(webDD);
            org.apache.catalina.Realm ctxRealm = jStdCtx.getRealm();
            if (ctxRealm == null) {
                ctxRealm = deployer.getRealm();
            }
            if (ctxRealm != null && ctxRealm instanceof Realm) {
                Realm jaccRealm = null;
                try {
                    jaccRealm = (Realm)((Realm)ctxRealm).clone();
                }
                catch (CloneNotSupportedException cnse) {
                    String err = "Cannot clone the realm used by the existing context or its parent realm";
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + cnse.getMessage()));
                    throw new JWebContainerServiceException(err, (Throwable)cnse);
                }
                if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Setting permission manager to " + permissionManager));
                }
                jaccRealm.setPermissionManager(permissionManager);
                jaccRealm.setSecurityService(this.__getsecurityService());
                jaccRealm.setContext(jStdCtx);
                jStdCtx.setRealm(jaccRealm);
            }
            jStdCtx.setWarURL(warURL);
            if (inEarCase) {
                jStdCtx.setEarURL(earURL);
            }
            if (jStdCtx.isInServerXml()) {
                try {
                    jStdCtx.setLoader(null);
                    jStdCtx.start();
                }
                catch (LifecycleException lce) {
                    logger.error((Object)("Cannot start the context '" + jStdCtx + "'."), new Object[]{lce});
                    throw new JWebContainerServiceException("Cannot start the context '" + jStdCtx + "'.", (Throwable)lce);
                }
            } else {
                if (deployer == null) {
                    logger.error((Object)("No deployer found for the deployment of the context '" + jStdCtx + "'."), new Object[0]);
                    throw new JWebContainerServiceException("No deployer found for the deployment of the context '" + jStdCtx + "'.");
                }
                deployer.addChild(jStdCtx);
            }
            if (this.getJAXWSService() != null) {
                this.getJAXWSService().finalizePOJODeployment(jStdCtx.getServletContext());
            }
            this.checkStartedContext(jStdCtx, permissionManager);
            try {
                ctx.rebind("WebModule", (Object)jStdCtx.createObjectName(this.getDomainName(), jStdCtx.getParentName()));
            }
            catch (Exception e) {
                String err = "Cannot rebind WebModule ObjectName in Context";
                logger.error((Object)err, new Object[]{e});
                throw new JWebContainerServiceException(err, (Throwable)e);
            }
            try {
                if (!this.isVersioningEnabled() || contextRoot.length() <= 0 || userURI.length() <= 0) continue;
                if (contextRoot.charAt(0) != '/') {
                    contextRoot = '/' + contextRoot;
                }
                if (userURI.charAt(0) != '/') {
                    userURI = '/' + userURI;
                }
                if (contextRoot.equals(userURI)) continue;
                logger.info((Object)("Deploying versioned application " + userURI + ", path for the added version is " + contextRoot), new Object[0]);
                String policy = this.getVersioningService().getDefaultDeploymentPolicy();
                if (earAppName != null) {
                    ContextFinder.bindContextRoot(earAppName, userURI, jStdCtx, policy);
                    continue;
                }
                ContextFinder.bindContextRoot(URLUtils.urlToFile((URL)warURL).getName(), userURI, jStdCtx, policy);
            }
            catch (Exception e) {
                throw new JWebContainerServiceException("Failed binding web context", (Throwable)e);
            }
        }
    }

    protected ContextConfig createContextConfig() {
        ContextConfig contextConfig;
        if (!this.__McreateContextConfig) {
            return this.__createContextConfig();
        }
        try {
            this.__IM.onEntry((Object)this, "createContextConfig", new Object[0]);
            contextConfig = this.__createContextConfig();
            this.__IM.onExit((Object)this, "createContextConfig", (Object)contextConfig);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createContextConfig", throwable);
            throw throwable;
        }
        return contextConfig;
    }

    private ContextConfig __createContextConfig() {
        JOnASContextConfig config = new JOnASContextConfig();
        config.setSecurityService(this.__getsecurityService());
        return config;
    }

    public Realm createJOnASRealm(String string, boolean bl) {
        Realm realm;
        if (!this.__McreateJOnASRealm$java_lang_String$boolean) {
            return this.__createJOnASRealm(string, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "createJOnASRealm$java_lang_String$boolean", new Object[]{string, new Boolean(bl)});
            realm = this.__createJOnASRealm(string, bl);
            this.__IM.onExit((Object)this, "createJOnASRealm$java_lang_String$boolean", (Object)realm);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createJOnASRealm$java_lang_String$boolean", throwable);
            throw throwable;
        }
        return realm;
    }

    private Realm __createJOnASRealm(String name, boolean isJaccRealm) {
        Realm realm = new Realm();
        realm.setSecurityService(this.getSecurityService());
        if (isJaccRealm) {
            realm.setResourceName(name);
        } else {
            realm.setJaasEntry(name);
        }
        return realm;
    }

    protected List<JOnASStandardContext> getConfiguredMatchingJonasContexts(String string, File file, String string2) {
        List<JOnASStandardContext> list;
        if (!this.__MgetConfiguredMatchingJonasContexts$java_lang_String$java_io_File$java_lang_String) {
            return this.__getConfiguredMatchingJonasContexts(string, file, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "getConfiguredMatchingJonasContexts$java_lang_String$java_io_File$java_lang_String", new Object[]{string, file, string2});
            list = this.__getConfiguredMatchingJonasContexts(string, file, string2);
            this.__IM.onExit((Object)this, "getConfiguredMatchingJonasContexts$java_lang_String$java_io_File$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConfiguredMatchingJonasContexts$java_lang_String$java_io_File$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JOnASStandardContext> __getConfiguredMatchingJonasContexts(String contextRoot, File fpackedWar, String destDir) {
        ArrayList<JOnASStandardContext> jonasContexts = new ArrayList<JOnASStandardContext>();
        for (Context ctx : this.getContexts()) {
            String serverCtxRoot;
            JOnASStandardContext jStdCtx;
            if (!(ctx instanceof JOnASStandardContext) || (jStdCtx = (JOnASStandardContext)ctx) == null || !jStdCtx.isInServerXml() || !(serverCtxRoot = jStdCtx.getPath()).equals(contextRoot)) continue;
            if (jStdCtx.getPrivileged()) {
                if (fpackedWar.isDirectory()) {
                    logger.error((Object)("Can deploy a privileged context '" + jStdCtx + "' only if it's a war file (and not a directory)"), new Object[0]);
                }
                jStdCtx.setDocBase(fpackedWar.getPath());
            } else {
                jStdCtx.setDocBase(destDir);
            }
            jonasContexts.add(jStdCtx);
        }
        return jonasContexts;
    }

    protected void checkStartedContext(Context context, PermissionManager permissionManager) throws JWebContainerServiceException {
        if (!this.__McheckStartedContext$org_apache_catalina_Context$org_ow2_jonas_web_base_lib_PermissionManager) {
            this.__checkStartedContext(context, permissionManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkStartedContext$org_apache_catalina_Context$org_ow2_jonas_web_base_lib_PermissionManager", new Object[]{context, permissionManager});
            this.__checkStartedContext(context, permissionManager);
            this.__IM.onExit((Object)this, "checkStartedContext$org_apache_catalina_Context$org_ow2_jonas_web_base_lib_PermissionManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkStartedContext$org_apache_catalina_Context$org_ow2_jonas_web_base_lib_PermissionManager", throwable);
            throw throwable;
        }
    }

    private void __checkStartedContext(Context context, PermissionManager permissionManager) throws JWebContainerServiceException {
        Realm jaccRealm;
        PermissionManager ctxPerm;
        if (!context.getConfigured()) {
            throw new JWebContainerServiceException("Context '" + context + "' was not configured");
        }
        org.apache.catalina.Realm ctxRealm = context.getRealm();
        if (ctxRealm != null && ctxRealm instanceof Realm && (ctxPerm = (jaccRealm = (Realm)ctxRealm).getPermissionManager()) == null && permissionManager != null) {
            jaccRealm.setPermissionManager(permissionManager);
            jaccRealm.setContext(context);
        }
        if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("context " + context + " started"));
        }
    }

    protected synchronized List<StandardEngine> getEngines() throws JWebContainerServiceException {
        List<StandardEngine> list;
        if (!this.__MgetEngines) {
            return this.__getEngines();
        }
        try {
            this.__IM.onEntry((Object)this, "getEngines", new Object[0]);
            list = this.__getEngines();
            this.__IM.onExit((Object)this, "getEngines", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getEngines", throwable);
            throw throwable;
        }
        return list;
    }

    private List<StandardEngine> __getEngines() throws JWebContainerServiceException {
        ArrayList<StandardEngine> engines = new ArrayList<StandardEngine>();
        Service[] services = this.getServer().findServices();
        for (int s = 0; s < services.length; ++s) {
            Container cont = services[s].getContainer();
            if (!(cont instanceof StandardEngine)) {
                String err = "The container of the service must be an engine (server.xml)";
                throw new JWebContainerServiceException(err);
            }
            engines.add((StandardEngine)cont);
        }
        return engines;
    }

    protected synchronized List<Context> getContexts() throws JWebContainerServiceException {
        List<Context> list;
        if (!this.__MgetContexts) {
            return this.__getContexts();
        }
        try {
            this.__IM.onEntry((Object)this, "getContexts", new Object[0]);
            list = this.__getContexts();
            this.__IM.onExit((Object)this, "getContexts", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContexts", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Context> __getContexts() throws JWebContainerServiceException {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (StandardEngine engine : this.getEngines()) {
            Container[] hosts = engine.findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                Container[] containers = hosts[j].findChildren();
                for (int k = 0; k < containers.length; ++k) {
                    Container container = containers[k];
                    if (!(container instanceof Context)) continue;
                    contexts.add((Context)container);
                }
            }
        }
        return contexts;
    }

    protected void doUnRegisterWar(javax.naming.Context context) throws JWebContainerServiceException {
        if (!this.__MdoUnRegisterWar$javax_naming_Context) {
            this.__doUnRegisterWar(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doUnRegisterWar$javax_naming_Context", new Object[]{context});
            this.__doUnRegisterWar(context);
            this.__IM.onExit((Object)this, "doUnRegisterWar$javax_naming_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doUnRegisterWar$javax_naming_Context", throwable);
            throw throwable;
        }
    }

    private void __doUnRegisterWar(javax.naming.Context ctx) throws JWebContainerServiceException {
        String contextRoot = null;
        try {
            contextRoot = (String)ctx.lookup("contextRoot");
        }
        catch (NamingException e) {
            throw new JWebContainerServiceException("Unable to find the contextRoot parameter", (Throwable)e);
        }
        contextRoot = contextRoot.equals("/") ? "" : "/" + contextRoot;
        String hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            logger.debug((Object)"No hostname was defined for this context", new Object[0]);
        }
        if (hostName == null) {
            boolean found = false;
            for (Context context : this.getContexts()) {
                String serverCtxRoot = context.getPath();
                if (!serverCtxRoot.equals(contextRoot)) continue;
                this.removeContext(context);
                found = true;
                break;
            }
            if (!found) {
                throw new JWebContainerServiceException("Unable to remove a context with the context name '" + contextRoot + "'.");
            }
        } else {
            Host host = this.findHost(hostName);
            Context context = host.map(contextRoot);
            if (context != null) {
                this.removeContext(context);
            } else {
                throw new JWebContainerServiceException("Unable to find a context for the given hostname '" + hostName + "'.");
            }
        }
        try {
            if (this.isVersioningEnabled() && contextRoot.length() > 0) {
                if (contextRoot.charAt(0) != '/') {
                    contextRoot = '/' + contextRoot;
                }
                if (ContextFinder.unbindContextRoot(contextRoot)) {
                    logger.info((Object)("Undeployed version " + contextRoot), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new JWebContainerServiceException("Failed binding web context", (Throwable)e);
        }
    }

    public synchronized void removeContext(Context context) throws JWebContainerServiceException {
        if (!this.__MremoveContext$org_apache_catalina_Context) {
            this.__removeContext(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeContext$org_apache_catalina_Context", new Object[]{context});
            this.__removeContext(context);
            this.__IM.onExit((Object)this, "removeContext$org_apache_catalina_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeContext$org_apache_catalina_Context", throwable);
            throw throwable;
        }
    }

    private void __removeContext(Context context) throws JWebContainerServiceException {
        boolean found = false;
        Iterator<Context> it = this.getContexts().iterator();
        while (it.hasNext() && !found) {
            if (context != it.next()) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        if (context instanceof JOnASStandardContext) {
            JOnASStandardContext jctx = (JOnASStandardContext)context;
            if (jctx.isInServerXml()) {
                try {
                    ((JOnASStandardContext)context).stop();
                }
                catch (LifecycleException le) {
                    throw new JWebContainerServiceException("Cannot stop context (" + le.getMessage() + ")");
                }
            } else {
                context.getParent().removeChild(context);
            }
        } else {
            context.getParent().removeChild(context);
            if (context instanceof StandardContext) {
                StandardContext ctx = (StandardContext)context;
                try {
                    this.jmxService.getJmxServer().unregisterMBean(ctx.getJmxName());
                }
                catch (Exception e) {
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot remove the MBean for the WebModule " + ctx.getObjectName() + " : " + e.getMessage()));
                }
            }
        }
    }

    public boolean isTomcatStarted() {
        boolean bl;
        if (!this.__MisTomcatStarted) {
            return this.__isTomcatStarted();
        }
        try {
            this.__IM.onEntry((Object)this, "isTomcatStarted", new Object[0]);
            bl = this.__isTomcatStarted();
            this.__IM.onExit((Object)this, "isTomcatStarted", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isTomcatStarted", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isTomcatStarted() {
        return this.__gettomcatStarted();
    }

    public void setServer(Server server) {
        if (!this.__MsetServer$org_apache_catalina_Server) {
            this.__setServer(server);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServer$org_apache_catalina_Server", new Object[]{server});
            this.__setServer(server);
            this.__IM.onExit((Object)this, "setServer$org_apache_catalina_Server", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServer$org_apache_catalina_Server", throwable);
            throw throwable;
        }
    }

    private void __setServer(Server server) {
        this.__setserver(server);
    }

    public synchronized Server getServer() {
        Server server;
        if (!this.__MgetServer) {
            return this.__getServer();
        }
        try {
            this.__IM.onEntry((Object)this, "getServer", new Object[0]);
            server = this.__getServer();
            this.__IM.onExit((Object)this, "getServer", (Object)server);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServer", throwable);
            throw throwable;
        }
        return server;
    }

    private Server __getServer() {
        if (this.__getserver() == null) {
            this.startInternalWebContainer();
        }
        return this.__getserver();
    }

    protected File getConfigFile() throws FileNotFoundException {
        File file;
        if (!this.__MgetConfigFile) {
            return this.__getConfigFile();
        }
        try {
            this.__IM.onEntry((Object)this, "getConfigFile", new Object[0]);
            file = this.__getConfigFile();
            this.__IM.onExit((Object)this, "getConfigFile", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConfigFile", throwable);
            throw throwable;
        }
        return file;
    }

    private File __getConfigFile() throws FileNotFoundException {
        String fileName = System.getProperty("catalina.base");
        File file = new File(fileName = fileName + File.separator + CONFIG_FILE);
        if (!file.exists()) {
            throw new FileNotFoundException("The configuration file '" + fileName + "' does not exists.");
        }
        return file;
    }

    public Host findHost(String string) throws JWebContainerServiceException {
        Host host;
        if (!this.__MfindHost$java_lang_String) {
            return this.__findHost(string);
        }
        try {
            this.__IM.onEntry((Object)this, "findHost$java_lang_String", new Object[]{string});
            host = this.__findHost(string);
            this.__IM.onExit((Object)this, "findHost$java_lang_String", (Object)host);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findHost$java_lang_String", throwable);
            throw throwable;
        }
        return host;
    }

    private Host __findHost(String hostName) throws JWebContainerServiceException {
        Service[] services = this.getServer().findServices();
        if (services.length < 1) {
            String err = "At least one service must be define in the server.xml of Tomcat";
            throw new JWebContainerServiceException(err);
        }
        if (hostName == null || hostName.equals("")) {
            Service service = services[0];
            Container cont = service.getContainer();
            if (!(cont instanceof Engine)) {
                String err = "The container of the service must be an engine";
                throw new JWebContainerServiceException(err);
            }
            Engine engine = (Engine)cont;
            String defaultHost = engine.getDefaultHost();
            if (defaultHost == null) {
                String err = "Default host must be specified in server.xml or host must be specified in jonas-web.xml";
                throw new JWebContainerServiceException(err);
            }
            Container child = engine.findChild(defaultHost);
            if (child instanceof Host) {
                return (Host)child;
            }
            String err = "Default host " + defaultHost + " not found";
            throw new JWebContainerServiceException(err);
        }
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (int s = 0; s < services.length; ++s) {
            Container cont = services[s].getContainer();
            if (!(cont instanceof Engine)) {
                String err = "The container of a service must be an engine";
                throw new JWebContainerServiceException(err);
            }
            Engine engine = (Engine)cont;
            Container child = engine.findChild(hostName);
            if (!(child instanceof Host)) continue;
            hosts.add((Host)child);
        }
        if (hosts.size() == 0) {
            String err = "Host " + hostName + " not found in all services/Engine of server.xml";
            throw new JWebContainerServiceException(err);
        }
        return (Host)hosts.get(0);
    }

    protected Digester createServerDigester() {
        Digester digester;
        if (!this.__McreateServerDigester) {
            return this.__createServerDigester();
        }
        try {
            this.__IM.onEntry((Object)this, "createServerDigester", new Object[0]);
            digester = this.__createServerDigester();
            this.__IM.onExit((Object)this, "createServerDigester", (Object)digester);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createServerDigester", throwable);
            throw throwable;
        }
        return digester;
    }

    private Digester __createServerDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet(new JCatalinaRuleSet(this.__getexternalLoader(), this.__getsecurityService()));
        digester.setUseContextClassLoader(true);
        return digester;
    }

    protected void updateServerInfos() {
        if (!this.__MupdateServerInfos) {
            this.__updateServerInfos();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateServerInfos", new Object[0]);
            this.__updateServerInfos();
            this.__IM.onExit((Object)this, "updateServerInfos", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateServerInfos", throwable);
            throw throwable;
        }
    }

    private void __updateServerInfos() {
        String infos = ServerInfo.getServerInfo();
        StringTokenizer st = new StringTokenizer(infos, "/");
        if (st.countTokens() != 2) {
            this.setServerName(infos);
            this.setServerVersion("");
        } else {
            this.setServerName(st.nextToken());
            this.setServerVersion(st.nextToken());
        }
    }

    public String getDefaultHost() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHost) {
            return this.__getDefaultHost();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHost", new Object[0]);
            string = this.__getDefaultHost();
            this.__IM.onExit((Object)this, "getDefaultHost", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHost", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultHost() throws JWebContainerServiceException {
        Engine engine = (Engine)this.getFirstService().getContainer();
        return engine.getDefaultHost();
    }

    public String getDefaultHttpPort() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHttpPort) {
            return this.__getDefaultHttpPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHttpPort", new Object[0]);
            string = this.__getDefaultHttpPort();
            this.__IM.onExit((Object)this, "getDefaultHttpPort", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHttpPort", throwable);
            throw throwable;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String __getDefaultHttpPort() throws JWebContainerServiceException {
        String string;
        if (this.__gettomcatStarted()) return String.valueOf(this.getPort("http"));
        File configFile = null;
        try {
            configFile = this.getConfigFile();
        }
        catch (FileNotFoundException e) {
            throw new JWebContainerServiceException("Cannot get configuration file", (Throwable)e);
        }
        FileInputStream is = null;
        try {
            String text;
            is = new FileInputStream(configFile);
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            try {
                builder = domFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new JWebContainerServiceException("Cannot build document builder", (Throwable)e);
            }
            Document doc = null;
            try {
                doc = builder.parse(is);
            }
            catch (SAXException e) {
                throw new JWebContainerServiceException("Cannot analyze configuration file", (Throwable)e);
            }
            catch (IOException e) {
                throw new JWebContainerServiceException("Cannot analyze configuration file", (Throwable)e);
            }
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpr = null;
            try {
                xPathExpr = xPath.compile("//Server/Service/Connector[1]");
            }
            catch (XPathExpressionException e) {
                throw new JWebContainerServiceException("Cannot analyze configuration file", (Throwable)e);
            }
            Node node = null;
            try {
                node = (Node)xPathExpr.evaluate(doc, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                throw new JWebContainerServiceException("Cannot analyze configuration file", (Throwable)e);
            }
            if (node == null) {
                throw new JWebContainerServiceException("No connector element found in the configuration file");
            }
            string = text = node.getAttributes().getNamedItem("port").getNodeValue();
            if (is == null) return string;
        }
        catch (FileNotFoundException e) {
            try {
                throw new JWebContainerServiceException("Cannot get input stream", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.debug((Object)"Cannot close input stream", new Object[]{e2});
                }
                throw throwable;
            }
        }
        try {
            ((InputStream)is).close();
            return string;
        }
        catch (IOException e) {
            logger.debug((Object)"Cannot close input stream", new Object[]{e});
        }
        return string;
    }

    public String getDefaultHttpsPort() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHttpsPort) {
            return this.__getDefaultHttpsPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHttpsPort", new Object[0]);
            string = this.__getDefaultHttpsPort();
            this.__IM.onExit((Object)this, "getDefaultHttpsPort", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHttpsPort", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultHttpsPort() throws JWebContainerServiceException {
        return String.valueOf(this.getPort("https"));
    }

    protected int getPort(String string) throws JWebContainerServiceException {
        int n;
        if (!this.__MgetPort$java_lang_String) {
            return this.__getPort(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getPort$java_lang_String", new Object[]{string});
            n = this.__getPort(string);
            this.__IM.onExit((Object)this, "getPort$java_lang_String", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPort$java_lang_String", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getPort(String scheme) throws JWebContainerServiceException {
        Service svc = this.getFirstService();
        ArrayList<Connector> conn = new ArrayList<Connector>();
        for (Connector c : svc.findConnectors()) {
            if (!c.getScheme().equalsIgnoreCase(scheme)) continue;
            conn.add(c);
        }
        if (conn.isEmpty()) {
            throw new JWebContainerServiceException("No Connectors found for scheme '" + scheme + "' in " + CONFIG_FILE);
        }
        Connector c = (Connector)conn.get(0);
        if (conn.size() > 1 && Tomcat6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Connectors for scheme '" + scheme + "' in " + CONFIG_FILE + ", using first by default! (port:" + c.getPort() + ")"));
        }
        return c.getPort();
    }

    protected Service getFirstService() {
        Service service;
        if (!this.__MgetFirstService) {
            return this.__getFirstService();
        }
        try {
            this.__IM.onEntry((Object)this, "getFirstService", new Object[0]);
            service = this.__getFirstService();
            this.__IM.onExit((Object)this, "getFirstService", (Object)service);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFirstService", throwable);
            throw throwable;
        }
        return service;
    }

    private Service __getFirstService() {
        Service[] svc = this.getServer().findServices();
        if (svc == null || svc.length == 0) {
            throw new JWebContainerServiceException("No Services found in " + CONFIG_FILE);
        }
        if (svc.length > 1 && Tomcat6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Services in " + CONFIG_FILE + ", using first by default!"));
        }
        return svc[0];
    }

    public void registerWar(String string) throws RemoteException, JWebContainerServiceException {
        if (!this.__MregisterWar$java_lang_String) {
            this.__registerWar(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerWar$java_lang_String", new Object[]{string});
            this.__registerWar(string);
            this.__IM.onExit((Object)this, "registerWar$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerWar$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __registerWar(String fileName) throws RemoteException, JWebContainerServiceException {
        ClassLoader old = null;
        try {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.__getexternalLoader());
            super.registerWar(fileName);
        }
        catch (Exception e) {
            throw new ServiceException("Exception during registering war", (Throwable)e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void unRegisterWar(String string) throws RemoteException, JWebContainerServiceException {
        if (!this.__MunRegisterWar$java_lang_String) {
            this.__unRegisterWar(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unRegisterWar$java_lang_String", new Object[]{string});
            this.__unRegisterWar(string);
            this.__IM.onExit((Object)this, "unRegisterWar$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unRegisterWar$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unRegisterWar(String fileName) throws RemoteException, JWebContainerServiceException {
        ClassLoader old = null;
        try {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.__getexternalLoader());
            super.unRegisterWar(fileName);
        }
        catch (Exception e) {
            throw new ServiceException("Exception during unregistering war", (Throwable)e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void setSecurityService(SecurityService securityService) {
        if (!this.__MsetSecurityService$org_ow2_jonas_security_SecurityService) {
            this.__setSecurityService(securityService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setSecurityService$org_ow2_jonas_security_SecurityService", new Object[]{securityService});
            this.__setSecurityService(securityService);
            this.__IM.onExit((Object)this, "setSecurityService$org_ow2_jonas_security_SecurityService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setSecurityService$org_ow2_jonas_security_SecurityService", throwable);
            throw throwable;
        }
    }

    private void __setSecurityService(SecurityService securityService) {
        this.__setsecurityService(securityService);
    }

    protected SecurityService getSecurityService() {
        SecurityService securityService;
        if (!this.__MgetSecurityService) {
            return this.__getSecurityService();
        }
        try {
            this.__IM.onEntry((Object)this, "getSecurityService", new Object[0]);
            securityService = this.__getSecurityService();
            this.__IM.onExit((Object)this, "getSecurityService", (Object)securityService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSecurityService", throwable);
            throw throwable;
        }
        return securityService;
    }

    private SecurityService __getSecurityService() {
        return this.__getsecurityService();
    }

    public void setTransactionService(TransactionService transactionService) {
        if (!this.__MsetTransactionService$org_ow2_jonas_tm_TransactionService) {
            this.__setTransactionService(transactionService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", new Object[]{transactionService});
            this.__setTransactionService(transactionService);
            this.__IM.onExit((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", throwable);
            throw throwable;
        }
    }

    private void __setTransactionService(TransactionService transactionService) {
        this.__settransactionService(transactionService);
    }

    protected TransactionService getTransactionService() {
        TransactionService transactionService;
        if (!this.__MgetTransactionService) {
            return this.__getTransactionService();
        }
        try {
            this.__IM.onEntry((Object)this, "getTransactionService", new Object[0]);
            transactionService = this.__getTransactionService();
            this.__IM.onExit((Object)this, "getTransactionService", (Object)transactionService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTransactionService", throwable);
            throw throwable;
        }
        return transactionService;
    }

    private TransactionService __getTransactionService() {
        return this.__gettransactionService();
    }

    public IResourceCheckerManager getResourceCheckerManager() {
        IResourceCheckerManager iResourceCheckerManager;
        if (!this.__MgetResourceCheckerManager) {
            return this.__getResourceCheckerManager();
        }
        try {
            this.__IM.onEntry((Object)this, "getResourceCheckerManager", new Object[0]);
            iResourceCheckerManager = this.__getResourceCheckerManager();
            this.__IM.onExit((Object)this, "getResourceCheckerManager", (Object)iResourceCheckerManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getResourceCheckerManager", throwable);
            throw throwable;
        }
        return iResourceCheckerManager;
    }

    private IResourceCheckerManager __getResourceCheckerManager() {
        return this.__getresourceCheckerManager();
    }

    public void setResourceCheckerManager(IResourceCheckerManager iResourceCheckerManager) {
        if (!this.__MsetResourceCheckerManager$org_ow2_jonas_jndi_checker_api_IResourceCheckerManager) {
            this.__setResourceCheckerManager(iResourceCheckerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setResourceCheckerManager$org_ow2_jonas_jndi_checker_api_IResourceCheckerManager", new Object[]{iResourceCheckerManager});
            this.__setResourceCheckerManager(iResourceCheckerManager);
            this.__IM.onExit((Object)this, "setResourceCheckerManager$org_ow2_jonas_jndi_checker_api_IResourceCheckerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setResourceCheckerManager$org_ow2_jonas_jndi_checker_api_IResourceCheckerManager", throwable);
            throw throwable;
        }
    }

    private void __setResourceCheckerManager(IResourceCheckerManager resourceCheckerManager) {
        this.__setresourceCheckerManager(resourceCheckerManager);
    }

    public void unsetResourceCheckerManager() {
        if (!this.__MunsetResourceCheckerManager) {
            this.__unsetResourceCheckerManager();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unsetResourceCheckerManager", new Object[0]);
            this.__unsetResourceCheckerManager();
            this.__IM.onExit((Object)this, "unsetResourceCheckerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unsetResourceCheckerManager", throwable);
            throw throwable;
        }
    }

    private void __unsetResourceCheckerManager() {
        this.__setresourceCheckerManager(null);
    }

    protected void transformConnector() throws ServiceException {
        if (!this.__MtransformConnector) {
            this.__transformConnector();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "transformConnector", new Object[0]);
            this.__transformConnector();
            this.__IM.onExit((Object)this, "transformConnector", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "transformConnector", throwable);
            throw throwable;
        }
    }

    private void __transformConnector() throws ServiceException {
        this.transformClass(CONNECTOR_CLASS_NAME, ConnectorTransformer.class);
    }

    protected void transformCoyoteAdaptor() throws ServiceException {
        if (!this.__MtransformCoyoteAdaptor) {
            this.__transformCoyoteAdaptor();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "transformCoyoteAdaptor", new Object[0]);
            this.__transformCoyoteAdaptor();
            this.__IM.onExit((Object)this, "transformCoyoteAdaptor", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "transformCoyoteAdaptor", throwable);
            throw throwable;
        }
    }

    private void __transformCoyoteAdaptor() throws ServiceException {
        this.transformClass(COYOTE_ADAPTER_CLASS_NAME, CoyoteAdapterTransformer.class);
    }

    protected void transformClass(String string, Class<? extends ClassVisitor> clazz) throws ServiceException {
        if (!this.__MtransformClass$java_lang_String$java_lang_Class) {
            this.__transformClass(string, clazz);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "transformClass$java_lang_String$java_lang_Class", new Object[]{string, clazz});
            this.__transformClass(string, clazz);
            this.__IM.onExit((Object)this, "transformClass$java_lang_String$java_lang_Class", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "transformClass$java_lang_String$java_lang_Class", throwable);
            throw throwable;
        }
    }

    private void __transformClass(String from, Class<? extends ClassVisitor> to) throws ServiceException {
        String resource = from.replace('.', '/').concat(".class");
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resource);
        if (null == inputStream) {
            throw new ServiceException("Cannot open stream to resource " + resource);
        }
        byte[] originalClass = null;
        try {
            originalClass = new byte[inputStream.available()];
            inputStream.read(originalClass);
        }
        catch (IOException e) {
            throw new ServiceException("Cannot read resource " + resource, (Throwable)e);
        }
        ClassReader cr = new ClassReader(originalClass);
        ClassWriter cw = new ClassWriter(cr, 0);
        try {
            Constructor<? extends ClassVisitor> co = to.getConstructor(ClassVisitor.class);
            ClassVisitor cv = co.newInstance(cw);
            cr.accept(cv, 0);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot get ClassVisitor constructor : " + to, (Throwable)e);
        }
        byte[] modifiedClass = cw.toByteArray();
        try {
            Class[] types = new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE};
            Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", types);
            Object[] args = new Object[]{from, modifiedClass, 0, modifiedClass.length};
            defineClassMethod.setAccessible(true);
            defineClassMethod.invoke((Object)classLoader, args);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot inject bytecode for class " + from, (Throwable)e);
        }
        logger.debug((Object)("transformClass for class " + from + " into " + to + " OK."), new Object[0]);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("transactionService")) {
                this.__FtransactionService = true;
            }
            if (set.contains("externalLoader")) {
                this.__FexternalLoader = true;
            }
            if (set.contains("reg2")) {
                this.__Freg2 = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("tomcatStarted")) {
                this.__FtomcatStarted = true;
            }
            if (set.contains("server")) {
                this.__Fserver = true;
            }
            if (set.contains("resourceCheckerManager")) {
                this.__FresourceCheckerManager = true;
            }
            if (set.contains("reg")) {
                this.__Freg = true;
            }
            if (set.contains("securityService")) {
                this.__FsecurityService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initCatalinaEnvironment")) {
                this.__MinitCatalinaEnvironment = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("startInternalWebContainer")) {
                this.__MstartInternalWebContainer = true;
            }
            if (set.contains("setWebEnvironment$javax_naming_Context$org_ow2_easybeans_deployment_api_EZBInjectionHolder$java_lang_ClassLoader")) {
                this.__MsetWebEnvironment$javax_naming_Context$org_ow2_easybeans_deployment_api_EZBInjectionHolder$java_lang_ClassLoader = true;
            }
            if (set.contains("isInternalContainerStarted")) {
                this.__MisInternalContainerStarted = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("doRegisterWar$javax_naming_Context")) {
                this.__MdoRegisterWar$javax_naming_Context = true;
            }
            if (set.contains("createContextConfig")) {
                this.__McreateContextConfig = true;
            }
            if (set.contains("createJOnASRealm$java_lang_String$boolean")) {
                this.__McreateJOnASRealm$java_lang_String$boolean = true;
            }
            if (set.contains("getConfiguredMatchingJonasContexts$java_lang_String$java_io_File$java_lang_String")) {
                this.__MgetConfiguredMatchingJonasContexts$java_lang_String$java_io_File$java_lang_String = true;
            }
            if (set.contains("checkStartedContext$org_apache_catalina_Context$org_ow2_jonas_web_base_lib_PermissionManager")) {
                this.__McheckStartedContext$org_apache_catalina_Context$org_ow2_jonas_web_base_lib_PermissionManager = true;
            }
            if (set.contains("getEngines")) {
                this.__MgetEngines = true;
            }
            if (set.contains("getContexts")) {
                this.__MgetContexts = true;
            }
            if (set.contains("doUnRegisterWar$javax_naming_Context")) {
                this.__MdoUnRegisterWar$javax_naming_Context = true;
            }
            if (set.contains("removeContext$org_apache_catalina_Context")) {
                this.__MremoveContext$org_apache_catalina_Context = true;
            }
            if (set.contains("isTomcatStarted")) {
                this.__MisTomcatStarted = true;
            }
            if (set.contains("setServer$org_apache_catalina_Server")) {
                this.__MsetServer$org_apache_catalina_Server = true;
            }
            if (set.contains("getServer")) {
                this.__MgetServer = true;
            }
            if (set.contains("getConfigFile")) {
                this.__MgetConfigFile = true;
            }
            if (set.contains("findHost$java_lang_String")) {
                this.__MfindHost$java_lang_String = true;
            }
            if (set.contains("createServerDigester")) {
                this.__McreateServerDigester = true;
            }
            if (set.contains("updateServerInfos")) {
                this.__MupdateServerInfos = true;
            }
            if (set.contains("getDefaultHost")) {
                this.__MgetDefaultHost = true;
            }
            if (set.contains("getDefaultHttpPort")) {
                this.__MgetDefaultHttpPort = true;
            }
            if (set.contains("getDefaultHttpsPort")) {
                this.__MgetDefaultHttpsPort = true;
            }
            if (set.contains("getPort$java_lang_String")) {
                this.__MgetPort$java_lang_String = true;
            }
            if (set.contains("getFirstService")) {
                this.__MgetFirstService = true;
            }
            if (set.contains("registerWar$java_lang_String")) {
                this.__MregisterWar$java_lang_String = true;
            }
            if (set.contains("unRegisterWar$java_lang_String")) {
                this.__MunRegisterWar$java_lang_String = true;
            }
            if (set.contains("setSecurityService$org_ow2_jonas_security_SecurityService")) {
                this.__MsetSecurityService$org_ow2_jonas_security_SecurityService = true;
            }
            if (set.contains("getSecurityService")) {
                this.__MgetSecurityService = true;
            }
            if (set.contains("setTransactionService$org_ow2_jonas_tm_TransactionService")) {
                this.__MsetTransactionService$org_ow2_jonas_tm_TransactionService = true;
            }
            if (set.contains("getTransactionService")) {
                this.__MgetTransactionService = true;
            }
            if (set.contains("getResourceCheckerManager")) {
                this.__MgetResourceCheckerManager = true;
            }
            if (set.contains("setResourceCheckerManager$org_ow2_jonas_jndi_checker_api_IResourceCheckerManager")) {
                this.__MsetResourceCheckerManager$org_ow2_jonas_jndi_checker_api_IResourceCheckerManager = true;
            }
            if (set.contains("unsetResourceCheckerManager")) {
                this.__MunsetResourceCheckerManager = true;
            }
            if (set.contains("transformConnector")) {
                this.__MtransformConnector = true;
            }
            if (set.contains("transformCoyoteAdaptor")) {
                this.__MtransformCoyoteAdaptor = true;
            }
            if (set.contains("transformClass$java_lang_String$java_lang_Class")) {
                this.__MtransformClass$java_lang_String$java_lang_Class = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

