/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.junit;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.plugin.Activator;
import aQute.bnd.plugin.Central;
import aQute.bnd.test.ProjectLauncher;
import aQute.lib.osgi.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;

public class OSGiJUnitLauncherConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        System.out.println("Verify Main TypeName");
        return "aQute.junit.runtime.Target";
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List vmArguments, List programArguments) throws CoreException {
        System.out.println("Collect Execution Arguments");
        try {
            File[] files;
            Object p;
            super.collectExecutionArguments(configuration, vmArguments, programArguments);
            IJavaProject javaProject = this.getJavaProject(configuration);
            Project model = Central.getCentral().getModel(javaProject);
            model.clear();
            File tmp = new File(model.getTarget(), "fwtmp");
            tmp.mkdirs();
            tmp.deleteOnExit();
            programArguments.add("-storage");
            programArguments.add(tmp.getAbsolutePath());
            Collection<Container> testpath = model.getRunpath();
            Container found = null;
            for (Container c : testpath) {
                String[] parts;
                String exports;
                if (c.getAttributes().containsKey("framework")) {
                    if (found != null) {
                        model.warning("Specifying multiple framework classes on the -runpath\nPrevious found: " + found.getProject() + " " + found.getAttributes() + "\n" + "Now found     : " + c.getProject() + " " + c.getAttributes());
                    }
                    programArguments.add("-framework");
                    programArguments.add(c.getAttributes().get("framework"));
                    found = c;
                }
                if ((exports = c.getAttributes().get("export")) == null) continue;
                String[] stringArray = parts = exports.split("\\s*,\\s*");
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    p = stringArray[n2];
                    programArguments.add("-export");
                    programArguments.add(p);
                    ++n2;
                }
            }
            p = files = model.build(true);
            int n = files.length;
            int exports = 0;
            while (exports < n) {
                File f = p[exports];
                programArguments.add("-target");
                programArguments.add(f.getAbsolutePath());
                ++exports;
            }
            Collection<Container> testbundles = model.getRunbundles();
            for (Container c : testbundles) {
                if (c.getError() != null) {
                    this.abort("Invalid bundle on -runbundles " + c.getError(), null, 4);
                }
                if (c.getVersion() != null && c.getVersion().equals("project")) {
                    File[] outputs;
                    Project sub = c.getProject();
                    sub.clear();
                    File[] fileArray = outputs = sub.build(false);
                    int n3 = outputs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = fileArray[n4];
                        programArguments.add("-bundle");
                        programArguments.add(f.getAbsolutePath());
                        ++n4;
                    }
                    model.getInfo(sub);
                    continue;
                }
                programArguments.add("-bundle");
                programArguments.add(c.getFile().getAbsolutePath());
            }
            programArguments.add("-verbose");
            if (configuration.getAttribute("aQute.bmaker.CLEARCACHE", false)) {
                programArguments.add("-keep");
            }
            this.report(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "osgi.eclipse.junit", "Building arguments for remote VM", (Throwable)e));
        }
    }

    private void report(Processor reporter) throws CoreException {
        StringBuilder sb = new StringBuilder();
        boolean abort = false;
        if (reporter.getErrors().size() > 0) {
            sb.append("Errors during build\n");
            for (String e : reporter.getErrors()) {
                sb.append(e);
                sb.append("\n");
            }
            abort = true;
        }
        if (reporter.getWarnings().size() > 0) {
            Activator.getDefault().warning(reporter.getWarnings());
            System.err.println("Warnings: ");
            for (String msg : reporter.getWarnings()) {
                System.err.println(msg);
            }
        }
        reporter.clear();
        if (abort) {
            this.abort(sb.toString(), null, 0);
        }
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        System.out.println("Get Class Pathx");
        try {
            IJavaProject javaProject = this.getJavaProject(configuration);
            Project model = Central.getCentral().getModel(javaProject);
            ArrayList<String> classpath = new ArrayList<String>();
            classpath.add(this.getRuntime().getAbsolutePath());
            for (Container c : model.getRunpath()) {
                if (c.getType() != Container.TYPE.ERROR) {
                    classpath.add(c.getFile().getAbsolutePath());
                    continue;
                }
                this.abort("Invalid entry on the -runpath: " + c, null, 4);
            }
            for (String s : classpath) {
                File f = new File(s);
                System.out.println("E: " + s + " " + new Date(f.lastModified()));
            }
            return classpath.toArray(new String[classpath.size()]);
        }
        catch (Exception e) {
            this.abort("Calculating class path", e, 4);
            return null;
        }
    }

    public File getRuntime() {
        return ProjectLauncher.getRuntime();
    }
}

