/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.popup.actions;

import aQute.bnd.plugin.Activator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallBundle
implements IObjectActionDelegate {
    IFile[] locations;

    public void run(IAction action) {
        Activator activator = Activator.getDefault();
        HashMap<String, Bundle> map = new HashMap<String, Bundle>();
        BundleContext context = activator.getBundle().getBundleContext();
        Bundle[] bundles = context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            map.put(bundles[i].getLocation(), bundles[i]);
            ++i;
        }
        if (this.locations != null) {
            ArrayList<Bundle> installed = new ArrayList<Bundle>();
            ArrayList<Bundle> updated = new ArrayList<Bundle>();
            int errors = 0;
            int i2 = 0;
            while (i2 < this.locations.length) {
                try {
                    File mf = this.locations[i2].getLocation().toFile();
                    String url = mf.toURL().toExternalForm();
                    Bundle b = (Bundle)map.get(url);
                    if (b != null) {
                        b.update();
                        updated.add(b);
                    } else {
                        b = context.installBundle(url);
                        installed.add(b);
                    }
                }
                catch (Exception e) {
                    ++errors;
                    Activator.getDefault().error("Error during install/update ", e);
                }
                ++i2;
            }
            if (!updated.isEmpty()) {
                ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
                if (ref != null) {
                    PackageAdmin packageAdmin = (PackageAdmin)context.getService(ref);
                    if (packageAdmin != null) {
                        packageAdmin.refreshPackages(updated.toArray(new Bundle[updated.size()]));
                    } else {
                        activator.error("Can't get Package Admin service to refresh", null);
                    }
                } else {
                    activator.error("No Package Admin to refresh", null);
                }
            }
            StringBuffer sb = new StringBuffer();
            this.printBundles("Installed Bundles", installed, sb);
            this.printBundles("Updated Bundles", updated, sb);
            switch (errors) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append("One Error\n");
                    break;
                }
                default: {
                    sb.append(errors);
                    sb.append(" Errors\n");
                }
            }
            activator.message(sb.toString());
        }
    }

    private void printBundles(String msg, List<Bundle> list, StringBuffer sb) {
        if (list.isEmpty()) {
            return;
        }
        sb.append(msg);
        sb.append('\n');
        for (Bundle b : list) {
            String name;
            String version = (String)b.getHeaders().get("Bundle-Version");
            if (version == null) {
                version = "0.0.0";
            }
            if ((name = b.getSymbolicName()) == null) {
                name = b.getLocation();
            }
            sb.append("  ");
            sb.append(name);
            int p = name.length();
            while (p < 20) {
                sb.append(" ");
                ++p;
            }
            sb.append("- ");
            sb.append(version);
            sb.append("\n");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.locations = this.getLocations(selection);
    }

    IFile[] getLocations(ISelection selection) {
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            IFile[] result = new IFile[ss.size()];
            int n = 0;
            Iterator i = ss.iterator();
            while (i.hasNext()) {
                result[n++] = (IFile)i.next();
            }
            return result;
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

