/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.felix.dependencymanager.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    protected final BundleContext context;
    protected final Filter filter;
    private Tracked tracked;
    private ServiceTrackerCustomizer customizer;

    public ServiceTracker(BundleContext context, ServiceReference reference, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.customizer = customizer == null ? this : customizer;
        try {
            this.filter = context.createFilter("(service.id=" + reference.getProperty("service.id").toString() + ")");
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public ServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.customizer = customizer == null ? this : customizer;
        try {
            this.filter = context.createFilter("(objectClass=" + clazz + ")");
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
    }

    public ServiceTracker(BundleContext context, Filter filter, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer = this.customizer = customizer == null ? this : customizer;
        if (context == null || filter == null) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() {
        if (this.tracked == null) {
            ServiceReference[] references;
            Tracked tracked = this.tracked = new Tracked(this.customizer, this.filter);
            synchronized (tracked) {
                this.context.addServiceListener((ServiceListener)this.tracked);
                try {
                    references = this.context.getServiceReferences(null, this.filter.toString());
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException("unexpected InvalidSyntaxException");
                }
            }
            if (references != null) {
                int size = references.length;
                for (int i = 0; i < size; ++i) {
                    ServiceReference reference = references[i];
                    if (reference.getBundle() == null) continue;
                    this.tracked.track(reference);
                }
            }
        }
    }

    public synchronized void close() {
        if (this.tracked != null) {
            this.tracked.close();
            ServiceReference[] references = this.getServiceReferences();
            Tracked outgoing = this.tracked;
            this.tracked = null;
            try {
                this.context.removeServiceListener((ServiceListener)outgoing);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (references != null) {
                for (int i = 0; i < references.length; ++i) {
                    outgoing.untrack(references[i]);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public Object addingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    public void addedService(ServiceReference ref, Object service) {
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object object) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked tracked = this.tracked;
            if (tracked == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(timeout);
                }
            }
            object = this.getService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int size = tracked.size();
            if (size == 0) {
                return null;
            }
            ServiceReference[] references = new ServiceReference[size];
            Enumeration trackedServiceRefs = tracked.keys();
            for (int i = 0; i < size; ++i) {
                references[i] = (ServiceReference)trackedServiceRefs.nextElement();
            }
            return references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int size = tracked.size();
            if (size == 0) {
                return null;
            }
            Object[] objects = new Object[size];
            Enumeration trackedServices = tracked.elements();
            for (int i = 0; i < size; ++i) {
                objects[i] = trackedServices.nextElement();
            }
            return objects;
        }
    }

    public ServiceReference getServiceReference() {
        int length;
        ServiceReference[] references = this.getServiceReferences();
        int n = length = references == null ? 0 : references.length;
        if (length > 0) {
            int index = 0;
            if (length > 1) {
                int[] rankings = new int[length];
                int count = 0;
                int maxRanking = Integer.MIN_VALUE;
                for (int i = 0; i < length; ++i) {
                    int ranking;
                    Object property = references[i].getProperty("service.ranking");
                    rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                    if (ranking > maxRanking) {
                        index = i;
                        maxRanking = ranking;
                        count = 1;
                        continue;
                    }
                    if (ranking != maxRanking) continue;
                    ++count;
                }
                if (count > 1) {
                    long minId = Long.MAX_VALUE;
                    for (int i = 0; i < length; ++i) {
                        long id;
                        if (rankings[i] != maxRanking || (id = ((Long)references[i].getProperty("service.id")).longValue()) >= minId) continue;
                        index = i;
                        minId = id;
                    }
                }
            }
            return references[index];
        }
        return null;
    }

    public Object getService(ServiceReference reference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        return tracked.get(reference);
    }

    public Object getService() {
        ServiceReference reference = this.getServiceReference();
        if (reference != null) {
            return this.getService(reference);
        }
        return null;
    }

    public void remove(ServiceReference reference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return;
        }
        tracked.untrack(reference);
    }

    public int size() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return 0;
        }
        return tracked.size();
    }

    public int getTrackingCount() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return -1;
        }
        return tracked.getTrackingCount();
    }

    static class Tracked
    extends Hashtable
    implements ServiceListener {
        private ServiceTrackerCustomizer customizer;
        private Filter filter;
        private Vector adding;
        private boolean closed;
        private int trackingCount;

        protected Tracked(ServiceTrackerCustomizer customizer, Filter filter) {
            this.customizer = customizer;
            this.filter = filter;
            this.closed = false;
            this.trackingCount = 0;
            this.adding = new Vector(10, 10);
        }

        protected void close() {
            this.closed = true;
        }

        protected int getTrackingCount() {
            return this.trackingCount;
        }

        public void serviceChanged(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    if (this.filter.match(reference)) {
                        this.track(reference);
                        break;
                    }
                    this.untrack(reference);
                    break;
                }
                case 4: {
                    this.untrack(reference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void track(ServiceReference reference) {
            Object object = this.get(reference);
            if (object != null) {
                this.customizer.modifiedService(reference, object);
                return;
            }
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.adding.indexOf(reference, 0) != -1) {
                    return;
                }
                this.adding.addElement(reference);
            }
            boolean becameUntracked = false;
            try {
                object = this.customizer.addingService(reference);
            }
            finally {
                boolean needToCallback = false;
                Tracked tracked2 = this;
                synchronized (tracked2) {
                    if (this.adding.removeElement(reference)) {
                        if (object != null) {
                            this.put(reference, object);
                            ++this.trackingCount;
                            this.notifyAll();
                            needToCallback = true;
                        }
                    } else {
                        becameUntracked = true;
                    }
                }
                if (needToCallback) {
                    this.customizer.addedService(reference, object);
                }
            }
            if (becameUntracked) {
                this.customizer.removedService(reference, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void untrack(ServiceReference reference) {
            Object object;
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.adding.removeElement(reference)) {
                    return;
                }
                object = this.remove(reference);
                if (object == null) {
                    return;
                }
                ++this.trackingCount;
            }
            this.customizer.removedService(reference, object);
        }
    }
}

