/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class HTTPResponse {
    private static Log logger = LogFactory.getLog(HTTPResponse.class);
    private static final String DEFAULT_STATUS_CODE = "HTTP/1.0 200 OK";
    static final String CRLF = "\r\n";
    private StringBuilder body = null;
    private String title = "Http/OnDemandProxy Service";
    private String statusCode = "HTTP/1.0 200 OK";
    private String contentType = "text/html; charset=ISO-8859-1";
    private byte[] bodyBytes = null;
    private boolean refresh = false;

    public HTTPResponse() {
        this(DEFAULT_STATUS_CODE);
    }

    public HTTPResponse(String statusCode) {
        this.statusCode = statusCode;
        this.body = new StringBuilder();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void println(String string) {
        this.body.append(string);
        this.body.append("\n");
    }

    public void print(String string) {
        this.body.append(string);
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public byte[] getContent() {
        StringBuilder bodyContent = new StringBuilder();
        bodyContent.append("<html><head>");
        if (this.refresh) {
            bodyContent.append("<meta http-equiv='refresh' content='1' />");
        }
        bodyContent.append("<title>");
        bodyContent.append(this.title);
        bodyContent.append("</title></head><body>");
        bodyContent.append(this.body.toString());
        bodyContent.append("</body></html>");
        StringBuilder headerContent = new StringBuilder();
        headerContent.append(this.statusCode);
        headerContent.append(CRLF);
        headerContent.append("Content-Type: ");
        headerContent.append(this.contentType);
        headerContent.append(CRLF);
        headerContent.append("Date: ");
        headerContent.append(new Date());
        headerContent.append(CRLF);
        headerContent.append("Cache-Control: no-cache");
        headerContent.append(CRLF);
        headerContent.append("Server: JOnAS/HttpOnDemand Proxy");
        headerContent.append(CRLF);
        headerContent.append("Content-Length: ");
        if (this.bodyBytes != null) {
            headerContent.append(this.bodyBytes.length);
        } else {
            headerContent.append(bodyContent.toString().getBytes().length);
        }
        headerContent.append(CRLF);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        if (this.bodyBytes != null) {
            try {
                byteArrayOutputStream.write(headerContent.toString().getBytes());
                byteArrayOutputStream.write(CRLF.getBytes());
                byteArrayOutputStream.write(this.bodyBytes);
            }
            catch (IOException e) {
                logger.error((Object)"Unable to write bytes", new Object[]{e});
            }
        } else {
            printStream.print(headerContent);
            printStream.print(CRLF);
            printStream.print(bodyContent);
        }
        byte[] messageBytes = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get bytes", e);
        }
        return messageBytes;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }
}

