/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base.proxy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.base.proxy.ContextInfo;
import org.ow2.jonas.web.base.proxy.HttpOnDemandProxyException;
import org.ow2.jonas.web.base.proxy.HttpSocketHandler;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpOnDemandProxy
implements Runnable {
    private static int counter = 0;
    private static Log logger = LogFactory.getLog(HttpOnDemandProxy.class);
    private BaseWebContainerService webContainerService;
    private int httpPortNumber = 0;
    private int redirectPortNumber = 0;
    private ServerSocket serverSocket = null;
    private boolean listeningClients = true;
    private Map<String, ContextInfo> contextMapping = new HashMap<String, ContextInfo>();

    public void run() {
        while (this.listeningClients) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                if (!this.listeningClients) break;
                logger.error((Object)"Unable to accept connections", new Object[]{e});
                continue;
            }
            if (socket == null) continue;
            HttpSocketHandler handler = null;
            try {
                handler = new HttpSocketHandler(this, socket);
            }
            catch (HttpOnDemandProxyException e) {
                logger.error((Object)"Unable to handle connection", new Object[]{e});
            }
            if (handler == null) continue;
            Thread thread = new Thread(handler);
            thread.setName(handler.getClass().getName() + "-" + counter++);
            thread.start();
        }
    }

    public void enable() throws HttpOnDemandProxyException {
        try {
            this.serverSocket = new ServerSocket(this.httpPortNumber);
        }
        catch (IOException e) {
            throw new ServiceException("Cannot use the given port number '" + this.httpPortNumber + "'.", (Throwable)e);
        }
        try {
            this.serverSocket.setReuseAddress(true);
        }
        catch (SocketException e) {
            throw new ServiceException("Cannot set setReuseAddress mode", (Throwable)e);
        }
        new Thread(this).start();
        logger.debug((Object)"Listening on ''{0}'' port number", new Object[]{this.httpPortNumber});
    }

    public void disable() throws HttpOnDemandProxyException {
        this.listeningClients = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            logger.error((Object)"Unable to close server socket", new Object[]{e});
        }
    }

    public int getHttpPortNumber() {
        return this.httpPortNumber;
    }

    public void setHttpPortNumber(int httpPortNumber) {
        this.httpPortNumber = httpPortNumber;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setWebContainerService(BaseWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    public BaseWebContainerService getWebContainerService() {
        return this.webContainerService;
    }

    public void startWebContainer() throws JWebContainerServiceException {
        this.webContainerService.startInternalWebContainer();
    }

    public int getRedirectPortNumber() {
        return this.redirectPortNumber;
    }

    public void setRedirectPortNumber(int redirectPortNumber) {
        this.redirectPortNumber = redirectPortNumber;
    }

    public boolean isAvailableContext(String context) {
        return this.contextMapping.get(context) != null;
    }

    public ContextInfo getContextInfo(String context) {
        return this.contextMapping.get(context);
    }

    public boolean isContextDeployed(String context) {
        ContextInfo contextInfo = this.contextMapping.get(context);
        return this.contextMapping.get(context) != null && this.webContainerService.isWarLoaded(contextInfo.getWarFile());
    }

    public void addWar(String warFile) throws HttpOnDemandProxyException {
        ContextInfo existingContextInfo;
        String contextRoot;
        File file;
        block14: {
            file = new File(warFile);
            if (!file.exists()) {
                throw new HttpOnDemandProxyException("The given war file '" + warFile + "' doesn't exists");
            }
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
            if (archive == null) {
                throw new HttpOnDemandProxyException("The given war file '" + warFile + "' is invalid");
            }
            contextRoot = null;
            try {
                Document document;
                InputStream is;
                URL webxml = archive.getResource("WEB-INF/jonas-web.xml");
                if (webxml == null) break block14;
                try {
                    is = webxml.openStream();
                }
                catch (IOException e) {
                    throw new HttpOnDemandProxyException("Cannot analyze the given war file", e);
                }
                try {
                    document = DocumentParser.getDocument((InputStream)is, (boolean)false, null);
                }
                catch (DocumentParserException e) {
                    throw new HttpOnDemandProxyException("Cannot analyze the given war file", e);
                }
                Element jonasWebAppElement = document.getDocumentElement();
                contextRoot = XMLUtils.getStringValueElement((Element)jonasWebAppElement, (String)"context-root");
                if ("/".equals(contextRoot)) {
                    contextRoot = "";
                }
            }
            catch (ArchiveException e) {
                throw new HttpOnDemandProxyException("Cannot get resource from war file", e);
            }
            finally {
                archive.close();
            }
        }
        if (contextRoot == null && (contextRoot = file.getName()).endsWith(".war")) {
            contextRoot = contextRoot.substring(0, contextRoot.length() - 4);
        }
        if ((existingContextInfo = this.contextMapping.get(contextRoot)) != null) {
            throw new HttpOnDemandProxyException("Cannot register the war File '" + warFile + "' with context '" + contextRoot + "' as it is already in use for the war File '" + existingContextInfo.getWarFile() + "'");
        }
        ContextInfo contextInfo = new ContextInfo();
        contextInfo.setWarFile(warFile);
        this.contextMapping.put(contextRoot, contextInfo);
        logger.debug((Object)"Registering war file ''{0}'' with context ''{1}''", new Object[]{warFile, contextRoot});
    }

    public void removeWar(String warFile) {
        Set<Map.Entry<String, ContextInfo>> entries = this.contextMapping.entrySet();
        String context = null;
        if (entries != null) {
            for (Map.Entry<String, ContextInfo> entry : entries) {
                if (!warFile.equals(entry.getValue().getWarFile())) continue;
                context = entry.getKey();
                break;
            }
        }
        if (context != null) {
            this.contextMapping.remove(context);
        }
        if (this.webContainerService.isWarLoaded(warFile)) {
            try {
                this.webContainerService.unRegisterWar(warFile);
            }
            catch (RemoteException e) {
                logger.error((Object)"Unable to remove the given war file", new Object[]{e});
            }
        }
        logger.debug((Object)"Unregistering war file ''{0}''", new Object[]{warFile});
    }
}

