/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.wrapper;

import java.util.StringTokenizer;

public class GenerateWrapperConf {
    String propertyName = null;
    int index = 1;

    void syntax() {
        System.err.println("syntax: GenerateWrapperConf [-d <delimiters>] [-i <indx>] property.name args");
        System.exit(1);
    }

    void syntax(String arg) {
        System.err.println("GenerateWrapperConf: unrecognized argument '" + arg + "'");
        this.syntax();
    }

    void syntax(Exception e) {
        System.err.println(e.toString());
        this.syntax();
    }

    void generateKey(String val) {
        System.out.println(this.propertyName + "." + this.index + "=" + val);
        ++this.index;
    }

    void run(String[] args) {
        int i;
        String delimiter = null;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            try {
                switch (args[i].charAt(1)) {
                    case '?': 
                    case 'h': {
                        GenerateWrapperConf.usage();
                    }
                    case 'd': {
                        delimiter = args[++i];
                        break;
                    }
                    case 'i': {
                        this.index = Integer.parseInt(args[++i]);
                        break;
                    }
                    default: {
                        this.syntax(args[i]);
                        break;
                    }
                }
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                this.syntax(args[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.syntax(e);
            }
        }
        if (args.length - i < 2) {
            this.syntax();
        }
        this.propertyName = args[i];
        ++i;
        if (delimiter == null) {
            while (i < args.length) {
                this.generateKey(args[i]);
                ++i;
            }
        } else {
            StringTokenizer st = new StringTokenizer(args[i], delimiter);
            while (st.hasMoreTokens()) {
                this.generateKey(st.nextToken());
            }
            ++i;
        }
        if (args.length - i > 0) {
            this.syntax();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            GenerateWrapperConf.usage();
        } else {
            new GenerateWrapperConf().run(args);
        }
    }

    private static void usage() {
        System.out.println("\nUsage: java org.objectweb.java.tools.GenerateWrapperConf [-h | -?]\n           [-d <delimiters>] [-i <index>] property.name args\n\n  -h or -? display this help message.\n  -d <delimiters> specifies a string of delimiters used to parse\n                  args into individual tokens.\n  -i <index>      specifies the initial index for generated property\n                  values.  The default value is 1.\n  property.name   specifies the property name to be generated.\n                  Property names for the individual tokens are formed\n                  as 'property.name.index' where 'index' is incremented\n                  for each token.\n  args            Either a single string to be parsed using StringTokenizer\n                  and the delimiter specified by the -d option.\n                  This form is used to process the CLASSPATH variable.\n\n                  Or, an array of strings to be processed as individual tokens.\n                  This form is used to process JAVA_OPTS style variables.\n");
        System.exit(1);
    }
}

