/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.MessageOutputStream;
import fr.dyade.aaa.util.BinaryDump;
import java.io.IOException;
import java.io.OutputStream;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class BufferedMessageOutputStream
extends MessageOutputStream {
    protected OutputStream out;

    public BufferedMessageOutputStream() throws IOException {
        this(8192);
    }

    public BufferedMessageOutputStream(int size) throws IOException {
        super(size);
    }

    private final void drain() throws IOException {
        if (BufferedMessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)("drain() - count=" + this.count + ", buf=" + BinaryDump.toHex(this.buf, 0, this.count)));
        }
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public final void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)b;
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.drain();
            if (BufferedMessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                BufferedMessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)("write(" + len + ')'));
            }
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.drain();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public final void flush() throws IOException {
        this.drain();
        this.out.flush();
    }
}

