/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.Session;

public final class BytesMessage
extends Message
implements javax.jms.BytesMessage {
    private transient ByteArrayOutputStream outputBuffer = null;
    private transient DataOutputStream outputStream = null;
    private transient DataInputStream inputStream = null;
    private transient boolean prepared = false;

    BytesMessage() {
        this.momMsg.type = 5;
        this.outputBuffer = new ByteArrayOutputStream();
        this.outputStream = new DataOutputStream(this.outputBuffer);
    }

    BytesMessage(Session sess, org.objectweb.joram.shared.messages.Message momMsg) {
        super(sess, momMsg);
        this.inputStream = new DataInputStream(new ByteArrayInputStream(momMsg.body));
    }

    public long getBodyLength() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't get not readable message's size.");
        }
        return this.momMsg.body.length;
    }

    public void clearBody() throws JMSException {
        try {
            if (!this.RObody) {
                this.outputStream.close();
                this.outputBuffer.close();
            } else {
                this.inputStream.close();
            }
            this.outputBuffer = new ByteArrayOutputStream();
            this.outputStream = new DataOutputStream(this.outputBuffer);
            super.clearBody();
            this.prepared = false;
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while closing the stream facilities.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.writeObject(new Boolean(value));
    }

    public void writeByte(byte value) throws JMSException {
        this.writeObject(new Byte(value));
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeObject(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.RObody) {
            throw new MessageNotWriteableException("Can't write a value as the message body is read-only.");
        }
        if (this.prepared) {
            this.prepared = false;
            this.outputBuffer = new ByteArrayOutputStream();
            this.outputStream = new DataOutputStream(this.outputBuffer);
        }
        try {
            this.outputStream.write(value, offset, length);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeChar(char value) throws JMSException {
        this.writeObject(new Character(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.writeObject(new Double(value));
    }

    public void writeFloat(float value) throws JMSException {
        this.writeObject(new Float(value));
    }

    public void writeInt(int value) throws JMSException {
        this.writeObject(new Integer(value));
    }

    public void writeLong(long value) throws JMSException {
        this.writeObject(new Long(value));
    }

    public void writeShort(short value) throws JMSException {
        this.writeObject(new Short(value));
    }

    public void writeUTF(String value) throws JMSException {
        this.writeObject(value);
    }

    public void writeObject(Object value) throws JMSException {
        block15: {
            if (this.RObody) {
                throw new MessageNotWriteableException("Can't write a value as the message body is read-only.");
            }
            if (value == null) {
                throw new NullPointerException("Forbidden null value.");
            }
            if (this.prepared) {
                this.prepared = false;
                this.outputBuffer = new ByteArrayOutputStream();
                this.outputStream = new DataOutputStream(this.outputBuffer);
            }
            try {
                if (value instanceof Boolean) {
                    this.outputStream.writeBoolean((Boolean)value);
                    break block15;
                }
                if (value instanceof Character) {
                    this.outputStream.writeChar(((Character)value).charValue());
                    break block15;
                }
                if (value instanceof Integer) {
                    this.outputStream.writeInt((Integer)value);
                    break block15;
                }
                if (value instanceof Short) {
                    this.outputStream.writeShort(((Short)value).shortValue());
                    break block15;
                }
                if (value instanceof Long) {
                    this.outputStream.writeLong((Long)value);
                    break block15;
                }
                if (value instanceof Float) {
                    this.outputStream.writeFloat(((Float)value).floatValue());
                    break block15;
                }
                if (value instanceof Double) {
                    this.outputStream.writeDouble((Double)value);
                    break block15;
                }
                if (value instanceof String) {
                    this.outputStream.writeUTF((String)value);
                    break block15;
                }
                if (value instanceof Byte) {
                    this.outputStream.writeByte(((Byte)value).intValue());
                    break block15;
                }
                if (value instanceof byte[]) {
                    this.outputStream.write((byte[])value);
                    break block15;
                }
                throw new MessageFormatException("Can't write non Java primitive type as a bytes array.");
            }
            catch (IOException ioE) {
                JMSException jE = new JMSException("Error while writing the value.");
                jE.setLinkedException((Exception)ioE);
                throw jE;
            }
        }
    }

    public boolean readBoolean() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readBoolean();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public byte readByte() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readByte();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public int readUnsignedByte() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readUnsignedByte();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public short readShort() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readShort();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public int readUnsignedShort() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readUnsignedShort();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public char readChar() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readChar();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public int readInt() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readInt();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public long readLong() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readLong();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public float readFloat() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readFloat();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public double readDouble() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readDouble();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        int counter = 0;
        try {
            for (int i = 0; i < value.length; ++i) {
                value[i] = this.inputStream.readByte();
                ++counter;
            }
        }
        catch (EOFException eofE) {
        }
        catch (IOException ioE) {
            JMSException jE = null;
            jE = new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
        if (counter == 0) {
            return -1;
        }
        return counter;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        if (length > value.length || length < 0) {
            throw new IndexOutOfBoundsException("Invalid length parameter: " + length);
        }
        int counter = 0;
        try {
            for (int i = 0; i < length; ++i) {
                value[i] = this.inputStream.readByte();
                ++counter;
            }
        }
        catch (EOFException eofE) {
        }
        catch (IOException ioE) {
            JMSException jE = null;
            jE = new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
        if (counter == 0) {
            return -1;
        }
        return counter;
    }

    public String readUTF() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readUTF();
        }
        catch (Exception e) {
            Object jE = null;
            if (e instanceof EOFException) {
                jE = new MessageEOFException("Unexpected end of bytes array.");
            } else if (e instanceof IOException) {
                jE = new JMSException("Could not read the bytes array.");
            }
            jE.setLinkedException(e);
            throw jE;
        }
    }

    public void reset() throws JMSException {
        try {
            if (!this.RObody) {
                this.outputStream.flush();
                this.momMsg.body = this.outputBuffer.toByteArray();
            } else {
                this.inputStream.close();
            }
            this.inputStream = new DataInputStream(new ByteArrayInputStream(this.momMsg.body));
            this.RObody = true;
        }
        catch (IOException iE) {
            JMSException jE = new JMSException("Error while manipulating the stream facilities.");
            jE.setLinkedException((Exception)iE);
            throw jE;
        }
    }

    protected void prepare() throws JMSException {
        super.prepare();
        try {
            if (!this.RObody) {
                this.outputStream.flush();
                this.momMsg.body = this.outputBuffer.toByteArray();
                this.prepared = true;
            }
        }
        catch (IOException exc) {
            MessageFormatException jExc = new MessageFormatException("The message body could not be serialized.");
            jExc.setLinkedException((Exception)exc);
            throw jExc;
        }
    }
}

