/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.util.Debug;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import org.objectweb.joram.client.jms.ConnectionMetaData;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.MultiSessionConsumer;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.client.jms.connection.Requestor;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CnxCloseRequest;
import org.objectweb.joram.shared.client.CnxConnectReply;
import org.objectweb.joram.shared.client.CnxConnectRequest;
import org.objectweb.joram.shared.client.CnxStartRequest;
import org.objectweb.joram.shared.client.CnxStopRequest;
import org.objectweb.joram.shared.client.ConsumerSubRequest;
import org.objectweb.joram.shared.excepts.SelectorException;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Connection
implements javax.jms.Connection {
    public static Logger logger = Debug.getLogger(Connection.class.getName());
    private RequestMultiplexer mtpx;
    private Requestor requestor;
    private ConnectionMetaData metaData = null;
    private AtomicCounter sessionsC;
    private AtomicCounter messagesC;
    private AtomicCounter subsC;
    String proxyId;
    private int key;
    private FactoryParameters factoryParameters;
    private int status;
    private Vector sessions;
    private Vector cconsumers;
    private Closer closer;
    private String stringImage = null;
    private int hashCode;

    public Connection(FactoryParameters factoryParameters, RequestChannel requestChannel) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Connection.<init>(" + factoryParameters + ',' + requestChannel + ')'));
        }
        this.factoryParameters = (FactoryParameters)factoryParameters.clone();
        this.mtpx = new RequestMultiplexer(this, requestChannel, factoryParameters.cnxPendingTimer);
        if (factoryParameters.multiThreadSync) {
            this.mtpx.setMultiThreadSync(factoryParameters.multiThreadSyncDelay, factoryParameters.multiThreadSyncThreshold);
        }
        this.requestor = new Requestor(this.mtpx);
        this.sessions = new Vector();
        this.cconsumers = new Vector();
        this.closer = new Closer();
        this.setStatus(0);
        CnxConnectRequest req = new CnxConnectRequest();
        CnxConnectReply rep = (CnxConnectReply)this.requestor.request(req);
        this.proxyId = rep.getProxyId();
        this.key = rep.getCnxKey();
        this.sessionsC = new AtomicCounter("c" + this.key + 's');
        this.messagesC = new AtomicCounter("ID:" + this.proxyId.substring(1) + 'c' + this.key + 'm');
        this.subsC = new AtomicCounter("c" + this.key + "sub");
        this.stringImage = "Cnx:" + this.proxyId + ':' + this.key;
        this.hashCode = this.stringImage.hashCode();
        this.mtpx.setDemultiplexerDaemonName(this.toString());
    }

    private final String newTrace(String trace) {
        return "Connection[" + this.proxyId + ':' + this.key + ']' + trace;
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".setStatus(" + Status.toString(status) + ')'));
        }
        this.status = status;
    }

    boolean isStopped() {
        return this.status == 0;
    }

    public String toString() {
        return this.stringImage;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof Connection && this.hashCode() == obj.hashCode() && this.toString().equals(obj.toString());
    }

    public final long getTxPendingTimer() {
        return this.factoryParameters.txPendingTimer;
    }

    public final boolean getImplicitAck() {
        return this.factoryParameters.implicitAck;
    }

    public final boolean getAsyncSend() {
        return this.factoryParameters.asyncSend;
    }

    public final int getQueueMessageReadMax() {
        return this.factoryParameters.queueMessageReadMax;
    }

    public final int getTopicAckBufferMax() {
        return this.factoryParameters.topicAckBufferMax;
    }

    public final int getTopicPassivationThreshold() {
        return this.factoryParameters.topicPassivationThreshold;
    }

    public final int getTopicActivationThreshold() {
        return this.factoryParameters.topicActivationThreshold;
    }

    public final String getOutLocalAddress() {
        return this.factoryParameters.outLocalAddress;
    }

    public final int getOutLocalPort() {
        return this.factoryParameters.outLocalPort;
    }

    protected final synchronized void checkClosed() throws IllegalStateException {
        if (this.status == 2 || this.mtpx.isClosed()) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
    }

    public synchronized ConnectionConsumer createConnectionConsumer(javax.jms.Destination dest, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".createConnectionConsumer(" + dest + ',' + selector + ',' + sessionPool + ',' + maxMessages + ')'));
        }
        this.checkClosed();
        return this.createConnectionConsumer(dest, null, selector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subName, String selector, ServerSessionPool sessPool, int maxMessages) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".createDurableConnectionConsumer(" + topic + ',' + subName + ',' + selector + ',' + sessPool + ',' + maxMessages + ')'));
        }
        this.checkClosed();
        if (subName == null) {
            throw new JMSException("Invalid subscription name: " + subName);
        }
        return this.createConnectionConsumer((javax.jms.Destination)topic, subName, selector, sessPool, maxMessages);
    }

    private synchronized ConnectionConsumer createConnectionConsumer(javax.jms.Destination dest, String subName, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        boolean durable;
        String targetName;
        boolean queueMode;
        this.checkClosed();
        try {
            Selector.checks(selector);
        }
        catch (SelectorException sE) {
            throw new InvalidSelectorException("Invalid selector syntax: " + sE);
        }
        if (sessionPool == null) {
            throw new JMSException("Invalid ServerSessionPool parameter: " + sessionPool);
        }
        if (maxMessages <= 0) {
            throw new JMSException("Invalid maxMessages parameter: " + maxMessages);
        }
        if (dest instanceof Queue) {
            queueMode = true;
            targetName = ((Destination)dest).getName();
            durable = false;
        } else {
            queueMode = false;
            if (subName == null) {
                targetName = this.nextSubName();
                durable = false;
            } else {
                targetName = subName;
                durable = true;
            }
            this.requestor.request(new ConsumerSubRequest(((Destination)dest).getName(), targetName, selector, false, durable, false));
        }
        MultiSessionConsumer msc = new MultiSessionConsumer(queueMode, durable, selector, targetName, sessionPool, this.factoryParameters.queueMessageReadMax, this.factoryParameters.topicActivationThreshold, this.factoryParameters.topicPassivationThreshold, this.factoryParameters.topicAckBufferMax, this.mtpx, this, maxMessages);
        msc.start();
        this.cconsumers.addElement(msc);
        return msc;
    }

    public synchronized javax.jms.Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".createSession(" + transacted + ',' + acknowledgeMode + ')'));
        }
        this.checkClosed();
        Session session = new Session(this, transacted, acknowledgeMode, this.mtpx);
        this.addSession(session);
        return session;
    }

    protected synchronized void addSession(Session session) {
        this.sessions.addElement(session);
        if (this.status == 1) {
            session.start();
        }
    }

    public synchronized void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.mtpx.setExceptionListener(listener);
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.mtpx.getExceptionListener();
    }

    public void setClientID(String clientID) throws JMSException {
        throw new IllegalStateException("ClientID is already set by the provider.");
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.proxyId;
    }

    public javax.jms.ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        if (this.metaData == null) {
            this.metaData = new ConnectionMetaData();
        }
        return this.metaData;
    }

    public synchronized void start() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".start()"));
        }
        this.checkClosed();
        if (this.status == 1) {
            return;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": starting..."));
        }
        for (int i = 0; i < this.sessions.size(); ++i) {
            Session session = (Session)this.sessions.elementAt(i);
            session.start();
        }
        this.mtpx.sendRequest(new CnxStartRequest());
        this.setStatus(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".stop()"));
        }
        this.checkClosed();
        Connection connection = this;
        synchronized (connection) {
            if (this.status == 0) {
                return;
            }
        }
        for (int i = 0; i < this.sessions.size(); ++i) {
            Session session = (Session)this.sessions.get(i);
            session.stop();
        }
        Connection connection2 = this;
        synchronized (connection2) {
            if (this.status == 0) {
                return;
            }
            this.requestor.request(new CnxStopRequest());
            this.setStatus(0);
        }
    }

    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".close()"));
        }
        this.closer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClose() {
        block15: {
            Connection connection = this;
            synchronized (connection) {
                if (this.status == 2) {
                    return;
                }
            }
            Vector sessionsToClose = (Vector)this.sessions.clone();
            this.sessions.clear();
            for (int i = 0; i < sessionsToClose.size(); ++i) {
                Session session = (Session)sessionsToClose.elementAt(i);
                try {
                    session.close();
                    continue;
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
            }
            Vector consumersToClose = (Vector)this.cconsumers.clone();
            this.cconsumers.clear();
            for (int i = 0; i < consumersToClose.size(); ++i) {
                MultiSessionConsumer consumer = (MultiSessionConsumer)consumersToClose.elementAt(i);
                try {
                    consumer.close();
                    continue;
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
            }
            try {
                CnxCloseRequest closeReq = new CnxCloseRequest();
                this.requestor.request(closeReq);
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block15;
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
        this.mtpx.close();
        Connection connection = this;
        synchronized (connection) {
            this.setStatus(2);
        }
    }

    public void cleanup() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".cleanup()"));
        }
        Vector sessionsToClose = (Vector)this.sessions.clone();
        this.sessions.clear();
        for (int i = 0; i < sessionsToClose.size(); ++i) {
            Session session = (Session)sessionsToClose.elementAt(i);
            try {
                session.close();
                continue;
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
        this.mtpx.cleanup();
    }

    String nextSessionId() {
        return this.sessionsC.nextValue();
    }

    String nextMessageId() {
        return this.messagesC.nextValue();
    }

    String nextSubName() {
        return this.subsC.nextValue();
    }

    synchronized void closeSession(Session session) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".closeSession(" + session + ')'));
        }
        this.sessions.removeElement(session);
    }

    synchronized void closeConnectionConsumer(MultiSessionConsumer cc) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".closeConnectionConsumer(" + cc + ')'));
        }
        this.cconsumers.removeElement(cc);
    }

    synchronized AbstractJmsReply syncRequest(AbstractJmsRequest request) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)this.newTrace(".syncRequest(" + request + ')'));
        }
        return this.requestor.request(request);
    }

    synchronized void checkConsumers(String agentId) throws JMSException {
        for (int i = 0; i < this.sessions.size(); ++i) {
            Session sess = (Session)this.sessions.elementAt(i);
            sess.checkConsumers(agentId);
        }
    }

    protected final RequestMultiplexer getRequestMultiplexer() {
        return this.mtpx;
    }

    class Closer {
        Closer() {
        }

        synchronized void close() {
            Connection.this.doClose();
        }
    }

    class AtomicCounter {
        long value = 0L;
        StringBuffer strbuf;
        int initial;

        AtomicCounter(String prefix) {
            this.strbuf = new StringBuffer(prefix.length() + 20);
            this.strbuf.append(prefix);
            this.initial = this.strbuf.length();
        }

        synchronized String nextValue() {
            this.strbuf.setLength(this.initial);
            this.strbuf.append(this.value++);
            return this.strbuf.toString();
        }
    }

    private static class Status {
        public static final int STOP = 0;
        public static final int START = 1;
        public static final int CLOSE = 2;
        private static final String[] names = new String[]{"STOP", "START", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

