/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.util.Debug;
import fr.dyade.aaa.util.ReliableTcpConnection;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.objectweb.joram.mom.proxies.ProxyMessage;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class IOControl {
    public static Logger logger = Debug.getLogger(IOControl.class.getName());
    private long inputCounter;
    private Socket sock;
    private NetOutputStream nos;
    private BufferedInputStream bis;
    private int windowSize = AgentServer.getInteger(ReliableTcpConnection.WINDOW_SIZE_PROP_NAME, ReliableTcpConnection.DEFAULT_WINDOW_SIZE);
    private int unackCounter = 0;

    public IOControl(Socket sock) throws IOException {
        this(sock, -1L);
    }

    public IOControl(Socket sock, long inputCounter) throws IOException {
        this.inputCounter = inputCounter;
        this.sock = sock;
        this.nos = new NetOutputStream(sock);
        this.bis = new BufferedInputStream(sock.getInputStream());
    }

    public synchronized void send(ProxyMessage msg) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("IOControl.send:" + msg));
        }
        try {
            this.nos.send(msg.getId(), msg.getAckId(), msg.getObject());
            this.unackCounter = 0;
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"IOControl.send", (Throwable)exc);
            }
            this.close();
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyMessage receive() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"IOControl.receive()");
        }
        try {
            while (true) {
                int len = StreamUtil.readIntFrom(this.bis);
                long messageId = StreamUtil.readLongFrom(this.bis);
                long ackId = StreamUtil.readLongFrom(this.bis);
                AbstractJmsRequest obj = (AbstractJmsRequest)AbstractJmsMessage.read(this.bis);
                if (messageId > this.inputCounter) {
                    this.inputCounter = messageId;
                    IOControl iOControl = this;
                    synchronized (iOControl) {
                        if (this.unackCounter < this.windowSize) {
                            ++this.unackCounter;
                        } else {
                            this.send(new ProxyMessage(-1L, messageId, null));
                        }
                    }
                    return new ProxyMessage(messageId, ackId, obj);
                }
                logger.log(BasicLevel.DEBUG, (Object)("IOControl.receive: already received message: " + messageId + " -> " + obj));
            }
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"IOControl.receive", (Throwable)exc);
            }
            this.close();
            throw exc;
        }
    }

    public void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"IOControl.close()");
        }
        try {
            if (this.bis != null) {
                this.bis.close();
            }
            this.bis = null;
        }
        catch (IOException exc) {
            // empty catch block
        }
        try {
            if (this.sock != null) {
                this.sock.getOutputStream().close();
            }
        }
        catch (IOException exc) {
            // empty catch block
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
            this.sock = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class NetOutputStream
    extends ByteArrayOutputStream {
        private OutputStream os = null;

        NetOutputStream(Socket sock) throws IOException {
            super(1024);
            this.reset();
            this.os = sock.getOutputStream();
        }

        public void reset() {
            this.count = 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(long id, long ackId, AbstractJmsMessage msg) throws IOException {
            try {
                StreamUtil.writeTo(id, (OutputStream)this);
                StreamUtil.writeTo(ackId, (OutputStream)this);
                AbstractJmsMessage.write(msg, this);
                this.buf[0] = (byte)(this.count - 4 >>> 24);
                this.buf[1] = (byte)(this.count - 4 >>> 16);
                this.buf[2] = (byte)(this.count - 4 >>> 8);
                this.buf[3] = (byte)(this.count - 4 >>> 0);
                this.writeTo(this.os);
                this.os.flush();
                Object var7_4 = null;
                this.reset();
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                this.reset();
                throw throwable;
            }
        }
    }
}

