/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.ManagementException;
import org.ow2.jonas.lib.management.extensions.base.mbean.J2EEObjectNames;

public class LocalManagementContext {
    private static LocalManagementContext unique = null;
    private String domainName = null;
    private String serverName = null;
    private MBeanServer mbeanServer = null;

    public static synchronized LocalManagementContext getInstance() {
        if (unique == null) {
            unique = new LocalManagementContext();
        }
        return unique;
    }

    private LocalManagementContext() throws ManagementException {
        try {
            ArrayList<MBeanServer> mbeanServersList = MBeanServerFactory.findMBeanServer(null);
            if (mbeanServersList.isEmpty()) {
                throw new ManagementException("No MBean server found in JVM.");
            }
            for (MBeanServer mbeanServer : mbeanServersList) {
                ObjectName j2eeServerOns;
                Set<ObjectName> ons = mbeanServer.queryNames(j2eeServerOns = J2EEObjectNames.getJ2EEServerObjectNames(), null);
                Iterator<ObjectName> onit = ons.iterator();
                if (!onit.hasNext()) continue;
                ObjectName on = onit.next();
                this.domainName = on.getDomain();
                this.serverName = on.getKeyProperty("name");
                this.mbeanServer = mbeanServer;
            }
        }
        catch (SecurityException se) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.domainName == null || this.serverName == null) {
            throw new ManagementException("Couldn't initialize server or domain name");
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }
}

