/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.clusterdaemon;

import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.base.ManagementException;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.extensions.clusterdaemon.api.IClusterdaemon;

public class ClusterdaemonManagement
extends BaseManagement
implements IClusterdaemon {
    private static final String state = "State";
    private static final String controlledServersNames = "ControlledServersNames";
    private static final String runningState = "RUNNING";

    private ObjectName getClusterdaemonOn(String clusterdaemonName) {
        String domain = this.getDomainName();
        ObjectName clusterdaemonOn = null;
        try {
            clusterdaemonOn = JonasObjectName.clusterDaemonProxy((String)domain, (String)clusterdaemonName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return clusterdaemonOn;
    }

    public String getClusterdaemonState(String clusterdaemonName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        String clusterdaemonState = null;
        try {
            clusterdaemonState = (String)JonasManagementRepr.getAttribute(clusterdaemonOn, state, this.getServerName());
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot get state for cluster daemon " + clusterdaemonName + " :" + e), new Object[0]);
        }
        return clusterdaemonState;
    }

    public boolean isRunning(String clusterdaemonName) {
        boolean result = false;
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        try {
            String clusterdaemonState = (String)JonasManagementRepr.getAttribute(clusterdaemonOn, state, this.getServerName());
            if (runningState.equals(clusterdaemonState)) {
                result = true;
            }
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot get state for cluster daemon " + clusterdaemonName + " :" + e), new Object[0]);
        }
        return result;
    }

    public String[] getControlledServersNames(String clusterdaemonName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        ArrayList servers = new ArrayList();
        try {
            servers = (ArrayList)JonasManagementRepr.getAttribute(clusterdaemonOn, controlledServersNames, this.getServerName());
            if (servers == null) {
                return new String[0];
            }
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot get controlled server names for cluster daemon " + clusterdaemonName + " :" + e), new Object[0]);
            return null;
        }
        String[] controlledServers = new String[servers.size()];
        for (int i = 0; i < servers.size(); ++i) {
            controlledServers[i] = (String)servers.get(i);
        }
        return controlledServers;
    }

    public boolean startServer(String clusterdaemonName, String serverName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        Boolean result = null;
        String opName = "startServer";
        Object[] opParams = new String[2];
        String[] opSignature = new String[]{"java.lang.String", "java.lang.String"};
        opParams[0] = serverName;
        opParams[1] = null;
        try {
            result = (Boolean)JonasManagementRepr.invoke(clusterdaemonOn, opName, opParams, opSignature, this.getServerName());
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot start server " + serverName + " by cluster daemon " + clusterdaemonName + " :" + e), new Object[0]);
            return false;
        }
        return result;
    }

    public boolean stopServer(String clusterdaemonName, String serverName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        Boolean result = null;
        String opName = "stopServer";
        Object[] opParams = new String[2];
        String[] opSignature = new String[]{"java.lang.String", "java.lang.String"};
        opParams[0] = serverName;
        opParams[1] = null;
        try {
            result = (Boolean)JonasManagementRepr.invoke(clusterdaemonOn, opName, opParams, opSignature, this.getServerName());
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot stop server " + serverName + " by cluster daemon " + clusterdaemonName + " :" + e), new Object[0]);
            return false;
        }
        return result;
    }
}

