/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class Logger {
    public static final String IPOJO_LOG_LEVEL = "ipojo.log.level";
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private BundleContext m_context;
    private String m_name;
    private int m_level;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public Logger(BundleContext context, String name, int level) {
        this.m_name = name;
        this.m_level = level;
        this.m_context = context;
    }

    public Logger(BundleContext context, String name) {
        this(context, name, Logger.getDefaultLevel(context));
    }

    public void log(int level, String msg) {
        if (this.m_level >= level) {
            this.dispatch(level, msg);
        }
    }

    public void log(int level, String msg, Throwable exception) {
        if (this.m_level >= level) {
            this.dispatch(level, msg, exception);
        }
    }

    private void dispatch(int level, String msg) {
        LogService log = null;
        ServiceReference ref = null;
        try {
            ref = this.m_context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            if (ref != null) {
                log = (LogService)this.m_context.getService(ref);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        String message = null;
        switch (level) {
            case 4: {
                message = "[DEBUG] " + this.m_name + " : " + msg;
                if (log != null) {
                    log.log(4, message);
                    break;
                }
                System.err.println(message);
                break;
            }
            case 1: {
                message = "[ERROR] " + this.m_name + " : " + msg;
                if (log != null) {
                    log.log(1, message);
                    break;
                }
                System.err.println(message);
                break;
            }
            case 3: {
                message = "[INFO] " + this.m_name + " : " + msg;
                if (log != null) {
                    log.log(3, message);
                    break;
                }
                System.err.println(message);
                break;
            }
            case 2: {
                message = "[WARNING] " + this.m_name + " : " + msg;
                if (log != null) {
                    log.log(2, message);
                    break;
                }
                System.err.println(message);
                break;
            }
            default: {
                message = "[UNKNOWN] " + this.m_name + " : " + msg;
                System.err.println(message);
            }
        }
        if (log != null) {
            this.m_context.ungetService(ref);
        }
    }

    private void dispatch(int level, String msg, Throwable exception) {
        LogService log = null;
        ServiceReference ref = null;
        try {
            ref = this.m_context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            if (ref != null) {
                log = (LogService)this.m_context.getService(ref);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        String message = null;
        switch (level) {
            case 4: {
                message = "[DEBUG] " + this.m_name + " : " + msg;
                if (log != null) {
                    log.log(4, message, exception);
                    break;
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            case 1: {
                message = "[ERROR] " + this.m_name + " : " + msg;
                if (log != null) {
                    log.log(1, message, exception);
                    break;
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            case 3: {
                message = "[INFO] " + this.m_name + " : " + msg;
                if (log != null) {
                    log.log(3, message, exception);
                    break;
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            case 2: {
                message = "[WARNING] " + this.m_name + " : " + msg;
                if (log != null) {
                    log.log(2, message, exception);
                    break;
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            default: {
                message = "[UNKNOWN] " + this.m_name + " : " + msg;
                System.err.println(message);
                exception.printStackTrace();
            }
        }
        if (log != null) {
            this.m_context.ungetService(ref);
        }
    }

    private static int getDefaultLevel(BundleContext context) {
        String level = context.getProperty(IPOJO_LOG_LEVEL);
        if (level == null) {
            String key = IPOJO_LOG_LEVEL.replace('.', '-');
            level = (String)context.getBundle().getHeaders().get(key);
        }
        if (level != null) {
            if (level.equalsIgnoreCase("info")) {
                return 3;
            }
            if (level.equalsIgnoreCase("debug")) {
                return 4;
            }
            if (level.equalsIgnoreCase("warning")) {
                return 2;
            }
            if (level.equalsIgnoreCase("error")) {
                return 1;
            }
        }
        return 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

