/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.maven2;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public final class Maven2Utils {
    private Maven2Utils() {
    }

    public static String getMaven2Location(String repository, String groupId, String artifactId, String version, String classifier, String type) {
        String appendedClassifier = "";
        if (classifier != null) {
            appendedClassifier = appendedClassifier.concat("-").concat(classifier);
        }
        String path = Maven2Utils.constructDirectoryPath(groupId, artifactId, version);
        String location = repository.concat("/").concat(path.concat("/").concat(artifactId).concat("-").concat(version).concat(appendedClassifier).concat(".").concat(type));
        return location;
    }

    public static File getMaven2File(String repository, String groupId, String artifactId, String version, String classifier, String type) {
        return new File(Maven2Utils.getMaven2Location(repository, groupId, artifactId, version, classifier, type));
    }

    public static URL getMaven2URL(String repository, String groupId, String artifactId, String version, String classifier, String type) throws MalformedURLException {
        return new URL(Maven2Utils.getMaven2Location(repository, groupId, artifactId, version, classifier, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readChecksum(InputStream inputStream) throws IOException {
        String checksum = "";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            checksum = bufferedReader.readLine().trim();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.reset();
                    bufferedReader.close();
                }
                catch (IOException e) {}
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.read();
                    inputStreamReader.close();
                }
                catch (IOException e) {}
            }
        }
        return checksum;
    }

    private static String constructDirectoryPath(String groupId, String artifactId, String version) {
        String transformed = groupId.replace('.', '/');
        return transformed.concat("/").concat(artifactId).concat("/").concat(version);
    }
}

