/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.client.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.easybeans.resolver.api.EZBJNDIBeanData;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.easybeans.resolver.api.EZBRemoteJNDIResolver;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.client.AppClientDTDs;
import org.ow2.jonas.deployment.client.AppClientSchemas;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDesc;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDescException;
import org.ow2.jonas.deployment.client.JonasAppClientDTDs;
import org.ow2.jonas.deployment.client.JonasAppClientSchemas;
import org.ow2.jonas.deployment.client.rules.ApplicationClientRuleSet;
import org.ow2.jonas.deployment.client.rules.JonasClientRuleSet;
import org.ow2.jonas.deployment.client.xml.ApplicationClient;
import org.ow2.jonas.deployment.client.xml.JonasClient;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.deployment.common.xml.EjbRef;
import org.ow2.jonas.deployment.common.xml.JonasEjbRef;
import org.ow2.jonas.deployment.common.xml.JonasMessageDestination;
import org.ow2.jonas.deployment.common.xml.JonasResource;
import org.ow2.jonas.deployment.common.xml.JonasServiceRef;
import org.ow2.jonas.deployment.common.xml.MessageDestinationRef;
import org.ow2.jonas.deployment.common.xml.PersistenceUnitRef;
import org.ow2.jonas.deployment.common.xml.ResourceRef;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentRefDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDesc;
import org.ow2.jonas.deployment.ws.lib.WSDeploymentDescManager;
import org.ow2.jonas.lib.loader.WebappClassLoader;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.ee.metadata.car.api.ICarDeployableMetadata;
import org.ow2.util.ee.metadata.car.impl.CarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.car.impl.enc.CarENCBindingBuilder;
import org.ow2.util.ee.metadata.common.api.enc.IENCBinding;
import org.ow2.util.ee.metadata.common.api.enc.IENCBindingHolder;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingException;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingHolder;
import org.ow2.util.url.URLUtils;

public class ClientDeploymentDescManager
extends AbsDeploymentDescManager {
    private static ClientDeploymentDescManager unique;
    private EjbDeploymentDescManager ejbDDManager = EjbDeploymentDescManager.getInstance();
    private Hashtable earCLAltDDBindings = new Hashtable();
    public static final String CLIENT_FILE_NAME = "META-INF/application-client.xml";
    public static final String JONAS_CLIENT_FILE_NAME = "META-INF/jonas-client.xml";
    private static JDigester appClientDigester;
    private static JDigester jonasAppClientDigester;
    private static boolean parsingWithValidation;
    private static ApplicationClientRuleSet appClientRuleSet;
    private static JonasClientRuleSet jonasAppClientRuleSet;
    private static Logger logger;

    private ClientDeploymentDescManager() {
    }

    public static ClientDeploymentDescManager getInstance() {
        if (unique == null) {
            unique = new ClientDeploymentDescManager();
        }
        return unique;
    }

    public ClientContainerDeploymentDesc getDeploymentDesc(URL url, ClassLoader loaderForCls, ClassLoader earLoader) throws DeploymentDescException {
        if (!URLUtils.urlToFile((URL)url).exists()) {
            String err = "Cannot get the deployment descriptor for ";
            err = err + "'" + url.getFile() + "'. The file doesn't exist.";
            throw new ClientContainerDeploymentDescException(err);
        }
        URL altDDUrl = null;
        Hashtable urlAltddBindings = null;
        if (earLoader != null) {
            urlAltddBindings = (Hashtable)this.earCLAltDDBindings.get(earLoader);
            if (urlAltddBindings == null) {
                String err = "Cannot find if there is alt-dd for '" + url.getFile() + "', the setAltDD function was badly called";
                throw new ClientContainerDeploymentDescException(err);
            }
            altDDUrl = (URL)urlAltddBindings.get(url);
        }
        ClientContainerDeploymentDesc clientDD = null;
        try {
            clientDD = altDDUrl != null ? ClientDeploymentDescManager.getInstance(URLUtils.urlToFile((URL)url).getPath(), loaderForCls, altDDUrl.getFile()) : ClientDeploymentDescManager.getInstance(URLUtils.urlToFile((URL)url).getPath(), loaderForCls);
        }
        catch (DeploymentDescException dde) {
            throw new ClientContainerDeploymentDescException(dde);
        }
        EjbRefDesc[] ejbRef = clientDD.getEjbRefDesc();
        for (int i = 0; i < ejbRef.length; ++i) {
            String jndiName;
            block21: {
                if (ejbRef[i].getJndiName() != null) continue;
                String ejbLink = ejbRef[i].getEjbLink();
                String ejbRefType = ejbRef[i].getEjbRefType();
                String home = ejbRef[i].getHome();
                String remote = ejbRef[i].getRemote();
                if (ejbLink == null) continue;
                if (earLoader == null) {
                    throw new ClientContainerDeploymentDescException("Ejb-link is not authorized from a single client jar. The client jar must be in an ear.");
                }
                jndiName = null;
                try {
                    jndiName = this.getJndiName(url, ejbLink, earLoader, ejbRefType);
                }
                catch (DeploymentDescException e) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"Unable to get JNDI name with the EJB DD manager", (Throwable)e);
                    }
                    EZBRemoteJNDIResolver jndiResolver = null;
                    Object o = null;
                    try {
                        o = new InitialContext().lookup("EZB_Remote_JNDIResolver");
                    }
                    catch (NamingException ne) {
                        logger.log(BasicLevel.DEBUG, (Object)"No Remote EJB3 JNDI Resolver found");
                        throw e;
                    }
                    jndiResolver = (EZBRemoteJNDIResolver)PortableRemoteObject.narrow((Object)o, EZBRemoteJNDIResolver.class);
                    String interfaceName = remote;
                    if (home != null && !"".equals(home)) {
                        interfaceName = home;
                    }
                    String beanName = ejbLink;
                    List jndiDataList = null;
                    try {
                        jndiDataList = jndiResolver.getEJBJNDINames(interfaceName, beanName);
                    }
                    catch (RemoteException re) {
                        throw new DeploymentDescException("Unable to get EJB-LINK for interface'" + interfaceName + "' and beanName'" + beanName + "'", re);
                    }
                    if (jndiDataList.size() == 0) {
                        throw new DeploymentDescException("Unable to get EJB-LINK for interface'" + interfaceName + "' and beanName'" + beanName + "', no data was found on the remote side.");
                    }
                    if (jndiDataList.size() > 1) {
                        throw new DeploymentDescException("Unable to get EJB-LINK for interface'" + interfaceName + "' and beanName'" + beanName + "', too many answers : '" + jndiDataList + "'.");
                    }
                    EZBJNDIBeanData jndiData = (EZBJNDIBeanData)jndiDataList.get(0);
                    jndiName = jndiData.getName();
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block21;
                    logger.log(BasicLevel.DEBUG, (Object)("Found JNDI Name '" + jndiName + "' for interface'" + interfaceName + "' and beanName'" + beanName + "', too many answers : '" + jndiDataList + "'."));
                }
            }
            ejbRef[i].setJndiName(jndiName);
        }
        IServiceRefDesc[] serviceRef = clientDD.getServiceRefDesc();
        for (int i = 0; i < serviceRef.length; ++i) {
            List pcRefs = serviceRef[i].getPortComponentRefs();
            for (int j = 0; j < pcRefs.size(); ++j) {
                PortComponentRefDesc pcr = (PortComponentRefDesc)pcRefs.get(j);
                String pclink = pcr.getPortComponentLink();
                if (pclink == null) continue;
                PortComponentDesc pcDesc = this.getPCDesc(url, pclink, earLoader);
                pcr.setPortComponentDesc(pcDesc);
            }
        }
        MessageDestinationRefDesc[] mdRef = clientDD.getMessageDestinationRefDesc();
        for (int i = 0; i < mdRef.length; ++i) {
            if (mdRef[i].getJndiName() != null) continue;
            String jndiName = mdRef[i].getJndiName();
            String mdLink = mdRef[i].getMessageDestinationLink();
            String mdType = mdRef[i].getMessageDestinationType();
            String mdUsage = mdRef[i].getMessageDestinationUsage();
            if (mdLink == null) continue;
            if (earLoader == null) {
                throw new ClientContainerDeploymentDescException("Message-destination-link is not authorized from a single client jar. The client jar must be in an ear.");
            }
            jndiName = this.getMDJndiName(url, mdLink, mdType, mdUsage, earLoader);
            mdRef[i].setJndiName(jndiName);
        }
        return clientDD;
    }

    private PortComponentDesc getPCDesc(URL warURL, String pcLink, ClassLoader earLoader) throws DeploymentDescException {
        String moduleLink = null;
        String pcNameLink = null;
        if (pcLink.toLowerCase().indexOf(".war#") == -1 && pcLink.toLowerCase().indexOf(".jar#") == -1) {
            String err = "PC-link " + pcLink + " has a bad format. Correct format :  filename.(jar|war)#portComponentName";
            throw new DeploymentDescException(err);
        }
        StringTokenizer st = new StringTokenizer(pcLink, "#");
        if (st.countTokens() != 2 || pcLink.startsWith("#") || pcLink.endsWith("#")) {
            String err = "PC-link " + pcLink + " has a bad format. Correct format :  filename.[jar or war]#portComponentName";
            throw new DeploymentDescException(err);
        }
        moduleLink = st.nextToken();
        pcNameLink = st.nextToken();
        URL moduleLinkUrl = null;
        try {
            moduleLinkUrl = new File(URLUtils.urlToFile((URL)warURL).getParent() + File.separator + moduleLink).getCanonicalFile().toURL();
        }
        catch (MalformedURLException mue) {
            String err = "Error when creating an url for the module filename. Error :" + mue.getMessage();
            throw new DeploymentDescException(err);
        }
        catch (IOException ioe) {
            String err = "Error when creating/accessing a file. Error :" + ioe.getMessage();
            throw new DeploymentDescException(err);
        }
        if (!new File(moduleLinkUrl.getFile()).exists()) {
            String err = "Cannot get the deployment descriptor for '" + moduleLinkUrl.getFile() + "'. The file doesn't exist.";
            throw new DeploymentDescException(err);
        }
        ClassLoader loaderForCls = null;
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (moduleLink.toLowerCase().endsWith(".war")) {
            try {
                loaderForCls = new WebappClassLoader(moduleLinkUrl, current);
            }
            catch (IOException ioe) {
                throw new DeploymentDescException("Unable to create Web ClassLoader", ioe);
            }
        } else {
            loaderForCls = current;
        }
        WSDeploymentDesc wsDD = null;
        try {
            wsDD = WSDeploymentDescManager.getInstance().getDeploymentDesc(moduleLinkUrl, loaderForCls, earLoader);
        }
        catch (DeploymentDescException e) {
            String err = "Cannot get the deployment descriptor for '" + moduleLinkUrl.getFile() + "'.";
            throw new DeploymentDescException(err, e);
        }
        if (wsDD == null) {
            String err = "Port component link " + pcNameLink + " not found in " + moduleLinkUrl.getFile();
            throw new DeploymentDescException(err);
        }
        List sdl = wsDD.getServiceDescs();
        boolean isFound = false;
        PortComponentDesc pcd = null;
        for (int i = 0; i < sdl.size() && !isFound; ++i) {
            if (sdl.get(i) == null) continue;
            pcd = ((ServiceDesc)sdl.get(i)).getPortComponent(pcNameLink);
            isFound = pcd != null;
        }
        if (!isFound) {
            String err = "the port component link " + pcNameLink + " doesn't exist in " + moduleLinkUrl.getFile();
            throw new DeploymentDescException(err);
        }
        return pcd;
    }

    public static ClientContainerDeploymentDesc getInstance(String clientFileName, ClassLoader classLoaderForCls) throws DeploymentDescException {
        return ClientDeploymentDescManager.getInstance(clientFileName, classLoaderForCls, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static ClientContainerDeploymentDesc getInstance(String clientFileName, ClassLoader classLoaderForCls, String altClientXmlFilename) throws DeploymentDescException {
        clientFile = null;
        applicationClientInputStream /* !! */  = null;
        jonasClientInputStream = null;
        applicationClientZipEntry = null;
        jonasClientZipEntry = null;
        xmlContent = "";
        jonasXmlContent = "";
        fClient = new File(clientFileName);
        if (!fClient.exists()) {
            err = "' " + clientFileName + "' was not found.";
            throw new ClientContainerDeploymentDescException(err);
        }
        if (altClientXmlFilename != null && !new File(altClientXmlFilename).exists()) {
            err = "The file for the altdd tag for the EAR case '" + altClientXmlFilename + "' was not found.";
            throw new ClientContainerDeploymentDescException(err);
        }
        if (altClientXmlFilename == null) {
            try {
                clientFile = new JarFile(clientFileName);
                applicationClientZipEntry = clientFile.getEntry("META-INF/application-client.xml");
                if (applicationClientZipEntry == null) ** GOTO lbl47
                applicationClientInputStream /* !! */  = clientFile.getInputStream(applicationClientZipEntry);
                xmlContent = ClientDeploymentDescManager.xmlContent(applicationClientInputStream /* !! */ );
                applicationClientInputStream /* !! */  = clientFile.getInputStream(applicationClientZipEntry);
            }
            catch (Exception e) {
                if (clientFile != null) {
                    try {
                        clientFile.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw new ClientContainerDeploymentDescException("Can not read the XML deployment descriptors of the client jar file '" + clientFileName + "'.", e);
            }
        } else {
            try {
                applicationClientInputStream /* !! */  = new FileInputStream(altClientXmlFilename);
                xmlContent = ClientDeploymentDescManager.xmlContent(applicationClientInputStream /* !! */ );
                applicationClientInputStream /* !! */  = new FileInputStream(altClientXmlFilename);
            }
            catch (FileNotFoundException ioe) {
                throw new ClientContainerDeploymentDescException("The altDD file '" + altClientXmlFilename + "' was not found.");
            }
            catch (Exception e) {
                if (applicationClientInputStream /* !! */  != null) {
                    try {
                        applicationClientInputStream /* !! */ .close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw new ClientContainerDeploymentDescException("Cannot read the XML deployment descriptors of the client jar file '" + clientFileName + "'.", e);
            }
        }
lbl47:
        // 3 sources

        applicationClient = applicationClientInputStream /* !! */  != null ? ClientDeploymentDescManager.loadApplicationClient(new InputStreamReader(applicationClientInputStream /* !! */ ), "META-INF/application-client.xml") : new ApplicationClient();
        try {
            clientFile = new JarFile(clientFileName);
            jonasClientZipEntry = clientFile.getEntry("META-INF/jonas-client.xml");
            if (jonasClientZipEntry != null) {
                jonasClientInputStream = clientFile.getInputStream(jonasClientZipEntry);
                jonasXmlContent = ClientDeploymentDescManager.xmlContent(jonasClientInputStream);
                jonasClientInputStream = clientFile.getInputStream(jonasClientZipEntry);
            }
        }
        catch (Exception e) {
            if (clientFile != null) {
                try {
                    clientFile.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            throw new ClientContainerDeploymentDescException("Can not read the XML deployment descriptors of the client jar file '" + clientFileName + "'.", e);
        }
        if (jonasClientInputStream != null) {
            jonasClient = ClientDeploymentDescManager.loadJonasClient(new InputStreamReader(jonasClientInputStream), "META-INF/jonas-client.xml");
            try {
                jonasClientInputStream.close();
            }
            catch (IOException e) {}
        } else {
            jonasClient = new JonasClient();
        }
        carDeployableMetadata = ClientDeploymentDescManager.getCarMetadata(clientFileName, classLoaderForCls);
        holder = ClientDeploymentDescManager.completeClient(carDeployableMetadata, applicationClient, jonasClient, classLoaderForCls);
        clientDD = new ClientContainerDeploymentDesc(classLoaderForCls, applicationClient, jonasClient);
        clientDD.setXmlContent(xmlContent);
        clientDD.setJOnASXmlContent(jonasXmlContent);
        clientDD.setENCBindingHolder(holder);
        clientDD.setCarMetadata(carDeployableMetadata);
        return clientDD;
    }

    public static ICarDeployableMetadata getCarMetadata(String clientFileName, ClassLoader classLoader) throws ClientContainerDeploymentDescException {
        ICarDeployableMetadata carDeployableMetadata;
        File clientFile = new File(clientFileName);
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)clientFile);
        try {
            CARDeployable carDeployable = (CARDeployable)DeployableHelper.getDeployable((IArchive)archive);
            if (!clientFile.isDirectory()) {
                carDeployable = (CARDeployable)UnpackDeployableHelper.unpack((IDeployable)carDeployable);
                logger.log(BasicLevel.DEBUG, (Object)"Unpack an application-client to create metadata");
            }
            carDeployableMetadata = new CarDeployableMetadataFactory().createDeployableMetadata(carDeployable, classLoader);
        }
        catch (Exception e) {
            throw new ClientContainerDeploymentDescException(e);
        }
        return carDeployableMetadata;
    }

    public static IENCBindingHolder completeClient(ICarDeployableMetadata carDeployableMetadata, ApplicationClient applicationClient, JonasClient jonasClient, ClassLoader classLoader) throws ClientContainerDeploymentDescException {
        ENCBindingHolder encBindingHolder = null;
        try {
            encBindingHolder = CarENCBindingBuilder.analyze((ICarDeployableMetadata)carDeployableMetadata);
        }
        catch (ENCBindingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to analyze metadata of '" + carDeployableMetadata + "'"), (Throwable)e);
        }
        List persistenceUnitBindings = encBindingHolder.getPersistenceUnitBindings();
        for (IENCBinding persistenceUnitBinding : persistenceUnitBindings) {
            IJavaxPersistenceUnit annotationPersistenceUnit = (IJavaxPersistenceUnit)persistenceUnitBinding.getValue();
            PersistenceUnitRef persistenceUnitRef = new PersistenceUnitRef();
            applicationClient.addPersistenceUnitRef(persistenceUnitRef);
            persistenceUnitRef.setPersistenceUnitRefName(annotationPersistenceUnit.getName());
            persistenceUnitRef.setPersistenceUnitName(annotationPersistenceUnit.getUnitName());
        }
        List resourcesBindings = encBindingHolder.getResourceBindings();
        for (IENCBinding resourceBinding : resourcesBindings) {
            String resourceName;
            IJAnnotationResource annotationResource = (IJAnnotationResource)resourceBinding.getValue();
            if ("javax.ejb.SessionContext".equals(annotationResource.getType()) || "org.omg.CORBA.ORB".equals(annotationResource.getType()) || "javax.transaction.UserTransaction".equals(annotationResource.getType()) || ClientDeploymentDescManager.containsResource(resourceName = resourceBinding.getName(), applicationClient)) continue;
            String messageDestinationLink = annotationResource.getMessageDestinationLink();
            if (messageDestinationLink == null) {
                ResourceRef resourceRef = new ResourceRef();
                applicationClient.addResourceRef(resourceRef);
                resourceRef.setResRefName(resourceBinding.getName());
                Resource.AuthenticationType authType = annotationResource.getAuthenticationType();
                if (authType.equals((Object)Resource.AuthenticationType.CONTAINER)) {
                    resourceRef.setResAuth("Container");
                } else {
                    resourceRef.setResAuth("Application");
                }
                resourceRef.setResType(annotationResource.getType());
                String mappedName = annotationResource.getMappedName();
                if (mappedName == null) continue;
                JonasResource jonasResource = new JonasResource();
                jonasResource.setResRefName(annotationResource.getName());
                jonasResource.setJndiName(mappedName);
                jonasClient.addJonasResource(jonasResource);
                continue;
            }
            MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
            applicationClient.addMessageDestinationRef(messageDestinationRef);
            messageDestinationRef.setMessageDestinationRefName(resourceBinding.getName());
            messageDestinationRef.setMessageDestinationLink(messageDestinationLink);
            messageDestinationRef.setMessageDestinationType(annotationResource.getType());
            String mappedName = annotationResource.getMappedName();
            if (mappedName == null) continue;
            JonasMessageDestination jonasMessageDestination = new JonasMessageDestination();
            jonasMessageDestination.setMessageDestinationName(annotationResource.getName());
            jonasMessageDestination.setJndiName(mappedName);
            jonasClient.addJonasMessageDestination(jonasMessageDestination);
        }
        List ejbsBindings = encBindingHolder.getEJBBindings();
        for (IENCBinding ejbBinding : ejbsBindings) {
            EjbRef ejbRef = new EjbRef();
            applicationClient.addEjbRef(ejbRef);
            ejbRef.setEjbRefName(ejbBinding.getName());
            IJEjbEJB jEJB = (IJEjbEJB)ejbBinding.getValue();
            String mappedName = jEJB.getMappedName();
            if (mappedName == null) continue;
            JonasEjbRef jonasEjbRef = new JonasEjbRef();
            jonasEjbRef.setEjbRefName(ejbBinding.getName());
            jonasEjbRef.setJndiName(mappedName);
            jonasClient.addJonasEjbRef(jonasEjbRef);
        }
        List webServicesBindings = encBindingHolder.getWebServicesBindings();
        for (IENCBinding binding : webServicesBindings) {
            IJaxwsWebServiceRef wsr = (IJaxwsWebServiceRef)binding.getValue();
            JonasServiceRef jsr = ClientDeploymentDescManager.findJonasServiceRef(jonasClient.getJonasServiceRefList(), wsr.getName());
            if (jsr == null) continue;
            ClientDeploymentDescManager.mergeWebServiceRef(jsr, wsr);
        }
        return encBindingHolder;
    }

    public static ApplicationClient loadApplicationClient(Reader reader, String fileName) throws DeploymentDescException {
        ApplicationClient appc = new ApplicationClient();
        if (reader == null) {
            return appc;
        }
        if (appClientDigester == null) {
            appClientDigester = new JDigester(appClientRuleSet, ClientDeploymentDescManager.getParsingWithValidation(), true, new AppClientDTDs(), new AppClientSchemas());
        }
        try {
            appClientDigester.parse(reader, fileName, appc);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            appClientDigester.push(null);
        }
        return appc;
    }

    public static JonasClient loadJonasClient(Reader reader, String fileName) throws DeploymentDescException {
        JonasClient jc = new JonasClient();
        if (jonasAppClientDigester == null) {
            jonasAppClientDigester = new JDigester(jonasAppClientRuleSet, ClientDeploymentDescManager.getParsingWithValidation(), true, new JonasAppClientDTDs(), new JonasAppClientSchemas());
        }
        try {
            jonasAppClientDigester.parse(reader, fileName, jc);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            jonasAppClientDigester.push(null);
        }
        return jc;
    }

    private String getJndiName(URL clientURL, String ejbLink, ClassLoader earLoader, String ejbType) throws DeploymentDescException {
        return this.ejbDDManager.getJndiName(clientURL, ejbLink, earLoader, ejbType, null, true);
    }

    private String getMDJndiName(URL clientURL, String mdLink, String mdType, String mdUsage, ClassLoader earLoader) throws ClientContainerDeploymentDescException {
        String ejbJarLink = null;
        String destNameLink = null;
        DeploymentDesc dd = null;
        JonasMessageDestination md = null;
        if (mdLink.indexOf("#") > 0) {
            ejbJarLink = mdLink.split("#")[0];
            destNameLink = mdLink.split("#")[1];
        } else {
            destNameLink = mdLink;
        }
        if (ejbJarLink != null) {
            if (!ejbJarLink.endsWith(".jar")) {
                String err = "Ejbjar filename " + ejbJarLink + " from the message-destination-link " + mdLink + " has a bad format. Correct format :  filename.jar";
                throw new ClientContainerDeploymentDescException(err);
            }
            URL ejbJarLinkUrl = null;
            try {
                ejbJarLinkUrl = new File(new File(clientURL.getFile()).getParent() + File.separator + ejbJarLink).getCanonicalFile().toURL();
            }
            catch (MalformedURLException mue) {
                String err = "Error when creating an url for the ejb jar filename. Error :" + mue.getMessage();
                throw new ClientContainerDeploymentDescException(err);
            }
            catch (IOException ioe) {
                String err = "Error when creating/accessing a file. Error :" + ioe.getMessage();
                throw new ClientContainerDeploymentDescException(err);
            }
            if (!new File(ejbJarLinkUrl.getFile()).exists()) {
                String err = "Cannot get the deployment descriptor for '" + ejbJarLinkUrl.getFile() + "'. The file doesn't exist.";
                throw new ClientContainerDeploymentDescException(err);
            }
            URL[] ddURL = new URL[]{ejbJarLinkUrl};
            URLClassLoader loaderForClsEjb = new URLClassLoader(ddURL, earLoader);
            try {
                dd = this.ejbDDManager.getDeploymentDesc(ejbJarLinkUrl, loaderForClsEjb, earLoader);
            }
            catch (DeploymentDescException e) {
                String err = "Cannot get the deployment descriptor for '" + ejbJarLinkUrl.getFile() + "'.";
                throw new ClientContainerDeploymentDescException(err, e);
            }
            md = dd.getJonasMessageDestination(mdLink);
        }
        if (md == null) {
            String err = "No message-destination-link was found for '" + mdLink + "' in the file " + clientURL.getFile() + " specified.";
            ClientContainerDeploymentDescException e = new ClientContainerDeploymentDescException(err);
            EZBRemoteJNDIResolver jndiResolver = null;
            Object o = null;
            try {
                o = new InitialContext().lookup("EZB_Remote_JNDIResolver");
            }
            catch (NamingException ne) {
                logger.log(BasicLevel.DEBUG, (Object)"No Remote EJB3 JNDI Resolver found");
                throw e;
            }
            jndiResolver = (EZBRemoteJNDIResolver)PortableRemoteObject.narrow((Object)o, EZBRemoteJNDIResolver.class);
            List jndiDataList = null;
            try {
                jndiDataList = jndiResolver.getMessageDestinationJNDINames(destNameLink);
            }
            catch (RemoteException re) {
                throw new ClientContainerDeploymentDescException("Unable to get EJB-LINK for destination '" + destNameLink + "'", re);
            }
            if (jndiDataList.size() == 0) {
                throw new ClientContainerDeploymentDescException("Unable to get EJB-LINK for destination '" + destNameLink + "'");
            }
            if (jndiDataList.size() > 1) {
                throw new ClientContainerDeploymentDescException("Unable to get EJB-LINK for destination '" + destNameLink + "', too many answers : '" + jndiDataList + "'.");
            }
            EZBJNDIData jndiData = (EZBJNDIData)jndiDataList.get(0);
            return jndiData.getName();
        }
        return md.getJndiName();
    }

    public void removeCache(ClassLoader earClassLoader) {
        this.earCLAltDDBindings.remove(earClassLoader);
        this.ejbDDManager.removeCache(earClassLoader);
    }

    public void setAltDD(ClassLoader earClassLoader, URL[] urls, URL[] altDDs) {
        Hashtable<URL, URL> urlAltddBindings = new Hashtable<URL, URL>();
        for (int i = 0; i < urls.length; ++i) {
            if (altDDs[i] == null) continue;
            urlAltddBindings.put(urls[i], altDDs[i]);
        }
        this.earCLAltDDBindings.put(earClassLoader, urlAltddBindings);
    }

    public int getCacheSize() {
        int bufferSize = 0;
        Enumeration keys = this.earCLAltDDBindings.keys();
        while (keys.hasMoreElements()) {
            ClassLoader loader = (ClassLoader)keys.nextElement();
            Hashtable hashtab = (Hashtable)this.earCLAltDDBindings.get(loader);
            bufferSize += hashtab.size();
        }
        return bufferSize;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }

    static {
        appClientDigester = null;
        jonasAppClientDigester = null;
        parsingWithValidation = true;
        appClientRuleSet = new ApplicationClientRuleSet();
        jonasAppClientRuleSet = new JonasClientRuleSet();
        logger = Log.getLogger((String)ClientDeploymentDescManager.class.getName());
    }
}

