/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.common.digester;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.jonas.deployment.api.DTDs;
import org.ow2.jonas.deployment.api.Schemas;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.digester.JEntityResolverWithDigester;
import org.ow2.jonas.deployment.common.digester.JErrorHandler;
import org.ow2.jonas.deployment.common.rules.JRuleSetBase;
import org.ow2.jonas.deployment.common.xml.TopLevelElement;

public class JDigester
extends Digester {
    public JDigester(JRuleSetBase ruleSet, boolean parsingWithValidation, boolean namespaceAware, DTDs dtds, Schemas schemas) throws DeploymentDescException {
        String packageName = ruleSet.getClass().getPackage().getName();
        String rootPackageName = packageName.substring(0, packageName.lastIndexOf(46));
        this.setNamespaceAware(namespaceAware);
        this.setValidating(parsingWithValidation);
        this.setErrorHandler(new JErrorHandler());
        JEntityResolverWithDigester jEntityResolver = new JEntityResolverWithDigester(this);
        jEntityResolver.addDtds(dtds);
        jEntityResolver.addSchemas(schemas);
        this.setEntityResolver(jEntityResolver);
        if (parsingWithValidation) {
            try {
                this.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (Exception ee) {
                throw new DeploymentDescException("Error setting feature", ee);
            }
        }
        Log log = LogFactory.getLog((String)(rootPackageName + ".digester"));
        this.setLogger(log);
        try {
            this.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (Exception ee) {
            throw new DeploymentDescException("Error setting feature", ee);
        }
        this.setUseContextClassLoader(false);
        this.addRuleSet(ruleSet);
    }

    public void parse(Reader reader, String fileName, TopLevelElement element) throws DeploymentDescException {
        try {
            this.clear();
            this.push(element);
            this.parse(reader);
        }
        catch (Exception ioe) {
            throw new DeploymentDescException("Error when parsing XML document " + fileName, ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {
                    this.getLogger().warn((Object)("Can't close '" + fileName + "'"));
                }
            }
            this.push(null);
        }
    }
}

