/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws.lib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.JndiEnvRefsGroupDesc;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDescException;
import org.ow2.jonas.deployment.web.lib.WebDeploymentDescManager;
import org.ow2.jonas.deployment.ws.JonasWsSchemas;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.WsSchemas;
import org.ow2.jonas.deployment.ws.rules.JonasWebservicesRuleSet;
import org.ow2.jonas.deployment.ws.rules.WebservicesRuleSet;
import org.ow2.jonas.deployment.ws.xml.JonasWebservices;
import org.ow2.jonas.deployment.ws.xml.Webservices;
import org.ow2.jonas.lib.util.Log;

public class WSDeploymentDescManager
extends AbsDeploymentDescManager {
    public static final String WS_EJBJAR_FILE_NAME = "META-INF/webservices.xml";
    public static final String JONAS_WS_EJBJAR_FILE_NAME = "META-INF/jonas-webservices.xml";
    public static final String WS_WEBAPP_FILE_NAME = "WEB-INF/webservices.xml";
    public static final String JONAS_WS_WEBAPP_FILE_NAME = "WEB-INF/jonas-webservices.xml";
    private static JDigester wsDigester = null;
    private static JDigester jwsDigester = null;
    private static WebservicesRuleSet wsRuleSet = new WebservicesRuleSet();
    private static JonasWebservicesRuleSet jwsRuleSet = new JonasWebservicesRuleSet();
    private static boolean parsingWithValidation = true;
    private static WSDeploymentDescManager unique = null;
    private static boolean isInstanciated = false;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ws");
    private Map<URL, WSDeploymentDesc> urlWsddBindings = new HashMap<URL, WSDeploymentDesc>();
    private Map<ClassLoader, List<URL>> classLoader2URLs = new Hashtable<ClassLoader, List<URL>>();
    private EjbDeploymentDescManager ejbManager = EjbDeploymentDescManager.getInstance();
    private WebDeploymentDescManager webManager = WebDeploymentDescManager.getInstance();

    private WSDeploymentDescManager() {
    }

    public static WSDeploymentDescManager getInstance() {
        if (!isInstanciated) {
            isInstanciated = true;
            unique = new WSDeploymentDescManager();
        }
        return unique;
    }

    public static WSDeploymentDesc getDeploymentDesc(String file, ClassLoader jarCL) throws WSDeploymentDescException {
        URL fileUrl = null;
        try {
            fileUrl = new File(file).toURL();
        }
        catch (MalformedURLException mue) {
            throw new WSDeploymentDescException(mue);
        }
        WSDeploymentDesc wsdd = WSDeploymentDescManager.loadDeploymentDesc(fileUrl, jarCL);
        if (wsdd == null) {
            return null;
        }
        List sdl = wsdd.getServiceDescs();
        for (int i = 0; i < sdl.size(); ++i) {
            List pcdl = ((ServiceDesc)sdl.get(i)).getPortComponents();
            for (int j = 0; j < pcdl.size(); ++j) {
                JndiEnvRefsGroupDesc desc;
                PortComponentDesc pcd = (PortComponentDesc)pcdl.get(j);
                String sibLink = pcd.getSibLink();
                if (pcd.hasBeanImpl()) {
                    desc = WSDeploymentDescManager.getBeanDesc(file, sibLink, jarCL);
                    pcd.setDesc(desc);
                    continue;
                }
                if (!pcd.hasJaxRpcImpl()) continue;
                desc = WSDeploymentDescManager.getWebDesc(file, sibLink, jarCL);
                pcd.setDesc(desc);
            }
        }
        return wsdd;
    }

    public WSDeploymentDesc getDeploymentDesc(URL url, ClassLoader jarCL, ClassLoader earCL) throws WSDeploymentDescException {
        return this.getDeploymentDesc(url, null, jarCL, earCL);
    }

    public WSDeploymentDesc getDeploymentDesc(URL url, URL unpackedURL, ClassLoader jarCL, ClassLoader earCL) throws WSDeploymentDescException {
        URL escapedUrl;
        WSDeploymentDesc wsdd = null;
        File moduleFile = new File(url.getFile());
        try {
            escapedUrl = moduleFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new WSDeploymentDescException(e);
        }
        if (moduleFile.exists()) {
            wsdd = !this.urlWsddBindings.containsKey(escapedUrl) ? this.getDeploymentDescriptor(escapedUrl, unpackedURL, jarCL, earCL) : this.urlWsddBindings.get(escapedUrl);
        } else {
            throw new WSDeploymentDescException("'" + moduleFile.getName() + "' doesn't exist");
        }
        ClassLoader keyCL = earCL != null ? earCL : jarCL;
        List<URL> urls = this.classLoader2URLs.get(keyCL);
        if (urls == null) {
            urls = new Vector<URL>();
            this.classLoader2URLs.put(keyCL, urls);
        }
        urls.add(escapedUrl);
        return wsdd;
    }

    private WSDeploymentDesc getDeploymentDescriptor(URL url, URL unpackedURL, ClassLoader jarCL, ClassLoader earCL) throws WSDeploymentDescException {
        URL baseURL = url;
        if (unpackedURL != null) {
            baseURL = unpackedURL;
        }
        WSDeploymentDesc wsdd = WSDeploymentDescManager.loadDeploymentDesc(baseURL, jarCL);
        this.urlWsddBindings.put(url, wsdd);
        if (wsdd == null) {
            return null;
        }
        List sdl = wsdd.getServiceDescs();
        for (int i = 0; i < sdl.size(); ++i) {
            List pcdl = ((ServiceDesc)sdl.get(i)).getPortComponents();
            for (int j = 0; j < pcdl.size(); ++j) {
                JndiEnvRefsGroupDesc desc;
                PortComponentDesc pcd = (PortComponentDesc)pcdl.get(j);
                String sibLink = pcd.getSibLink();
                if (pcd.hasBeanImpl()) {
                    desc = this.getBeanDesc(url.getFile(), sibLink, jarCL, earCL);
                    pcd.setDesc(desc);
                    continue;
                }
                if (!pcd.hasJaxRpcImpl()) continue;
                desc = this.getWebDesc(url.getFile(), sibLink, jarCL, earCL);
                pcd.setDesc(desc);
            }
        }
        return wsdd;
    }

    private static WSDeploymentDesc loadDeploymentDesc(URL url, ClassLoader cl) throws WSDeploymentDescException {
        URLClassLoader ucl = (URLClassLoader)cl;
        InputStream isWebservices = null;
        InputStream isJonasWebservices = null;
        URL wsXml = null;
        URL jwsXml = null;
        try {
            boolean foundInEjb = false;
            Enumeration<URL> ejbWebservices = ucl.findResources(WS_EJBJAR_FILE_NAME);
            while (ejbWebservices.hasMoreElements() && !foundInEjb) {
                wsXml = ejbWebservices.nextElement();
                if (!WSDeploymentDescManager.isResourceInFile(url, wsXml)) continue;
                foundInEjb = true;
            }
            if (foundInEjb) {
                isWebservices = WSDeploymentDescManager.openInputStream(wsXml);
                foundInEjb = false;
                Enumeration<URL> ejbJonasWebservices = ucl.findResources(JONAS_WS_EJBJAR_FILE_NAME);
                while (ejbJonasWebservices.hasMoreElements() && !foundInEjb) {
                    jwsXml = ejbJonasWebservices.nextElement();
                    if (!WSDeploymentDescManager.isResourceInFile(url, jwsXml)) continue;
                    foundInEjb = true;
                }
                if (foundInEjb) {
                    isJonasWebservices = WSDeploymentDescManager.openInputStream(jwsXml);
                }
            }
            boolean foundInWeb = false;
            Enumeration<URL> webWebservices = ucl.findResources(WS_WEBAPP_FILE_NAME);
            while (webWebservices.hasMoreElements() && !foundInWeb) {
                wsXml = webWebservices.nextElement();
                if (!WSDeploymentDescManager.isResourceInFile(url, wsXml)) continue;
                foundInWeb = true;
            }
            if (foundInWeb) {
                isWebservices = WSDeploymentDescManager.openInputStream(wsXml);
                foundInWeb = false;
                Enumeration<URL> webJonasWebservices = ucl.findResources(JONAS_WS_WEBAPP_FILE_NAME);
                while (webJonasWebservices.hasMoreElements() && !foundInWeb) {
                    jwsXml = webJonasWebservices.nextElement();
                    if (!WSDeploymentDescManager.isResourceInFile(url, jwsXml)) continue;
                    foundInWeb = true;
                }
                if (foundInWeb) {
                    isJonasWebservices = WSDeploymentDescManager.openInputStream(jwsXml);
                }
            }
        }
        catch (IOException ioe) {
            String err = "Cannot open Streams on WebServices Deployment Descriptor for '" + url + "'";
            throw new WSDeploymentDescException(err, ioe);
        }
        if (isWebservices == null) {
            return null;
        }
        Webservices webservices = WSDeploymentDescManager.loadWebservices(new InputStreamReader(isWebservices), wsXml.getFile());
        JonasWebservices jonasWebservices = null;
        if (isJonasWebservices != null) {
            jonasWebservices = WSDeploymentDescManager.loadJonasWebservices(new InputStreamReader(isJonasWebservices), jwsXml.getFile());
        }
        try {
            if (isWebservices != null) {
                isWebservices.close();
            }
            if (isJonasWebservices != null) {
                isJonasWebservices.close();
            }
        }
        catch (IOException ioe) {
            String err = "Cannot close InputStreams for '" + url + "'";
            logger.log(BasicLevel.WARN, (Object)err);
        }
        if ("1.1".equals(webservices.getVersion())) {
            return new WSDeploymentDesc(cl, logger, webservices, jonasWebservices);
        }
        return null;
    }

    private static InputStream openInputStream(URL xml) throws IOException {
        URLConnection conn = xml.openConnection();
        conn.setUseCaches(false);
        conn.setDefaultUseCaches(false);
        InputStream is = conn.getInputStream();
        return is;
    }

    private static boolean isResourceInFile(URL file, URL resource) {
        boolean within = false;
        File f = new File(file.getFile());
        if (f.isDirectory()) {
            if (resource.toString().startsWith(file.toString())) {
                within = true;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Directory case. found '" + resource + "' in '" + file + "'"));
                }
            }
        } else if (f.isFile()) {
            int index;
            if (f.getPath().endsWith(".xml")) {
                if (file.equals(resource)) {
                    within = true;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("XML case. found '" + resource + "' in '" + file + "'"));
                    }
                }
            } else if ((f.getPath().endsWith(".war") || f.getPath().endsWith(".jar")) && (index = resource.toString().indexOf("!/")) != -1 && resource.toString().startsWith("jar:" + file.toString())) {
                within = true;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Archive case. found '" + resource + "' in '" + file + "'"));
                }
            }
        }
        return within;
    }

    public static Webservices loadWebservices(Reader reader, String fileName) throws WSDeploymentDescException {
        Webservices ws = new Webservices();
        if (wsDigester == null) {
            try {
                wsDigester = new JDigester(wsRuleSet, WSDeploymentDescManager.getParsingWithValidation(), true, null, new WsSchemas());
            }
            catch (DeploymentDescException e) {
                throw new WSDeploymentDescException(e);
            }
        }
        try {
            wsDigester.parse(reader, fileName, ws);
        }
        catch (DeploymentDescException e) {
            throw new WSDeploymentDescException(e);
        }
        finally {
            wsDigester.push(null);
        }
        return ws;
    }

    public static JonasWebservices loadJonasWebservices(Reader reader, String fileName) throws WSDeploymentDescException {
        JonasWebservices jws = new JonasWebservices();
        if (jwsDigester == null) {
            try {
                jwsDigester = new JDigester(jwsRuleSet, WSDeploymentDescManager.getParsingWithValidation(), true, null, new JonasWsSchemas());
            }
            catch (DeploymentDescException e) {
                throw new WSDeploymentDescException(e);
            }
        }
        try {
            jwsDigester.parse(reader, fileName, jws);
        }
        catch (DeploymentDescException e) {
            throw new WSDeploymentDescException(e);
        }
        finally {
            jwsDigester.push(null);
        }
        return jws;
    }

    public int getCacheSize() {
        return this.urlWsddBindings.size();
    }

    public void clearCache() {
        this.urlWsddBindings = new HashMap<URL, WSDeploymentDesc>();
    }

    public void removeCache(ClassLoader cl) {
        List<URL> urls = this.classLoader2URLs.remove(cl);
        if (urls != null) {
            for (URL url : urls) {
                this.urlWsddBindings.remove(url);
            }
        }
    }

    public String toString() {
        return "" + this.getCacheSize();
    }

    private static SessionStatelessDesc getBeanDesc(String filename, String link, ClassLoader cl) throws WSDeploymentDescException {
        BeanDesc bd = null;
        try {
            DeploymentDesc dd = EjbDeploymentDescManager.getDeploymentDesc(filename, cl);
            bd = dd.getBeanDesc(link);
        }
        catch (DeploymentDescException dde) {
            throw new WSDeploymentDescException("DeploymentDescException when searching '" + link + "' in '" + filename + "'", dde);
        }
        if (bd == null) {
            throw new WSDeploymentDescException("Unable to find the ejb-link '" + link + "' in '" + filename + "'");
        }
        if (!(bd instanceof SessionStatelessDesc)) {
            throw new WSDeploymentDescException("ejb-link '" + link + "' must be a Stateless Session Bean not a '" + bd.getClass().getName() + "'");
        }
        return (SessionStatelessDesc)bd;
    }

    private SessionStatelessDesc getBeanDesc(String filename, String link, ClassLoader jarCL, ClassLoader earCL) throws WSDeploymentDescException {
        URL url;
        try {
            url = new File(filename).toURL();
        }
        catch (MalformedURLException mue) {
            throw new WSDeploymentDescException("Url Error with '" + filename + "'", mue);
        }
        BeanDesc bd = null;
        try {
            DeploymentDesc dd = this.ejbManager.getDeploymentDesc(url, jarCL, earCL);
            bd = dd.getBeanDesc(link);
        }
        catch (DeploymentDescException dde) {
            throw new WSDeploymentDescException("Unable to load EjbJar '" + url + "'", dde);
        }
        if (bd == null) {
            throw new WSDeploymentDescException("Unable to find the ejb-link '" + link + "' in '" + filename + "'");
        }
        if (!(bd instanceof SessionStatelessDesc)) {
            throw new WSDeploymentDescException("ejb-link '" + link + "' must be a Stateless Session Bean");
        }
        return (SessionStatelessDesc)bd;
    }

    private static WebContainerDeploymentDesc getWebDesc(String filename, String link, ClassLoader cl) throws WSDeploymentDescException {
        WebContainerDeploymentDesc wd = null;
        try {
            wd = WebDeploymentDescManager.getDeploymentDesc(filename, cl);
        }
        catch (WebContainerDeploymentDescException wcdde) {
            throw new WSDeploymentDescException("Error while reading/parsing " + filename, wcdde);
        }
        if (wd.getServletClassname(link) == null) {
            throw new WSDeploymentDescException("Unable to find the servlet-link '" + link + "' in '" + filename + "'");
        }
        return wd;
    }

    private WebContainerDeploymentDesc getWebDesc(String filename, String link, ClassLoader jarCL, ClassLoader earCL) throws WSDeploymentDescException {
        URL url;
        try {
            url = new File(filename).toURL();
        }
        catch (MalformedURLException mue) {
            throw new WSDeploymentDescException("Url Error with '" + filename + "'", mue);
        }
        WebContainerDeploymentDesc wd = null;
        try {
            wd = this.webManager.getDeploymentDesc(url, jarCL, earCL);
        }
        catch (DeploymentDescException wcdde) {
            throw new WSDeploymentDescException("Error while reading/parsing " + filename, wcdde);
        }
        if (wd.getServletClassname(link) == null) {
            throw new WSDeploymentDescException("Unable to find the servlet-link '" + link + "' in '" + filename + "'");
        }
        return wd;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }

    public PortComponentDesc getPortComponentDesc(URL callerURL, String portComponentLinkName, ClassLoader moduleLoader, ClassLoader earLoader) throws WSDeploymentDescException {
        String moduleLink = null;
        String pcNameLink = null;
        URL moduleLinkUrl = null;
        URLClassLoader loaderForCls = null;
        if (!portComponentLinkName.matches(".*#.*")) {
            pcNameLink = portComponentLinkName;
            moduleLinkUrl = callerURL;
            loaderForCls = (URLClassLoader)moduleLoader;
        } else {
            if (portComponentLinkName.toLowerCase().indexOf(".war#") == -1 && portComponentLinkName.toLowerCase().indexOf(".jar#") == -1) {
                String err = "PC-link " + portComponentLinkName + " has a bad format. Correct format : filename.[jar or war]#portComponentName or just portComponentName";
                throw new WSDeploymentDescException(err);
            }
            StringTokenizer st = new StringTokenizer(portComponentLinkName, "#");
            if (st.countTokens() != 2 || portComponentLinkName.startsWith("#") || portComponentLinkName.endsWith("#")) {
                throw new WSDeploymentDescException("PC-link " + portComponentLinkName + " has a bad format. " + "Correct format : filename.[jar or war]#portComponentName or just portComponentName");
            }
            moduleLink = st.nextToken();
            pcNameLink = st.nextToken();
            try {
                moduleLinkUrl = new File(new File(callerURL.getFile()).getParent() + File.separator + moduleLink).getCanonicalFile().toURL();
            }
            catch (MalformedURLException mue) {
                String err = "Error when creating an url for the module filename. Error :" + mue.getMessage();
                throw new WSDeploymentDescException(err, mue);
            }
            catch (IOException ioe) {
                String err = "Error when creating/accessing a file. Error :" + ioe.getMessage();
                throw new WSDeploymentDescException(err, ioe);
            }
            if (!new File(moduleLinkUrl.getFile()).exists()) {
                String err = "Cannot get the deployment descriptor for '" + moduleLinkUrl.getFile() + "'. The file doesn't exist.";
                throw new WSDeploymentDescException(err);
            }
            URL[] ddURL = new URL[]{moduleLinkUrl};
            loaderForCls = new URLClassLoader(ddURL, earLoader);
        }
        WSDeploymentDesc wsDD = null;
        try {
            wsDD = this.getDeploymentDesc(moduleLinkUrl, loaderForCls, earLoader);
        }
        catch (DeploymentDescException e) {
            String err = "Cannot get the deployment descriptor for '" + moduleLinkUrl.getFile() + "'.";
            throw new WSDeploymentDescException(err, e);
        }
        if (wsDD == null) {
            String err = "Port component link " + pcNameLink + " not found in " + moduleLinkUrl.getFile();
            throw new WSDeploymentDescException(err);
        }
        List sdl = wsDD.getServiceDescs();
        boolean isFound = false;
        PortComponentDesc pcd = null;
        for (int i = 0; i < sdl.size() && !isFound; ++i) {
            if (sdl.get(i) == null) continue;
            pcd = ((ServiceDesc)sdl.get(i)).getPortComponent(pcNameLink);
            isFound = pcd != null;
        }
        if (!isFound) {
            String err = "the port component link " + pcNameLink + " doesn't exist in " + moduleLinkUrl.getFile();
            throw new WSDeploymentDescException(err);
        }
        return pcd;
    }
}

