/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal;

import org.ow2.jonas.resource.ResourceService;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RARDeployer
extends AbsDeployer {
    private Log logger = LogFactory.getLog(RARDeployer.class);
    private ResourceService resourceService = null;

    public void doUndeploy(IDeployable<?> deployable) throws DeployerException {
        this.logger.info((Object)"Undeploying {0}", new Object[]{deployable.getShortName()});
        try {
            this.resourceService.unDeployRar(this.getFile(deployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the RAR deployable '" + deployable + "'.", (Throwable)e);
        }
    }

    public void doDeploy(IDeployable<?> deployable) throws DeployerException {
        this.logger.info((Object)"Deploying {0}", new Object[]{deployable.getShortName()});
        try {
            this.resourceService.deployRar(this.getFile(deployable).getPath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the RAR deployable '" + deployable + "'.", (Throwable)e);
        }
    }

    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof RARDeployable;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }
}

