/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.lib.JormCompiler;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.Version;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.eclipse.compiler.CompilationContext;
import org.ow2.jonas.eclipse.compiler.CompilerError;
import org.ow2.jonas.eclipse.compiler.JOnASCompiler;
import org.ow2.jonas.generators.genic.BeanSources;
import org.ow2.jonas.generators.genic.GenICException;
import org.ow2.jonas.generators.genic.GenICParameters;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.ejb21.Protocols;
import org.ow2.jonas.lib.ejb21.jorm.CMP2Bean;
import org.ow2.jonas.lib.ejb21.jorm.RdbMappingBuilder;
import org.ow2.jonas.lib.util.BeanNaming;
import org.ow2.jonas.lib.util.Cmd;
import org.ow2.jonas.lib.util.Env;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;

public class GenIC {
    public static Logger logger = Log.getLogger((String)"org.ow2.jonas.generators.genic");
    private static String javaHomeBin = null;
    private boolean verbose = false;
    private String outputdir = null;
    private String canonicalOutputdir = null;
    private boolean generatedIC;
    private ArrayList filesToDelete = null;
    private ArrayList remoteJavas = null;
    private ArrayList noRemoteJavas = null;
    private ArrayList remoteClasses = null;
    private GenICParameters gp = null;
    private static final int BUFFER_SIZE = 4096;
    private static final String META_DIR = "META-INF";
    private static final String MANIFEST_PATH = "META-INF" + File.separator + "MANIFEST.MF";

    public static void main(String[] args) {
        boolean error = false;
        String protocolNames = "jrmp";
        GenICParameters gp = new GenICParameters();
        for (int argn = 0; argn < args.length; ++argn) {
            StringTokenizer st;
            String arg = args[argn];
            if (arg.equals("-help") || arg.equals("-?")) {
                gp.setHelp(true);
                continue;
            }
            if (arg.equals("-verbose")) {
                gp.setVerbose(true);
                continue;
            }
            if (arg.equals("-debug")) continue;
            if (arg.equals("-mappernames")) {
                ++argn;
                logger.log(BasicLevel.LEVEL_WARN, (Object)"The -mappernames option is ignored (deprecated)");
            }
            if (arg.equals("-protocols")) {
                if (++argn < args.length) {
                    protocolNames = args[argn];
                    continue;
                }
                error = true;
            }
            if (arg.equals("-keepgenerated")) {
                gp.setKeepGenerated(true);
                gp.getRmicOptions().add(args[argn]);
                continue;
            }
            if (arg.equals("-nocompil")) {
                gp.setCompil(false);
                gp.setKeepGenerated(true);
                continue;
            }
            if (arg.equals("-noaddinjar")) {
                gp.setAddInJar(false);
                continue;
            }
            if (arg.equals("-novalidation")) {
                gp.setParseWithValidation(false);
                continue;
            }
            if (arg.equals("-classpath")) {
                gp.setClasspathParam(args[++argn]);
                continue;
            }
            if (arg.equals("-javac")) {
                if (++argn < args.length) {
                    gp.setJavacName(args[argn]);
                    continue;
                }
                error = true;
                continue;
            }
            if (arg.equals("-javacopts")) {
                if (++argn < args.length) {
                    st = new StringTokenizer(args[argn]);
                    while (st.hasMoreTokens()) {
                        gp.getJavacOptions().add(st.nextToken());
                    }
                    continue;
                }
                error = true;
                continue;
            }
            if (arg.equals("-rmicopts")) {
                if (++argn < args.length) {
                    st = new StringTokenizer(args[argn]);
                    while (st.hasMoreTokens()) {
                        gp.getRmicOptions().add(st.nextToken());
                    }
                    continue;
                }
                error = true;
                continue;
            }
            if (arg.equals("-d")) {
                if (++argn < args.length) {
                    gp.setOutputDirectory(args[argn]);
                    continue;
                }
                error = true;
                continue;
            }
            if (arg.equals("-invokecmd")) {
                gp.setInvokeCmd(true);
                continue;
            }
            if (arg.equals("-fastrmic")) {
                ++argn;
                logger.log(BasicLevel.WARN, (Object)"The -fastrmic option is ignored as it is the default value. Use -nofastrmic to disable it.");
                continue;
            }
            if (arg.equals("-nofastrmic")) {
                ++argn;
                gp.setFastRmicEnabled(false);
                continue;
            }
            gp.setInputFilename(args[argn]);
        }
        if (gp.isHelp()) {
            GenIC.usage();
            return;
        }
        if (error || gp.getInputFilename() == null) {
            GenIC.usage();
            throw new RuntimeException();
        }
        if (gp.getOutputDirectory() != null && gp.isAddInJar() && gp.getInputFilename().endsWith(".jar")) {
            logger.log(BasicLevel.WARN, (Object)("The -d '" + gp.getOutputDirectory() + "' option is ignored" + " (deprecated with an ejb-jar as input file)"));
        }
        if (gp.getOutputDirectory() == null) {
            gp.setOutputDirectory("");
        }
        gp.setProtocols(new Protocols(protocolNames, true));
        if (gp.getProtocols().isSupported("iiop")) {
            gp.setFastRmicEnabled(false);
            String classpathParam = gp.getClasspathParam();
            String jonasRoot = System.getProperty("jonas.root");
            File clientFile = new File(jonasRoot, "lib" + File.separator + "client.jar");
            if (clientFile.exists()) {
                try {
                    classpathParam = classpathParam + File.pathSeparator + clientFile.toURL().getPath();
                    gp.setClasspathParam(classpathParam);
                }
                catch (MalformedURLException e) {
                    logger.log(BasicLevel.WARN, (Object)"Cannot add client.jar to GenIC classpath.");
                }
            }
        }
        if (gp.getInputFilename().endsWith(".jar") && gp.isAddInJar()) {
            try {
                gp.setOutputDirectory(GenIC.createTempDir());
            }
            catch (IOException ioe) {
                GenIC.fatalError(ioe);
            }
        }
        String classpath = "";
        ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadContextClassLoader instanceof JClassLoader) {
            classpath = ((JClassLoader)threadContextClassLoader).getClassPath();
        }
        if (gp.getInputFilename().endsWith(".jar")) {
            File in = new File(gp.getInputFilename());
            File out = new File(gp.getWorkingFilename());
            if (out.exists() && !out.delete()) {
                String deleteError = "Cannot delete existant working copy '" + out + "'";
                GenIC.fatalError(deleteError, new IOException(deleteError));
            }
            if (!in.renameTo(out)) {
                GenIC.fatalError("Cannot rename input File from '" + gp.getInputFilename() + "' to '" + gp.getWorkingFilename() + "'", new IOException(gp.getInputFilename()));
            }
            classpath = out.getPath() + File.pathSeparator + classpath;
        }
        if (!"".equals(gp.getOutputDirectory())) {
            classpath = gp.getOutputDirectory() + File.pathSeparator + classpath;
        }
        if (gp.getClasspathParam() != null) {
            classpath = gp.getClasspathParam() + File.pathSeparator + classpath;
        }
        gp.setClasspathParam(classpath);
        if (!gp.isParseWithValidation()) {
            EjbDeploymentDescManager.setParsingWithValidation((boolean)false);
        }
        if (gp.getInputFilename() != null && gp.getInputFilename().endsWith(".jar") && gp.isAddInJar()) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("Genic-Jonas-Version", Version.getNumber());
            attributes.put("Genic-Jonas-protocols", gp.getProtocols().list());
            try {
                FileUtils.updateAttributesInManifest((String)gp.getWorkingFilename(), attributes);
            }
            catch (FileUtilsException e) {
                GenIC.fatalError((Exception)((Object)e));
            }
        } else if (gp.getOutputDirectory() != null && !gp.isAddInJar()) {
            Manifest mf = new Manifest();
            Attributes attributes = mf.getMainAttributes();
            attributes.putValue("Genic-Jonas-Version", Version.getNumber());
            attributes.putValue("Genic-Jonas-protocols", gp.getProtocols().list());
            try {
                GenIC.createManifest(gp.getOutputDirectory(), mf);
            }
            catch (GenICException e) {
                GenIC.fatalError(e);
            }
        }
        JClassLoader loader = null;
        try {
            DeploymentDesc ejbJarDD = null;
            if (gp.getInputFilename().endsWith(".jar")) {
                URL[] url = new URL[]{new File(gp.getWorkingFilename()).toURL()};
                JClassLoader cl = new JClassLoader("GenIC-" + gp.getOriginalFilename(), url, threadContextClassLoader);
                if (gp.getClasspathParam() != null) {
                    GenIC.addClasspath(cl, gp.getClasspathParam());
                }
                ejbJarDD = EjbDeploymentDescManager.getDeploymentDesc((String)gp.getWorkingFilename(), (ClassLoader)cl);
                loader = cl;
                cl = null;
            } else {
                ejbJarDD = EjbDeploymentDescManager.getDeploymentDesc((String)gp.getWorkingFilename(), (String)BeanNaming.getJonasXmlName((String)gp.getWorkingFilename()), (String)BeanNaming.getParentName((String)gp.getWorkingFilename()));
            }
            GenIC gwc = new GenIC(ejbJarDD, gp);
            if (gp.isCompil()) {
                gwc.compilClasses(classpath, (ClassLoader)loader);
                ejbJarDD = null;
                loader = null;
                System.gc();
                if (gp.getInputFilename().endsWith(".jar") && gp.isAddInJar()) {
                    gwc.addClassesInJar();
                }
                if (!gp.isKeepGenerated()) {
                    gwc.clean();
                }
            }
        }
        catch (MalformedURLException e) {
            GenIC.fatalError("Invalid ejb-jar file name : ", e);
        }
        catch (GenICException e) {
            GenIC.fatalError(e);
        }
        catch (DeploymentDescException e) {
            GenIC.fatalError("Cannot read the Deployment Descriptors from " + gp.getInputFilename() + ": ", (Exception)((Object)e));
        }
    }

    private static void createManifest(String dirOutputName, Manifest manifest) throws GenICException {
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        File fileOutput = new File(dirOutputName + File.separator + META_DIR);
        if (!fileOutput.exists()) {
            fileOutput.mkdirs();
        }
        if (!fileOutput.exists()) {
            throw new GenICException("Cannot create META-INF directory into temp dir : " + dirOutputName + "/META-INF");
        }
        fileOutput = new File(dirOutputName + File.separator + MANIFEST_PATH);
        if (!fileOutput.exists()) {
            try {
                fileOutput.createNewFile();
            }
            catch (IOException e) {
                throw new GenICException("Cannot create '" + fileOutput + "' file", e);
            }
        }
        if (!fileOutput.exists()) {
            throw new GenICException("Cannot create manifest.mf file into " + dirOutputName + File.separator + META_DIR);
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(fileOutput);
            manifest.write(os);
        }
        catch (FileNotFoundException e) {
            throw new GenICException("Cannot write manifest.mf file", e);
        }
        catch (IOException e) {
            throw new GenICException("Cannot write manifest.mf file", e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    logger.log(BasicLevel.WARN, (Object)"Cannot close the outputstream", (Throwable)e);
                }
            }
        }
    }

    private static void addClasspath(JClassLoader cl, String classpath) throws GenICException {
        String[] elems = classpath.split(File.pathSeparator);
        for (int i = 0; i < elems.length; ++i) {
            try {
                cl.addURL(new File(elems[i]).toURL());
                continue;
            }
            catch (MalformedURLException e) {
                throw new GenICException("Cannot create URL from '" + elems[i] + "'", e);
            }
        }
    }

    public GenIC(DeploymentDesc ejbJarDesc, GenICParameters gp) throws GenICException {
        RdbMappingBuilder rdbMapping = null;
        ArrayList<BeanSources> beanList = new ArrayList<BeanSources>();
        this.gp = gp;
        this.verbose = gp.isVerbose();
        if (javaHomeBin == null && !"".equals(javaHomeBin = System.getProperty("java.home", ""))) {
            javaHomeBin = Env.isOsMacOsX() ? javaHomeBin + File.separator + "bin" + File.separator : javaHomeBin + File.separator + ".." + File.separator + "bin" + File.separator;
        }
        this.outputdir = gp.getOutputDirectory();
        try {
            this.canonicalOutputdir = new File(this.outputdir).getCanonicalFile().getPath();
        }
        catch (IOException e) {
            throw new GenICException("Cannot get cannonical name of the output directory", e);
        }
        this.filesToDelete = new ArrayList();
        this.remoteJavas = new ArrayList();
        this.noRemoteJavas = new ArrayList();
        this.remoteClasses = new ArrayList();
        BeanDesc[] beansDD = ejbJarDesc.getBeanDesc();
        JormCompiler jormCompiler = null;
        Manager mgr = null;
        VelocityEngine ve = this.allocateVelocityEngine();
        StringBuffer message = new StringBuffer();
        message.append("GenIC for JOnAS " + Version.getNumber() + ": ");
        String sep = "";
        for (int i = 0; i < beansDD.length; ++i) {
            if (beansDD[i] instanceof MessageDrivenDesc) continue;
            if (beansDD[i] instanceof EntityCmp2Desc && jormCompiler == null) {
                try {
                    DeploymentDescEjb2 dd2 = (DeploymentDescEjb2)ejbJarDesc;
                    rdbMapping = new RdbMappingBuilder(dd2);
                    mgr = rdbMapping.getJormMIManager();
                    jormCompiler = this.allocateJormCompiler(mgr);
                }
                catch (DeploymentDescException e) {
                    throw new GenICException("Impossible to load jorm meta information", (Exception)((Object)e));
                }
            }
            BeanSources bs = new BeanSources(beansDD[i], gp, ve);
            bs.init(jormCompiler, mgr);
            beanList.add(bs);
            message.append(sep);
            sep = ", ";
            message.append("'");
            message.append(bs.getEjbName());
            message.append("'");
        }
        boolean bl = this.generatedIC = !beanList.isEmpty();
        if (this.generatedIC) {
            message.append(" generation ...");
        } else {
            message.append("No generation to do (only message driven beans)");
        }
        logger.log(BasicLevel.INFO, (Object)message.toString());
        for (BeanSources ics : beanList) {
            String ccrfn;
            String cchfn;
            CMP2Bean cmp2;
            ics.generate();
            if (rdbMapping != null && (cmp2 = rdbMapping.getCmp2Bean(ics.getEjbName())) != null) {
                ics.jormCompile(cmp2.getJormList());
            }
            if ((cchfn = ics.getWrpHomeClusterFileName()) != null) {
                this.filesToDelete.add(cchfn);
            }
            if ((ccrfn = ics.getWrpRemoteClusterFileName()) != null) {
                this.filesToDelete.add(ccrfn);
            }
            logger.log(BasicLevel.INFO, (Object)("Sources classes successfully generated for '" + ics.getEjbName() + "'"));
            this.noRemoteJavas.addAll(ics.getNoRemoteJavas());
            if (ics.getWrpHomeFileName() != null) {
                this.remoteJavas.add(ics.getWrpHomeFileName());
                this.remoteClasses.add(ics.getWrpHomeClassName());
            }
            if (ics.getWrpRemoteFileName() != null) {
                this.remoteJavas.add(ics.getWrpRemoteFileName());
                this.remoteClasses.add(ics.getWrpRemoteClassName());
            }
            if (ics.getWrpServiceEndpointFileName() == null) continue;
            this.remoteJavas.add(ics.getWrpServiceEndpointFileName());
            this.remoteClasses.add(ics.getWrpServiceEndpointClassName());
        }
        jormCompiler = null;
        rdbMapping = null;
    }

    private JormCompiler allocateJormCompiler(Manager miManager) {
        JormCompiler jormCompiler = new JormCompiler();
        JormCompilerConfigurator jcc = jormCompiler.getCompilerConfigurator();
        Properties prop = new Properties();
        prop.put("jorm.generator", "org.objectweb.jorm.generator.lib.JormGenerator");
        prop.put("jorm.mimanager", "org.objectweb.jorm.metainfo.lib.JormManager");
        prop.put("jorm.writer", "org.objectweb.jorm.mi2xml.lib.BasicDomWriter");
        prop.put("jorm.mapper.list", "rdb");
        prop.put("jorm.mapper.mifactory.rdb", "org.objectweb.jorm.mapper.rdb.metainfo.RdbMappingFactory");
        prop.put("jorm.mapper.mopfactory.rdb", "org.objectweb.jorm.mapper.rdb.generator.RdbMOPFactory");
        prop.put("jorm.mapper.gcmapping.rdb", "org.objectweb.jorm.mapper.rdb.genclass.RdbGenClassMapping");
        prop.put("jorm.mapper.schmgr.rdb", "org.objectweb.jorm.mapper.rdb.lib.RdbPMappingStructuresManager");
        prop.put("jorm.mapper.writer.rdb", "org.objectweb.jorm.mapper.rdb.mi2xml.RdbDomtreeBuilder");
        prop.put("use.context.classloader", "true");
        prop.put("jorm.mapper.submappers.rdb", "generic");
        jcc.configure(prop);
        jcc.setLoggerFactory(Log.getLoggerFactory());
        jormCompiler.setMIManager(miManager);
        return jormCompiler;
    }

    private VelocityEngine allocateVelocityEngine() throws GenICException {
        VelocityEngine ve = new VelocityEngine();
        String packageName = this.getClass().getPackage().getName();
        packageName = packageName.replace('.', '/');
        ve.setProperty("velocimacro.library", packageName + "/GenICMacros.vm");
        ve.setProperty("resource.loader", "class");
        ve.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
        try {
            ve.init();
        }
        catch (Exception e) {
            throw new GenICException("Cannot initialize the Velocity engine", e);
        }
        return ve;
    }

    public void compilClasses(String classpath, ClassLoader loader) throws GenICException {
        if (!this.generatedIC) {
            return;
        }
        String cmdRmic = javaHomeBin + "rmic";
        ArrayList<String> sources = new ArrayList<String>();
        for (String srcName : this.remoteJavas) {
            if (srcName.contains(this.outputdir)) {
                sources.add(srcName.substring(this.outputdir.length() + 1));
            } else {
                sources.add(srcName.substring(this.canonicalOutputdir.length() + 1));
            }
            this.filesToDelete.add(srcName);
        }
        for (String srcName : this.noRemoteJavas) {
            if (srcName.contains(this.outputdir)) {
                sources.add(srcName.substring(this.outputdir.length() + 1));
            } else {
                sources.add(srcName.substring(this.canonicalOutputdir.length() + 1));
            }
            this.filesToDelete.add(srcName);
        }
        File out = new File(this.outputdir);
        CompilationContext context = new CompilationContext();
        context.setContextualClassLoader(loader);
        context.setOutputDirectory(out);
        context.setSourceDirectory(out);
        context.setSources(sources);
        JOnASCompiler compiler = new JOnASCompiler(context);
        logger.log(BasicLevel.INFO, (Object)"Compiling Interposition classes ...");
        List errors = compiler.compile();
        if (!errors.isEmpty()) {
            for (CompilerError error : errors) {
                logger.log(BasicLevel.ERROR, (Object)error.toString());
            }
            throw new GenICException("Failed when compiling the generated classes");
        }
        logger.log(BasicLevel.INFO, (Object)"Sources classes successfully compiled with Eclipse compiler.");
        if (this.remoteJavas.size() == 0) {
            return;
        }
        if (!new File(cmdRmic).exists() && !new File(cmdRmic + ".exe").exists()) {
            logger.log(BasicLevel.INFO, (Object)("No rmic command was found at '" + cmdRmic + "'. Check that you are using a JDK and not a JRE."));
        }
        Cmd jrmpCmd = new Cmd(cmdRmic, this.gp.isInvokeCmd());
        jrmpCmd.addArgument("-classpath");
        jrmpCmd.addArgument(classpath);
        Cmd iiopCmd = new Cmd(cmdRmic, this.gp.isInvokeCmd());
        iiopCmd.addArgument("-classpath");
        iiopCmd.addArgument(classpath);
        iiopCmd.addArgument("-iiop");
        iiopCmd.addArgument("-poa");
        iiopCmd.addArgument("-always");
        if (!"".equals(this.outputdir)) {
            jrmpCmd.addArgument("-d");
            jrmpCmd.addArgument(this.outputdir);
            iiopCmd.addArgument("-d");
            iiopCmd.addArgument(this.outputdir);
        }
        jrmpCmd.addArguments((List)this.gp.getRmicOptions());
        iiopCmd.addArguments((List)this.gp.getRmicOptions());
        for (String className : this.remoteClasses) {
            jrmpCmd.addArgument(className);
            iiopCmd.addArgument(className);
        }
        if (this.gp.getProtocols().isSupported("jrmp") && this.gp.isFastRmicEnabled()) {
            ArrayList args = new ArrayList();
            boolean skip = true;
            Iterator it = jrmpCmd.getCommandLine();
            while (it.hasNext()) {
                Object o = it.next();
                if (skip) {
                    skip = false;
                    continue;
                }
                args.add(o);
            }
            String[] a = args.toArray(new String[0]);
            Method m = null;
            try {
                Class<?> c = Class.forName("org.ow2.fastrmic.RMIC");
                m = c.getMethod("main", String[].class);
            }
            catch (ClassNotFoundException cnfe) {
                logger.log(BasicLevel.ERROR, (Object)"continuing after class not found ", (Throwable)cnfe);
                this.gp.setFastRmicEnabled(false);
            }
            catch (NoSuchMethodException nsme) {
                logger.log(BasicLevel.ERROR, (Object)"continuing after no such method ", (Throwable)nsme);
                this.gp.setFastRmicEnabled(false);
            }
            if (m != null) {
                logger.log(BasicLevel.INFO, (Object)"Running fastrmic");
                try {
                    m.invoke(null, new Object[]{a});
                    System.gc();
                }
                catch (IllegalAccessException iae) {
                    logger.log(BasicLevel.ERROR, (Object)"continuing after illegal access", (Throwable)iae);
                    this.gp.setFastRmicEnabled(false);
                }
                catch (InvocationTargetException ite) {
                    throw new GenICException("error in fastrmic", ite);
                }
                logger.log(BasicLevel.INFO, (Object)"Stubs and Skels successfully generated with fastrmic for rmi/jrmp");
            }
        }
        if (this.gp.getProtocols().isSupported("jrmp") && !this.gp.isFastRmicEnabled()) {
            logger.log(BasicLevel.INFO, (Object)("Running '" + jrmpCmd.toString() + "'"));
            if (jrmpCmd.run()) {
                logger.log(BasicLevel.INFO, (Object)"Stubs and Skels successfully generated for rmi/jrmp");
            } else {
                throw new GenICException("Failed when generating the Stubs and Skels with rmic jrmp");
            }
        }
        if (this.gp.getProtocols().isSupported("iiop")) {
            logger.log(BasicLevel.INFO, (Object)("Running '" + iiopCmd.toString() + "'"));
            if (iiopCmd.run()) {
                logger.log(BasicLevel.INFO, (Object)"Stubs and Skels successfully generated for rmi/iiop");
            } else {
                throw new GenICException("Failed when generating the Stubs and Skels with rmic iiop");
            }
        }
    }

    public void addClassesInJar() throws GenICException {
        if (!this.generatedIC) {
            File wc = new File(this.gp.getWorkingFilename());
            File original = new File(this.gp.getOriginalFilename());
            wc.renameTo(original);
            return;
        }
        this.filesToDelete.add(this.outputdir);
        ArrayList lf = new ArrayList();
        GenIC.getFilesList(this.outputdir, lf, !this.gp.isKeepGenerated());
        this.updateJar(lf);
    }

    protected String convertName(String name) {
        return name.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJar(List lfn) throws GenICException {
        File target = null;
        File workingCopy = null;
        ZipFile wcJarArchive = null;
        ZipOutputStream finalJarArchive = null;
        try {
            JarEntry entry;
            target = new File(this.gp.getOriginalFilename());
            workingCopy = new File(this.gp.getWorkingFilename());
            wcJarArchive = new JarFile(workingCopy);
            finalJarArchive = new JarOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[4096];
            int read = 0;
            FileInputStream file = null;
            int is = this.outputdir.length() + 1;
            Iterator iterFiles = lfn.iterator();
            while (iterFiles.hasNext()) {
                try {
                    String fileName = (String)iterFiles.next();
                    file = new FileInputStream(fileName);
                    entry = new JarEntry(this.convertName(fileName.substring(is)));
                    ((JarOutputStream)finalJarArchive).putNextEntry(entry);
                    while ((read = file.read(buffer)) != -1) {
                        finalJarArchive.write(buffer, 0, read);
                    }
                }
                finally {
                    file.close();
                }
            }
            Enumeration<JarEntry> ents = ((JarFile)wcJarArchive).entries();
            while (ents.hasMoreElements()) {
                entry = ents.nextElement();
                if (lfn.contains(this.outputdir + File.separator + entry.getName().replace('/', File.separatorChar))) continue;
                InputStream enStream = ((JarFile)wcJarArchive).getInputStream(entry);
                entry.setCompressedSize(-1L);
                ((JarOutputStream)finalJarArchive).putNextEntry(entry);
                while ((read = enStream.read(buffer)) != -1) {
                    finalJarArchive.write(buffer, 0, read);
                }
                enStream.close();
                enStream = null;
            }
        }
        catch (Exception e) {
            throw new GenICException("Failed when adding the generated classes in the given ejb-jar file '" + this.gp.getOriginalFilename(), e);
        }
        finally {
            try {
                wcJarArchive.close();
            }
            catch (IOException ioe) {
                logger.log(BasicLevel.WARN, (Object)("Failed to close jar archive file '" + wcJarArchive.getName() + "': " + ioe.getMessage()));
            }
            wcJarArchive = null;
            try {
                finalJarArchive.close();
            }
            catch (IOException ioe) {
                logger.log(BasicLevel.WARN, (Object)("Failed to close temporary jar archive file '" + wcJarArchive.getName() + "': " + ioe.getMessage()));
            }
            finalJarArchive = null;
        }
        if (!workingCopy.delete()) {
            logger.log(BasicLevel.WARN, (Object)("Failed to delete working copy jar archive file '" + workingCopy + "'"));
        }
    }

    public void clean() {
        logger.log(BasicLevel.INFO, (Object)("Deleting " + this.filesToDelete.toString()));
        for (String name : this.filesToDelete) {
            File f = new File(name);
            this.delete(f);
        }
    }

    private boolean delete(File f) {
        if (f.isFile()) {
            return f.delete();
        }
        File[] childs = f.listFiles();
        if (childs == null) {
            return f.delete();
        }
        boolean result = true;
        for (int i = 0; i < childs.length; ++i) {
            result &= this.delete(childs[i]);
        }
        return result && f.delete();
    }

    static void usage() {
        StringBuffer msg = new StringBuffer();
        msg.append("Usage: java org.ow2.jonas.generators.genic.GenIC -help \n");
        msg.append("         to print this help message \n");
        msg.append(" or    java org.ow2.jonas.generators.genic.GenIC <Options> <Input_File> \n");
        msg.append("         to generate the container-specific classes for given EJB(s). \n");
        msg.append(" \n");
        msg.append("Options include: \n");
        msg.append("       -d <output_dir>  specify where to place the generated files \n");
        msg.append("       -noaddinjar      do not add the generated classes in the given \n");
        msg.append("                        ejb-jar file \n");
        msg.append("       -nocompil        do not compile the generated source files via \n");
        msg.append("                        the java and rmi compilers \n");
        msg.append("       -novalidation    parse the XML deployment descriptors without \n");
        msg.append("                        validation \n");
        msg.append("       -classpath <path> define the classpath to be used to compile classes \n");
        msg.append("       -javac     <opt> specify the java compiler to use \n");
        msg.append("       -javacopts <opt> specify the options to pass to the java compiler \n");
        msg.append("       -rmicopts  <opt> specify the options to pass to the rmi compiler \n");
        msg.append("       -protocols       list of protocol, separated by comma \n");
        msg.append("                        (default is jrmp) \n");
        msg.append("       -invokecmd       invoke, in some case, directly the method of the java class\n");
        msg.append("                        corresponding to the command \n");
        msg.append("       -keepgenerated   do not delete intermediate generated source files \n");
        msg.append("       -verbose \n");
        msg.append("       -debug           deprecated (use the JOnAS trace properties file)\n");
        msg.append(" \n");
        msg.append("       Input_File       standard deployment descriptor file's name or \n");
        msg.append("                        ejb-jar file's name \n");
        logger.log(BasicLevel.ERROR, (Object)msg.toString());
    }

    static void fatalError(String msg, Exception e) {
        logger.log(BasicLevel.ERROR, (Object)("GenIC fatal error: " + msg + e.getMessage()));
        throw new RuntimeException(msg, e);
    }

    static void fatalError(Exception e) {
        logger.log(BasicLevel.ERROR, (Object)("GenIC fatal error: " + e.getMessage()));
        throw new RuntimeException(e.getMessage(), e);
    }

    static String createTempDir() throws IOException {
        File tmpDir = File.createTempFile("genic", null, null);
        tmpDir.delete();
        if (!tmpDir.mkdir()) {
            throw new IOException("Cannot create the temporary directory '" + tmpDir + "'.");
        }
        return tmpDir.getAbsolutePath();
    }

    static void getFilesList(String dir, ArrayList list, boolean onlyClass) {
        File df = new File(dir);
        if (df.exists() && df.isDirectory()) {
            File[] ls = df.listFiles();
            for (int i = 0; i < ls.length; ++i) {
                File f = ls[i];
                String fn = f.getAbsolutePath();
                if (f.isDirectory()) {
                    GenIC.getFilesList(fn, list, onlyClass);
                    continue;
                }
                if (onlyClass && !fn.endsWith(".class") || fn.endsWith(".save")) continue;
                list.add(fn);
            }
        }
    }
}

