/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.service;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.reconfig.ReconfigEmitter;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.service.Service;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsServiceImpl
extends ReconfigEmitter
implements Service {
    private static Logger logger = Log.getLogger("org.ow2.jonas.service");
    private String name = null;
    private boolean started = false;
    private ServerProperties serverProps;

    public void init(Context ctx) throws ServiceException {
        this.doInit(ctx);
    }

    public ServerProperties getServerProperties() {
        return this.serverProps;
    }

    public void setServerProperties(ServerProperties props) {
        this.serverProps = props;
    }

    public void start() throws ServiceException {
        this.doStart();
        this.started = true;
    }

    public void stop() throws ServiceException {
        if (this.isStarted()) {
            this.doStop();
            this.started = false;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomainName() {
        return this.serverProps.getDomainName();
    }

    public String getJonasServerName() {
        return this.serverProps.getServerName();
    }

    @Deprecated
    protected void doInit(Context ctx) throws ServiceException {
        logger.log(BasicLevel.WARN, (Object)"Deprecated initialization method. New services must have setters.");
    }

    protected abstract void doStart() throws ServiceException;

    protected abstract void doStop() throws ServiceException;

    public String toString() {
        return this.getClass().getSimpleName() + "[name:" + this.getName() + ", started:" + this.isStarted() + "]";
    }

    protected void throwRequirementException(String message) throws ServiceException {
        StringBuilder sb = new StringBuilder();
        sb.append("Service: '" + this.getName() + "' requires: ");
        sb.append(message);
        throw new ServiceException(sb.toString());
    }

    protected static List<String> convertToList(String value) {
        String[] values = value.split(",");
        ArrayList<String> injection = new ArrayList<String>();
        if (values.length != 1 || !"".equals(values[0])) {
            for (int i = 0; i < values.length; ++i) {
                String part = values[i];
                injection.add(part.trim());
            }
        }
        return injection;
    }
}

