/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.ow2.jonas.ant.JOnASAntTool;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.Carol;
import org.ow2.jonas.ant.jonasbase.Db;
import org.ow2.jonas.ant.jonasbase.Dbm;
import org.ow2.jonas.ant.jonasbase.Discovery;
import org.ow2.jonas.ant.jonasbase.JMkdir;
import org.ow2.jonas.ant.jonasbase.JdbcRa;
import org.ow2.jonas.ant.jonasbase.Jms;
import org.ow2.jonas.ant.jonasbase.JonasProperties;
import org.ow2.jonas.ant.jonasbase.Lib;
import org.ow2.jonas.ant.jonasbase.Mail;
import org.ow2.jonas.ant.jonasbase.Services;
import org.ow2.jonas.ant.jonasbase.Tasks;
import org.ow2.jonas.ant.jonasbase.WebContainer;
import org.ow2.jonas.ant.jonasbase.jaas.Jaas;
import org.ow2.jonas.ant.jonasbase.wsdl.WsdlPublish;

public class JOnASBaseTask
extends Task {
    public static final String JONAS_CONF_FILE = "jonas.properties";
    public static final String JORAM_CONF_FILE = "a3servers.xml";
    public static final String JORAM_ADMIN_CONF_FILE = "joramAdmin.xml";
    public static final String CAROL_CONF_FILE = "carol.properties";
    public static final String JGROUPS_CMI_CONF_FILE = "jgroups-cmi.xml";
    public static final String JGROUPS_HA_CONF_FILE = "jgroups-ha.xml";
    public static final String TOMCAT_CONF_FILE = "tomcat6-server.xml";
    public static final String JETTY_CONF_FILE = "jetty6.xml";
    public static final String P6SPY_CONF_FILE = "spy.properties";
    public static final String DOMAIN_CONF_FILE = "domain.xml";
    public static final String JAAS_CONF_FILE = "jaas.config";
    public static final String LOG_DIR_NAME = "logs";
    public static final String DEPLOY_DIR_NAME = "deploy";
    public static final String LIB_EXT_DIR_NAME = "lib/ext";
    private File jonasRoot = null;
    private File destDir = null;
    private boolean onlyUpdate = false;
    private List tasks = new ArrayList();

    public void execute() {
        if (this.jonasRoot == null) {
            throw new BuildException("jonasRoot element is not set");
        }
        if (this.destDir == null) {
            throw new BuildException("destDir element is not set");
        }
        if (this.jonasRoot.getPath().equals(this.destDir.getPath())) {
            throw new BuildException("jonasRoot and destDir is the same path !");
        }
        File jprops = new File(this.destDir.getPath() + File.separator + "conf" + File.separator + JONAS_CONF_FILE);
        if (this.onlyUpdate) {
            if (jprops.exists()) {
                this.log("Only updating JONAS_BASE in the directory '" + this.destDir + "' from source directory '" + this.jonasRoot + "'", 2);
                JOnASAntTool.updateJonasBase(this, this.jonasRoot, this.destDir, null);
                return;
            }
            throw new BuildException("JOnAS base directory '" + this.destDir.getPath() + "' doesn't exists. Cannot update.");
        }
        this.log("Creating JONAS_BASE in the directory '" + this.destDir + "' from source directory '" + this.jonasRoot + "'", 2);
        Copy copy = new Copy();
        JOnASAntTool.configure(this, (Task)copy);
        copy.setTodir(this.destDir);
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(new File(this.jonasRoot, "templates"), "conf"));
        copy.addFileset(fileSet);
        copy.setOverwrite(true);
        copy.execute();
        this.log("Creating logs in the directory '" + this.destDir, 2);
        JMkdir mkdir = new JMkdir();
        JOnASAntTool.configure(this, (Task)mkdir);
        mkdir.setDestDir(new File(this.destDir + File.separator + LOG_DIR_NAME));
        mkdir.execute();
        this.log("Creating deploy in the directory '" + this.destDir, 2);
        mkdir = new JMkdir();
        JOnASAntTool.configure(this, (Task)mkdir);
        mkdir.setDestDir(new File(this.destDir + File.separator + DEPLOY_DIR_NAME));
        mkdir.execute();
        this.log("Creating lib/ext in the directory '" + this.destDir, 2);
        mkdir = new JMkdir();
        JOnASAntTool.configure(this, (Task)mkdir);
        mkdir.setDestDir(new File(this.destDir + File.separator + LIB_EXT_DIR_NAME));
        mkdir.execute();
        for (Object o : this.tasks) {
            BaseTaskItf task;
            if (o instanceof BaseTaskItf) {
                task = (BaseTaskItf)o;
                task.setDestDir(this.destDir);
                task.setJonasRoot(this.jonasRoot);
                JOnASAntTool.configure(this, (Task)task);
                String info = task.getLogInfo();
                if (info != null) {
                    this.log(info, 2);
                }
                task.execute();
                continue;
            }
            task = (Task)o;
            JOnASAntTool.configure(this, (Task)task);
            task.execute();
        }
        JOnASAntTool.updateJonasBase(this, this.jonasRoot, this.destDir, null);
    }

    public void addTasks(Tasks subTasks) {
        if (subTasks != null) {
            Iterator<Task> it = subTasks.getTasks().iterator();
            while (it.hasNext()) {
                this.tasks.add(it.next());
            }
        }
    }

    public void addTask(BaseTaskItf task) {
        if (task != null) {
            this.tasks.add(task);
        }
    }

    public void addConfiguredServices(Services servicesTasks) {
        this.addTask(servicesTasks);
    }

    public void addConfiguredJonasProperties(JonasProperties servicesTasks) {
        this.addTask(servicesTasks);
    }

    public void addConfiguredJms(Jms jmsTasks) {
        this.addTasks(jmsTasks);
    }

    public void addConfiguredJdbcRa(JdbcRa jdbcRaTask) {
        this.addTask(jdbcRaTask);
    }

    public void addConfiguredMail(Mail mailTask) {
        this.addTask(mailTask);
    }

    public void addConfiguredDb(Db dbTask) {
        this.addTask(dbTask);
    }

    public void addConfiguredDbm(Dbm dbTask) {
        this.addTask(dbTask);
    }

    public void addConfiguredLib(Lib libTask) {
        this.addTask(libTask);
    }

    public void addConfiguredWsdlPublish(WsdlPublish wsdlTask) {
        this.addTask(wsdlTask);
    }

    public void addConfiguredCarol(Carol carolTasks) {
        this.addTask(carolTasks);
    }

    public void addConfiguredDiscovery(Discovery discoveryTasks) {
        this.addTasks(discoveryTasks);
    }

    public void addConfiguredWebContainer(WebContainer webContainerTasks) {
        this.addTasks(webContainerTasks);
    }

    public void addConfiguredJaas(Jaas jaasTasks) {
        this.addTasks(jaasTasks);
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setJonasRoot(File jonasRoot) {
        this.jonasRoot = jonasRoot;
    }

    public void setUpdate(boolean onlyUpdate) {
        this.onlyUpdate = onlyUpdate;
    }
}

