/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase;

import org.apache.tools.ant.Task;
import org.ow2.jonas.ant.jonasbase.JReplace;
import org.ow2.jonas.ant.jonasbase.Tasks;
import org.ow2.jonas.ant.jonasbase.web.Jetty;
import org.ow2.jonas.ant.jonasbase.web.Tomcat;

public class WebContainer
extends Tasks {
    private static final String INFO = "[WebContainer] ";
    private static final String JETTY_SERVICE = "org.ow2.jonas.web.jetty6.Jetty6Service";
    private static final String TOMCAT_SERVICE = "org.ow2.jonas.web.tomcat6.Tomcat6Service";
    private static final String DEFAULT_SERVICE = "org.ow2.jonas.web.tomcat6.Tomcat6Service";
    private static final String DEFAULT_PORT = "9000";
    private static final String ONDEMANDENABLED = "jonas.service.web.ondemand.enabled";
    private static final String ONDEMANDENABLEDTOKEN = "jonas.service.web.ondemand.enabled    true";
    private static final String ONDEMANDREDIRECTPORT = "jonas.service.web.ondemand.redirectPort";
    private static final String ONDEMANDREDIRECTPORTTOKEN = "jonas.service.web.ondemand.redirectPort    0";
    private boolean serviceNameSet = false;

    public void setPort(String portNumber) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("tomcat6-server.xml");
        propertyReplace.setToken(DEFAULT_PORT);
        propertyReplace.setValue(portNumber);
        propertyReplace.setLogInfo("[WebContainer] Setting Tomcat port number to : " + portNumber);
        this.addTask((Task)propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jetty6.xml");
        propertyReplace.setToken(DEFAULT_PORT);
        propertyReplace.setValue(portNumber);
        propertyReplace.setLogInfo("[WebContainer] Setting Jetty port number to : " + portNumber);
        this.addTask((Task)propertyReplace);
    }

    public void setName(String containerName) {
        if ("jetty".equalsIgnoreCase(containerName)) {
            this.addTask(this.createServiceNameReplace(JETTY_SERVICE));
            this.serviceNameSet = true;
        } else if ("tomcat".equalsIgnoreCase(containerName)) {
            this.addTask(this.createServiceNameReplace("org.ow2.jonas.web.tomcat6.Tomcat6Service"));
            this.serviceNameSet = true;
        }
    }

    public void setOndemandenabled(String ondemandenabled) {
        String token = ONDEMANDENABLEDTOKEN;
        String value = "jonas.service.web.ondemand.enabled    " + ondemandenabled;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jonas.properties");
        propertyReplace.setToken(token);
        propertyReplace.setValue(value);
        propertyReplace.setLogInfo("[WebContainer] Setting jonas.service.web.ondemand.enabled to " + ondemandenabled);
        this.addTask((Task)propertyReplace);
    }

    public void setOndemandredirectPort(String portNumber) {
        String token = ONDEMANDREDIRECTPORTTOKEN;
        String value = "jonas.service.web.ondemand.redirectPort    " + portNumber;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jonas.properties");
        propertyReplace.setToken(token);
        propertyReplace.setValue(value);
        propertyReplace.setLogInfo("[WebContainer] Setting jonas.service.web.ondemand.redirectPort to " + portNumber);
        this.addTask((Task)propertyReplace);
    }

    private Task createServiceNameReplace(String serviceName) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jonas.properties");
        propertyReplace.setToken("org.ow2.jonas.web.tomcat6.Tomcat6Service");
        propertyReplace.setValue(serviceName);
        propertyReplace.setLogInfo("[WebContainer] Setting service to : " + serviceName);
        return propertyReplace;
    }

    public void addConfiguredJetty(Jetty jetty) {
        if (!this.serviceNameSet) {
            this.addTask(this.createServiceNameReplace(JETTY_SERVICE));
            this.serviceNameSet = true;
        }
        this.addTasks(jetty);
    }

    public void addConfiguredTomcat(Tomcat tomcat) {
        if (!this.serviceNameSet) {
            this.addTask(this.createServiceNameReplace("org.ow2.jonas.web.tomcat6.Tomcat6Service"));
            this.serviceNameSet = true;
        }
        this.addTasks(tomcat);
    }
}

