/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.persistence.TxEntityManagerLifeCycle;
import org.ow2.easybeans.transaction.JTransactionManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class TxEntityManagerHandler {
    private Log logger = LogFactory.getLog(TxEntityManagerHandler.class);
    private EntityManagerFactory entityManagerFactory = null;
    private Map<Transaction, EntityManager> entityManagers = null;

    public TxEntityManagerHandler(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.entityManagers = new HashMap<Transaction, EntityManager>();
    }

    public synchronized EntityManager getCurrent() {
        EntityManager current = null;
        Transaction currentTx = null;
        try {
            currentTx = JTransactionManager.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot get current transaction", e);
        }
        if (currentTx == null) {
            return this.buildNoTxEntityManager();
        }
        current = this.entityManagers.get(currentTx);
        if (current == null) {
            current = this.buildNewTxEntityManager(currentTx);
        }
        return current;
    }

    private EntityManager buildNewTxEntityManager(Transaction tx) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            tx.registerSynchronization((Synchronization)new TxEntityManagerLifeCycle(entityManager, tx, this));
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Cannot register Entity manager lifecycle", e);
        }
        catch (RollbackException e) {
            throw new IllegalStateException("Cannot register Entity manager lifecycle", e);
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot register Entity manager lifecycle", e);
        }
        this.entityManagers.put(tx, entityManager);
        return entityManager;
    }

    private EntityManager buildNoTxEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public void release(Transaction tx) {
        this.entityManagers.remove(tx);
    }
}

