/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.moduleloader;

import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.ContentLoaderImpl;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IModuleDefinition;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class ModuleImpl
implements IModule {
    private Logger m_logger = null;
    private String m_id = null;
    private IModuleDefinition m_md = null;
    private IContentLoader m_contentLoader = null;
    private IModule[] m_fragments = null;
    private IWire[] m_wires = null;
    private IModule[] m_dependentHosts = new IModule[0];
    private IModule[] m_dependentImporters = new IModule[0];
    private IModule[] m_dependentRequirers = new IModule[0];
    private volatile boolean m_isStale = false;

    ModuleImpl(Logger logger, String id, IModuleDefinition md) {
        this.m_logger = logger;
        this.m_id = id;
        this.m_md = md;
    }

    public String getId() {
        return this.m_id;
    }

    public IModuleDefinition getDefinition() {
        return this.m_md;
    }

    public IContentLoader getContentLoader() {
        return this.m_contentLoader;
    }

    protected void setContentLoader(IContentLoader contentLoader) {
        this.m_contentLoader = contentLoader;
    }

    public synchronized IModule[] getFragments() {
        return this.m_fragments;
    }

    public synchronized void attachFragments(IModule[] fragments) throws Exception {
        for (int i = 0; this.m_fragments != null && i < this.m_fragments.length; ++i) {
            ((ModuleImpl)this.m_fragments[i]).removeDependentHost(this);
        }
        this.m_fragments = fragments;
        if (this.m_fragments != null) {
            IContent[] fragmentContents = new IContent[this.m_fragments.length];
            for (int i = 0; this.m_fragments != null && i < this.m_fragments.length; ++i) {
                ((ModuleImpl)this.m_fragments[i]).addDependentHost(this);
                fragmentContents[i] = this.m_fragments[i].getContentLoader().getContent().getEntryAsContent(".");
            }
            ((ContentLoaderImpl)this.m_contentLoader).attachFragmentContents(fragmentContents);
        }
    }

    public synchronized IWire[] getWires() {
        return this.m_wires;
    }

    public synchronized void setWires(IWire[] wires) {
        int i;
        for (i = 0; this.m_wires != null && i < this.m_wires.length; ++i) {
            if (this.m_wires[i].getCapability().getNamespace().equals("module")) {
                ((ModuleImpl)this.m_wires[i].getExporter()).removeDependentRequirer(this);
                continue;
            }
            if (!this.m_wires[i].getCapability().getNamespace().equals("package")) continue;
            ((ModuleImpl)this.m_wires[i].getExporter()).removeDependentImporter(this);
        }
        this.m_wires = wires;
        for (i = 0; this.m_wires != null && i < this.m_wires.length; ++i) {
            if (this.m_wires[i].getCapability().getNamespace().equals("module")) {
                ((ModuleImpl)this.m_wires[i].getExporter()).addDependentRequirer(this);
                continue;
            }
            if (!this.m_wires[i].getCapability().getNamespace().equals("package")) continue;
            ((ModuleImpl)this.m_wires[i].getExporter()).addDependentImporter(this);
        }
    }

    public synchronized IModule[] getDependentHosts() {
        return this.m_dependentHosts;
    }

    public synchronized void addDependentHost(IModule module) {
        this.m_dependentHosts = ModuleImpl.addDependent(this.m_dependentHosts, module);
    }

    public synchronized void removeDependentHost(IModule module) {
        this.m_dependentHosts = ModuleImpl.removeDependent(this.m_dependentHosts, module);
    }

    public synchronized IModule[] getDependentImporters() {
        return this.m_dependentImporters;
    }

    public synchronized void addDependentImporter(IModule module) {
        this.m_dependentImporters = ModuleImpl.addDependent(this.m_dependentImporters, module);
    }

    public synchronized void removeDependentImporter(IModule module) {
        this.m_dependentImporters = ModuleImpl.removeDependent(this.m_dependentImporters, module);
    }

    public synchronized IModule[] getDependentRequirers() {
        return this.m_dependentRequirers;
    }

    public synchronized void addDependentRequirer(IModule module) {
        this.m_dependentRequirers = ModuleImpl.addDependent(this.m_dependentRequirers, module);
    }

    public synchronized void removeDependentRequirer(IModule module) {
        this.m_dependentRequirers = ModuleImpl.removeDependent(this.m_dependentRequirers, module);
    }

    public synchronized IModule[] getDependents() {
        IModule[] dependents = new IModule[this.m_dependentHosts.length + this.m_dependentImporters.length + this.m_dependentRequirers.length];
        System.arraycopy(this.m_dependentHosts, 0, dependents, 0, this.m_dependentHosts.length);
        System.arraycopy(this.m_dependentImporters, 0, dependents, this.m_dependentHosts.length, this.m_dependentImporters.length);
        System.arraycopy(this.m_dependentRequirers, 0, dependents, this.m_dependentHosts.length + this.m_dependentImporters.length, this.m_dependentRequirers.length);
        return dependents;
    }

    public Class getClass(String name) throws ClassNotFoundException {
        try {
            return this.m_contentLoader.getSearchPolicy().findClass(name);
        }
        catch (ClassNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            throw ex;
        }
    }

    public URL getResource(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResource(name);
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            return null;
        }
    }

    public Enumeration getResources(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResources(name);
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            return null;
        }
    }

    public boolean isStale() {
        return this.m_isStale;
    }

    public void setStale() {
        this.m_isStale = true;
    }

    public String toString() {
        return this.m_id;
    }

    private static IModule[] addDependent(IModule[] modules, IModule module) {
        for (int i = 0; i < modules.length; ++i) {
            if (!modules[i].equals(module)) continue;
            return modules;
        }
        IModule[] tmp = new IModule[modules.length + 1];
        System.arraycopy(modules, 0, tmp, 0, modules.length);
        tmp[modules.length] = module;
        return tmp;
    }

    private static IModule[] removeDependent(IModule[] modules, IModule module) {
        IModule[] tmp = modules;
        for (int i = 0; i < modules.length; ++i) {
            if (!modules[i].equals(module)) continue;
            if (modules.length - 1 == 0) {
                tmp = new IModule[]{};
                break;
            }
            tmp = new IModule[modules.length - 1];
            System.arraycopy(modules, 0, tmp, 0, i);
            if (i >= tmp.length) break;
            System.arraycopy(modules, i + 1, tmp, i, tmp.length - i);
            break;
        }
        return tmp;
    }
}

