/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.IndexInput;

final class TermBuffer
implements Cloneable {
    private static final char[] NO_CHARS = new char[0];
    private String field;
    private char[] text = NO_CHARS;
    private int textLength;
    private Term term;

    TermBuffer() {
    }

    public final int compareTo(TermBuffer other) {
        if (this.field == other.field) {
            return TermBuffer.compareChars(this.text, this.textLength, other.text, other.textLength);
        }
        return this.field.compareTo(other.field);
    }

    private static final int compareChars(char[] v1, int len1, char[] v2, int len2) {
        int end = Math.min(len1, len2);
        for (int k = 0; k < end; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    private final void setTextLength(int newLength) {
        if (this.text.length < newLength) {
            char[] newText = new char[newLength];
            System.arraycopy(this.text, 0, newText, 0, this.textLength);
            this.text = newText;
        }
        this.textLength = newLength;
    }

    public final void read(IndexInput input, FieldInfos fieldInfos) throws IOException {
        this.term = null;
        int start = input.readVInt();
        int length = input.readVInt();
        int totalLength = start + length;
        this.setTextLength(totalLength);
        input.readChars(this.text, start, length);
        this.field = fieldInfos.fieldName(input.readVInt());
    }

    public final void set(Term term) {
        if (term == null) {
            this.reset();
            return;
        }
        this.setTextLength(term.text().length());
        term.text().getChars(0, term.text().length(), this.text, 0);
        this.field = term.field();
        this.term = term;
    }

    public final void set(TermBuffer other) {
        this.setTextLength(other.textLength);
        System.arraycopy(other.text, 0, this.text, 0, this.textLength);
        this.field = other.field;
        this.term = other.term;
    }

    public void reset() {
        this.field = null;
        this.textLength = 0;
        this.term = null;
    }

    public Term toTerm() {
        if (this.field == null) {
            return null;
        }
        if (this.term == null) {
            this.term = new Term(this.field, new String(this.text, 0, this.textLength), false);
        }
        return this.term;
    }

    protected Object clone() {
        TermBuffer clone = null;
        try {
            clone = (TermBuffer)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.text = new char[this.text.length];
        System.arraycopy(this.text, 0, clone.text, 0, this.textLength);
        return clone;
    }
}

