/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.workqueue;

import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedAttribute;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.workqueue.WorkQueueManagerImpl;

@ManagedResource(componentName="WorkQueue", description="The CXF work queue", currencyTimeLimit=15, persistPolicy="OnUpdate", persistPeriod=200)
public class WorkQueueImplMBeanWrapper
implements ManagedComponent {
    private static final String TYPE_VALUE = "WorkQueues";
    private AutomaticWorkQueueImpl aWorkQueue;

    public WorkQueueImplMBeanWrapper(AutomaticWorkQueueImpl wq) {
        this.aWorkQueue = wq;
    }

    @ManagedAttribute(description="The WorkQueueMaxSize", persistPolicy="OnUpdate")
    public long getWorkQueueMaxSize() {
        return this.aWorkQueue.getMaxSize();
    }

    @ManagedAttribute(description="The WorkQueue Current size", persistPolicy="OnUpdate")
    public long getWorkQueueSize() {
        return this.aWorkQueue.getSize();
    }

    @ManagedAttribute(description="The WorkQueue has nothing to do", persistPolicy="OnUpdate")
    public boolean isEmpty() {
        return this.aWorkQueue.isEmpty();
    }

    @ManagedAttribute(description="The WorkQueue is very busy")
    public boolean isFull() {
        return this.aWorkQueue.isFull();
    }

    @ManagedAttribute(description="The WorkQueue HighWaterMark", persistPolicy="OnUpdate")
    public int getHighWaterMark() {
        return this.aWorkQueue.getHighWaterMark();
    }

    public void setHighWaterMark(int hwm) {
        this.aWorkQueue.setHighWaterMark(hwm);
    }

    @ManagedAttribute(description="The WorkQueue LowWaterMark", persistPolicy="OnUpdate")
    public int getLowWaterMark() {
        return this.aWorkQueue.getLowWaterMark();
    }

    public void setLowWaterMark(int lwm) {
        this.aWorkQueue.setLowWaterMark(lwm);
    }

    public ObjectName getObjectName() throws JMException {
        WorkQueueManager mgr = this.aWorkQueue.getManager();
        String busId = "cxf";
        if (mgr instanceof WorkQueueManagerImpl) {
            busId = ((WorkQueueManagerImpl)mgr).getBus().getId();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("org.apache.cxf:");
        buffer.append("bus.id=" + busId + ",");
        buffer.append("WorkQueueManager=");
        buffer.append("Bus.WorkQueueManager,");
        buffer.append("type=WorkQueues,");
        buffer.append("name=" + this.aWorkQueue.getName());
        return new ObjectName(buffer.toString());
    }
}

